function y = mdsinfo(varargin)

% MDSINFO controls MDS access
%   MDSINFO(P) returns the value of the property P. MDSINFO(P1,V1,...) sets
%   properties to specified values. Properties are 'host', 'service',
%   'experiment', 'shot', 'version' and 'default...'. MDSINFO by itself returns
%   the current state.

persistent MDSINFO
mlock

if isempty(MDSINFO)
	MDSINFO.defaulthost = 'tcvdata.epfl.ch';
	MDSINFO.defaultservice = 'mdsip';
	MDSINFO.defaultexperiment = 'tcv_shot';
	MDSINFO.defaultshot = 0;
 MDSINFO.version = version;
	MDSINFO.host = '';
	MDSINFO.service = '';
	MDSINFO.experiment = '';
	MDSINFO.shot = [];
end

if nargin == 0
	y = MDSINFO;
elseif nargin == 1
 y = getfield(MDSINFO,lower(varargin{1}));
elseif rem(nargin,2) == 0
 for k = 1:2:nargin
		MDSINFO = setfield(MDSINFO,lower(varargin{k}),varargin{k+1});
 end
 if nargout, y = MDSINFO; end
end
