(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    191591,       3523]
NotebookOptionsPosition[    189852,       3486]
NotebookOutlinePosition[    190325,       3503]
CellTagsIndexPosition[    190282,       3500]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Solid Physics III ",
 FontFamily->"Arial",
 FontSize->14,
 FontWeight->"Plain",
 FontColor->GrayLevel[0.5]]], "Title",
 CellMargins->{{0, 0}, {0, 0}},
 CellHorizontalScrolling->True,
 CellFrameMargins->{{16, 16}, {4, 20}},
 CellChangeTimes->{{3.459157557469352*^9, 3.4591575608581867`*^9}, {
  3.459158176643325*^9, 3.459158178176478*^9}, {3.459158282115281*^9, 
  3.459158283410133*^9}, {3.45915834017934*^9, 3.459158369735718*^9}, {
  3.611328020416986*^9, 3.611328021120482*^9}, {3.6526169805227623`*^9, 
  3.6526169858675413`*^9}, {3.653743225031868*^9, 3.653743250501257*^9}, {
  3.6846567440674753`*^9, 3.684656756639138*^9}, {3.9065452530474777`*^9, 
  3.9065452624745083`*^9}, {3.9065453286011553`*^9, 3.906545330471979*^9}},
 TextAlignment->Left,
 FontSize->30,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 Background->GrayLevel[
  0],ExpressionUUID->"5af9acf0-1c3c-4c65-a71c-f7ab277b8a19"],

Cell[TextData[StyleBox["A simple semiconductor and the formation of excitons",
 
 FontFamily->"Arial",
 FontSize->12,
 FontColor->GrayLevel[1]]], "Subtitle",
 CellMargins->{{0, 0}, {8, 0}},
 CellHorizontalScrolling->True,
 CellFrameMargins->{{18, 16}, {8, 8}},
 CellChangeTimes->{{3.4591575767920113`*^9, 3.4591576062359037`*^9}, 
   3.4591582251979218`*^9, 3.459158308260252*^9, {3.611328027716178*^9, 
   3.611328071296974*^9}, {3.652616977597537*^9, 3.652617000322197*^9}, {
   3.653743259500793*^9, 3.653743270756271*^9}, {3.654239882442416*^9, 
   3.654239888978161*^9}, {3.654240504281678*^9, 3.654240517882518*^9}, {
   3.684656759175229*^9, 3.6846567603829107`*^9}, {3.906545270302149*^9, 
   3.906545275698306*^9}},
 FontSize->14,
 Background->GrayLevel[
  0.5],ExpressionUUID->"9f9f883e-63d2-416f-88c5-dac916295fcb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.937544433770768*^9, 
  3.937544456594529*^9}},ExpressionUUID->"5b7209ec-5987-49e1-8aeb-\
bd0965991d68"],

Cell["We set v=|v_a - v_b| / 2", "Text",
 CellChangeTimes->{{3.937544708201806*^9, 
  3.937544751681267*^9}},ExpressionUUID->"2ca82f14-3cad-49f2-8178-\
df8dfc02d599"],

Cell[CellGroupData[{

Cell["Interaction (c)", "Section",
 CellChangeTimes->{{3.654239900106447*^9, 3.65423991006145*^9}, {
  3.684665549401197*^9, 3.684665557382494*^9}, {3.9065453156190968`*^9, 
  3.906545320059572*^9}},ExpressionUUID->"83302b6c-5299-4ae8-b51e-\
a09f9e4254dc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CurlyEpsilon]", "[", 
    RowBox[{"k_", ",", "v_"}], "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "*", "t", "*", 
        RowBox[{"Cos", "[", "k", "]"}]}], ")"}], "2"], "+", 
     SuperscriptBox["v", "2"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\[CurlyEpsilon]", "[", 
  RowBox[{
   RowBox[{"k", "+", "q"}], ",", "v"}], "]"}]}], "Input",
 CellChangeTimes->{{3.559282796669652*^9, 3.559282834476843*^9}, {
  3.654239671630013*^9, 3.6542396991110687`*^9}, {3.654239838456314*^9, 
  3.654239840772854*^9}, {3.6542399121876707`*^9, 3.654239930976301*^9}, {
  3.654246110721936*^9, 3.654246118747513*^9}, {3.654397876916421*^9, 
  3.654397878208301*^9}, {3.684665616196891*^9, 3.6846656227469053`*^9}, {
  3.685942199294948*^9, 3.685942211006481*^9}, {3.685942556094962*^9, 
  3.6859425710359583`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"a3feb665-3e90-4b49-8504-36559e53e7fe"],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox["v", "2"], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["t", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"k", "+", "q"}], "]"}], "2"]}]}]]], "Output",
 CellChangeTimes->{{3.6859412545891943`*^9, 3.6859412729954853`*^9}, {
   3.6859413170517693`*^9, 3.685941327715939*^9}, 3.6859422140539837`*^9, {
   3.6859425634895153`*^9, 3.685942596284514*^9}, 3.685942841309804*^9, 
   3.685942965375458*^9, {3.9065451181382027`*^9, 3.906545121377612*^9}, 
   3.937544769569689*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"d6ec1704-549c-48f5-9527-d9f454a17b66"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"\[Omega]_", ",", "q_", ",", "v_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "L"}]], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", 
      RowBox[{"-", "L"}]}], 
     RowBox[{"L", "-", "1"}]], 
    FractionBox["1", 
     RowBox[{
      RowBox[{"\[CurlyEpsilon]", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"\[Pi]", " ", "i"}], 
         RowBox[{"2", "L"}]], ",", "v"}], "]"}], "+", 
      RowBox[{"\[CurlyEpsilon]", "[", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"\[Pi]", " ", "i"}], 
          RowBox[{"2", "L"}]], "+", "q"}], ",", "v"}], "]"}], "-", 
      "\[Omega]"}]]}]}]}]], "Input",
 CellChangeTimes->{{3.6542397752884827`*^9, 3.6542398351738157`*^9}, {
  3.6542399442215357`*^9, 3.654239969432304*^9}, {3.654398061533421*^9, 
  3.654398063692299*^9}, {3.6543981823325453`*^9, 3.654398184200226*^9}, {
  3.684660174956607*^9, 3.684660198596706*^9}, {3.6846656257341223`*^9, 
  3.684665628267371*^9}, {3.685941406472917*^9, 3.6859414087874117`*^9}, {
  3.685942219294258*^9, 3.685942226165077*^9}, {3.937544842424986*^9, 
  3.937544844182131*^9}, {3.9375448797429457`*^9, 3.937544880314556*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"382f65c7-4d7b-49c4-a5f9-7a85ab93aeec"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", "1.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]", "[", "v_", "]"}], "=", 
   RowBox[{"2", "v"}]}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQPUc8ROF0yytHj+kySiD6wjWFWy8sXzue4NMG0zrz
Ap6DaNX9bC9BdJt9+XcQfcl6zi8Q/XvvDJ6XQLrJkokXRHf8+yH0GkiXzfgq
BqLPK4mpg+gje95qg2i+8stnQLTZ6d9g+sldy0sg+k/wPDCtcq9N+w3IXs1F
uiA66bTve1Or146nU4+Aaa9L7b9BtE7ZBDDtFHNEwQxIBzxVMAHRz6XT/EF0
1JdPYSD63GrFqnfFrx05a1pqQLTTLJaj0WWvHdNevD4NohPmn2FMANKSsjc5
QfQty6hkEB0mWZoGohU+nFoGop90XgDT+xR7r4Hoe2bSt0D0C5XQtyD607F3
70D0xprne1Sk3zqKOb4B0wBMj7l8
  "],
 CellLabel->"In[4]:=",ExpressionUUID->"81983b49-c288-440d-bd04-a617505e80c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"\[Omega]", ",", "q", ",", "v"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Omega]\>\"", ",", 
      "\"\<\!\(\*StyleBox[\"f\",FontSlant->\"Italic\"]\)(\[Omega])\>\""}], 
     "}"}]}], ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.96", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[CapitalDelta]", "[", "v", "]"}], ",", "6"}], "}"}]}], 
       "]"}]}], "}"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"4", "u"}], ")"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"4", "u"}], ")"}]}]}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<1/4u\>\"", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"FontSize", "\[Rule]", "16"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.66", ",", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"4", "u"}], ")"}]}], "+", "0.5"}]}], "}"}]}], "]"}], ",",
       "Black", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"#", ",", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"\[Omega]", ",", "q", ",", "v"}], "]"}], "/.", 
             RowBox[{"\[Omega]", "\[Rule]", "#"}]}]}], "}"}], "]"}], "&"}], 
        ")"}], "/@", 
       RowBox[{"(", 
        RowBox[{"\[Omega]", "/.", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"\[Omega]", ",", "q", ",", "v"}], "]"}], "\[Equal]", 
            RowBox[{"1", "/", 
             RowBox[{"(", 
              RowBox[{"4", "u"}], ")"}]}]}], ",", "\[Omega]"}], "]"}]}], 
        ")"}]}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQ/WZ9gtLplleOixofKIPomN3tOiBabkeLHojeavLX
EURLtYo5geh5irz5IHomv18hiK45JvLgheVrxw2pOo9BdN1B9XcgOsTk3nsQ
bWDnK/YSSCsKRYPpJMfdUiB6rdJ3aRD9LqqB5zWQ9uoulwHReUqBqiC6jdVR
DSz++qQeiNYS5DYB0U9Kz+4A0cveRhwH0Zuifp4G0T92rL4IojP02mTeAOks
zheyIHqTHZ8SiH52R1oVRHe4ZdiaWb12lErU9AHRDzawXXhT/NqR743lJRAt
1LRL9yOQLpu7ywxEe7zYLJJQ9tpRfLWMKIi+01RaDaJZClY2geiAz3OWg+iH
y/eBaRdpnqMg2mr1OzANAEbEtJ4=
  "],
 CellLabel->"In[10]:=",ExpressionUUID->"ace25234-b7e5-4341-a6e7-77e7867bd46a"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwdUwk0lQsXvcZEGUJcpchQmVIpJeyvaESoTD1RQjQgRJFEiCgNSKEk/aYi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          "]], 
         LineBox[{{2.0253997252909666`, -6.}, {
          2.025846542788437, -5.223995978989361}, {
          2.027062670575905, -3.781239979233763}, {
          2.028278798363373, -2.718195603956154}, {
          2.029494926150841, -1.8890168319115048`}, {
          2.030711053938309, -1.211814237128575}, {
          2.031927181725777, -0.6365764351564785}, {
          2.0331433095132447`, -0.13049938942056727`}, {2.0343594373007123`, 
          0.32943316789182053`}, {2.0355755650881804`, 0.760545544288068}, {
          2.0380078206631165`, 1.5911894106183084`}, {2.0393271393937447`, 
          2.0525101200128035`}, {2.0406464581243724`, 2.5430417918038004`}, {
          2.041965776855, 3.0837513831879515`}, {2.0432850955856283`, 
          3.702744922063891}, {2.0446044143162565`, 4.441008810993611}, {
          2.0459237330468847`, 5.363276464892997}, {2.0466136576415557`, 
          6.}}], LineBox[CompressedData["
1:eJwBwQM+/CFib1JlAgAAADsAAAACAAAAPu6JN8N/AEAAAAAAAAAYwIiun2Yt
gQBAS1jAd9fMFcAUF5Ya4YMAQOn+eXA2qBLAoH+MzpSGAECC1uEuIjUQwCzo
goJIiQBA0DemobR5DMC4UHk2/IsAQPAl+R08OgnAQ7lv6q+OAEBpQYBkxn4G
wM4hZp5jkQBA0kGvkm0oBMBailxSF5QAQACxdflKIQLA5vJSBsuWAEDaIZfO
ZlkAwHJbSbp+mQBAsnEAY6iJ/b/+wz9uMpwAQDU5prL2tPq/iSw2IuaeAECH
qLDQmSb4vxSVLNaZoQBA09Hn7W3T9b+g/SKKTaQAQKyXD+aIsvO/LGYZPgGn
AEAqawf9sLzxv7fOD/K0qQBAJ53NCvPX779CNwamaKwAQHcBh3rzduy/zp/8
WRyvAECAUB1ELE7pv1oI8w3QsQBA8hez/q1W5r/mcOnBg7QAQNTqjTuRiuO/
/UHWKeu5AEBqUoPY0MHcv4iqzN2evABAqgBMAFb2178UE8ORUr8AQFemJMJp
YNO/LOSv+bnEAEA6QJOzkHzFv1qGicmIzwBAJ5UWh5uBsz/m7n99PNIAQACv
1WGtDME/cVd2MfDUAEAUoIUerDDIP4goY5lX2gBAetohhIML0z+2yjxpJuUA
QKUdNT0UOuA/Ew/wCMT6AECkTC0j1qftP9K9iodJ/QBAkHL1MqVO7z+SbCUG
z/8AQGu+dEn2fvA/EspaA9oEAUDNfIycpz3yP9J49YFfBwFAw6r9ZjYm8z+S
J5AA5QkBQDw/wzwJFvQ/EoXF/e8OAUAV7bpYaA/2P9IzYHx1EQFAjJYBfDUb
9z+S4vr6+hMBQFAQ8n/TMvg/EUAw+AUZAUBw3Jws0Iv6P9DuynaLGwFABY7Z
5+rQ+z+QnWX1EB4BQF2TcqVnKf0/EPua8hsjAUB7HJEq4Q8AQNCpNXGhJQFA
DGRlg0LiAECQWNDvJigBQGtGdPZZxQFAUAdrbqwqAUAv1AbT1bsCQA+2Be0x
LQFAIGFrI/jIA0DOZKBrty8BQPhOcFHB8ARAjhM76jwyAUBNwedsKjgGQE7C
1WjCNAFANH6TNHalB0AOcXDnRzcBQK3tZvqjQAlAzh8LZs05AUAl35IhFhQL
QI7OpeRSPAFAb0iccYktDUBOfUBj2D4BQNrfCRGPnw9ADSzb4V1BAUCDxhO7
8EERQMzadWDjQwFAsQY4Dpz/EkCMiRDfaEYBQHPMSE7tIxVATDirXe5IAUDl
YJI0yNgXQI29lFEKSQFAAAAAAAAAGECm0aJn
          "]], LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAAzNQ9QvVqAUAAAAAAAAAYwMjGIEo7
bAFAhd/oZATHFcCIdbvIwG4BQJ+Myu+mghLASCRWR0ZxAUDtw99JTvcPwAjT
8MXLcwFA1bkctBTuC8DIgYtEUXYBQPRMlI39nwjAiDAmw9Z4AUD1ZnKGrtwF
wEjfwEFcewFA4//MXxaDA8AHjlvA4X0BQEpa56TSewHAxjz2PmeAAUA8VvMi
wmv/v4brkL3sggFALwe9VStJ/L9Gmis8coUBQO9X3PSZfPm/BknGuveHAUA/
50yIH/f2v8b3YDl9igFAdHQaOfus9L+Gpvu3Ao0BQA1qITfKlPK/RlWWNoiP
AUCy4PVn9KbwvwUEMbUNkgFAx2hhu4O67b/Essszk5QBQLg8lvAYZeq/hGFm
shiXAUDwGDexCkXnvwS/m68jnAFAzxlKivWI4b/aPERI354BQMfiUTGnU92/
r7rs4JqhAUD9NPhuuNrXv1q2PRISpwFAdejOBUwiy7+xrd90ALIBQLT3m0+y
9rQ/hiuIDby0AUAMCKZSXXLDP1ypMKZ3twFAFQc+QAtTzD8IpYHX7rwBQCTi
SjOW/dY/XpwjOt3HAUDNdGuyv4LkPzQazNKYygFAB2aXteLd5j8JmHRrVM0B
QMRAbmS0Sek/tJPFnMvSAUCE7pM4LWLuP4oRbjWH1QFA/+JjKamL8D9gjxbO
QtgBQCeCGGwt9/E/C4tn/7ndAUDJXF8uTw31P+AIEJh14AFAP/NKwWO/9j+2
hrgwMeMBQM7Dg9ygkfg/jARhyezlAUAQKrOrzon6P2KCCWKo6AFA5IZfJfiu
/D84ALL6Y+sBQPB68zXNCf8/DX5akx/uAUBx2GMzldIAQOL7Aizb8AFAtnlz
92tHAkC4eavElvMBQEXpB05O7ANAjvdTXVL2AUCeDA1+6cwFQGN1/PUN+QFA
8eCChef4B0A486SOyfsBQJVRxbjOhQpADnFNJ4X+AUD/jod7C5INQOTu9b9A
AQJAjVudogqlEEC6bJ5Y/AMCQF1f7CbO+BJAkOpG8bcGAkDoL+BNf/oVQB+O
s1sVCAJAAAAAAAAAGEAy6Hs2
          "]], LineBox[CompressedData["
1:eJw1lHs0FGgYxs33JREGKaRdR8qmMy21pIvmexPlksilXMM0KjFIiRaltpBu
6HKW1cklpag2l4j4Ru4plzKRmDAZlmkrdwpr95x9z3nP88fzx3Pe33nOq80J
tPdBUlJSrnP7r14q+ez2lx4Cqf9GnX9ol+AxezWClMFEw+Rjanz2y0irKRaC
W6vmucSvVeUvstIVFegj8LH3TqB5yvz+mobwI+sQFLQMM5pDmfwy81DVNUYI
wuTHj4dvl+dfq9B60G+M4GLdn1pb0mT5vltrzW9vQlBX5L9U84AMn02DhJ5b
EKjGRu2ziJTmq27RCNUEBOMnanKTBJg/UFzObDVFsDKjN8Wdg/j8DYezEs0R
5Kfutp7UYPBvPFHZussCQQvHV1dzYJb6GZa8k7VGkKgynpb5fprymwQ5RTYI
YpiXAx7LfKeLeV9OHbRDYP9zfMdKjyl6WHahwxIHBHelBrpt305QmrlSt8oJ
wafO2uGIgHGqagqTR50RXBD/0F+pPUZ9ha4vl7shqM+6Ot0lGaGL1OKDo7wQ
fE/KN5bQIXoo7765/n4EuZfLa8MrvtJS2yp1oQ8C5gUOa0bwhR6MnSrb7Ieg
Rq3WWdHsb/psxeLEAR6CqLT0eINcCVUu1/dJCkJgfH1Rr7nhIC2Z5C4cD0Hg
Znomx4PXT5VunBJmhiGofJBpwtXuoz7rkh87hiM4GaXd5CzqpUy/xr25UQjK
vp3PuHdRRLkyA6u9f0NQGzGRqRHcQ59mzJthRiOIi7E78Lt3N93fsfE27wKC
IIfvY/cKhbQozDF02WUExx56dca96KAKiwOt6uMRGMzq2OyUtNNCm9tfVt1A
MMFr63V1bqULqeKWj6kI9pi61VsWN1EvNz2lqxkIpkMvhZntaaAF49tEW+/M
9cFgaEWXRT31NDhx/lY2guv2KaPu7lU0L00kcH2C4LPaxwTe1nzqdrYooLke
ga2ayd4sVgHJtuSklo3N+TXeTX4ZbcSQpc0mkwj8eSXzRdXvSJli13v6DUGO
+GUqkrSTpjceauVSGFYYWOf/ZNJJRjxcLlfIYSgt1HseMt1FIkGdZaaAYdlo
ThdJ6ibzdVrrKpkYYuIGJOL1PUSj31G6WhXDoaRqnl+YiLCD7SJqf8Tw+LXH
huUaYlLjyFxqqY2h8vma3Ju1YmJn3FBYp4PhUwzP62h4H+F8tx5+sWou76lC
sa6kn8RE7zj8ah2G3lIn/0iGhCj5zl+wywhDyL02k3NvJCTZuiqzwRiD2i+b
WjyzP5EcpW3djSYYFOpvTVoFfCZNyWzn19sxDAh9ThTd/UpcIqdH7S0xZDTn
d7L0h0iP57Orb6wxeLYc0OstGSIjKzY1tthhIOqJCZ/EwyRSZtLfyQHDiKwD
d1v0CJk/UCj31gnD2zrGeglrlGg8Mtre6orhvT17eCJxjKQnjIj2emCQFNQt
GXUYJ6xjeafbPDFs6Er/EK41QQr2BGu5cDCkR15XTR+bIOyNa0vfcTGEnnTs
SW+fJDWaX1xdD2IoPGTQKH45RexmHk60+87x3PiIyDd+I5wKlmFHAIb7p4eN
KuVmyGDmYLP7EQxWJi3SCpaz5Fjs/cDOoxgcIiajuXZSMHPYV2HfcQyd+UOM
cjkGxNisyhaGYegoPBpYJGCAkkGfhWc4hlllxBbkIUhWuSP+EIlhRzl395os
DDqj3LNeURgWpE5cOf9kHuS06izvPoPhTsnmgj9E0mBU3EO9z2Gw/ZW+sjCS
gbKUNI+eGAyvmUFEJW8B7Djl9Y0Th0FwKV/xwQE5aPLWShJdxBDHW83odpcH
FzPheu6VuXueM7ra7yhCj+7Nlo8Jc7zELoIfHyqBv6x7sM81DLtDyivYtiow
OrhUSXxjjofw9tgOW1W4drOvJiUJg3+iVuwDZTVgL/Co3pmM///H8A9Ld5l8

          "]], LineBox[CompressedData["
1:eJw1VAlM03cYLfx+QIeAHCq36BCnHGMO2SQE/p+MU6QMMR0MUCrFC8FwKGMB
OrCoGUIN4IqIIocrzKJAQM7y/4+EY0wOdQiCIrRyVKgU5IbBuiX7ki8vL3nf
y0te8u0+dfFYuDKNRnNR7L9oz/Joj2pCQPtvDChB0VHTdwq+ESuc8NinT7kf
N+zLIxGsnsMa27P1qDGV8Rt+LQjmjhkwc95qU9zaKld6KwK14FdT9WmalPk5
znpzOwJBWFJ0rZk61WJ0tPpSJ4LnO5v5hf5qFOupwQXrLgT8UzNL2muYoiWP
mUt6EKSmt0Wx15SpAtuqodvPEaimpT3jHVainEeTs7/tQ9ClIb5sw9kk32R5
e6sNIBh8p+I327dOJroaoOZBBGzOQgozfpU0XnzXEPcGAUovZ/Yzl8kGQWWM
1QgCFVFEd8b5RTIwMNlSLEbQaSqWp/82Ty6re4tzxxA0sufkYdofSX6Tfp7v
JILvy4dlvb/Mkn1mlZ+IZAiqo3+tPimVkXHPkn6PlSPAT6fz+3+eIvWuHEmw
/IggRGltr9kxKek3LpnkLyOI5gSzpmCMlPMr7jPWFHnDt2l7siQkzyspQGUD
Qdn5Hx/N5Y6SXcIdHTEIQ2nEng+C66/JCycknP2qGEIdeszvnXlFbtGu+HqE
jsHUe5G9g/2S9Ir1EvhoYXj894jcsKyXbHVIvLrPEENHSQZ740IdyZ7ydH5r
jMG1dzn08ZCQRHe3L97aicEnxy7ws7As8jDtcTjagyFpo+DOl0HlhKht1HX4
cwzy7E2VS1adRI2/B8pxVfgnsMVSixHiunddmokHhq11b8P+YI4Swd/spz/w
wkB3p4akGWJC2W6L5hMGhtmRAN/vdMeIPstEnrMfBpPMeyFc1jhR+qlMp90f
A/9PXau6hgmCoduzYyAAw8kX/qfnee+J3epwOzQIg4W1lPFQa5qYV6o0loYo
9D+1Ovbmy4g7s1m7Vk9h0Gman/GKlxNRUlScGo5hxU21xiZolnAZjbPYchaD
3cOZ+rUjc8RkL9PSJBJDkZJbi+PxeaKxo11YchHDF4KyPbbRC0QmdcjWJgbD
tP3G/N7CRYJVV1ZZE4dBHy7eFI4vEQcrjA46x2MY4LpkNriuEGql6U/aEjDY
FDtp9DevEoMF64d8EzGkRrTetw9cJx7xIxv7kzHk/fWgXGKwQaTwhp1CUzBs
+kYmKSnT4Pg1X2ryCoZdBMNcQ0cJ9nEol+irGCQ3JgwdnZVh7fKB1pXrGLia
+YKzPATdUUUeqekY0oShkXQNFSg8rdepnolB5POyRyRShbgT3KPZNxX59YZk
DpV08GAudBtnK/y3vnG/saQORozTfiW3MFBsfu2BUk2QufW/sM7FUHCGYf9V
jDZQTp7MmjzFfdVrrR+idCHbvn7A6a6iL5t8HvqwDbjve4qKC/D//wD+AYcX
4nQ=
          "]], LineBox[CompressedData["
1:eJw1VXk01fkbvvH9fmRJlgyyjWyTdY4MU64+b7a5dscQyVIS2fdkpiZEuIwx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          "]], LineBox[CompressedData["
1:eJw1VH1Q03UcZuC+X8UXJNgim4mapoTild5BgN8PshEvQqhgxKsCLhrJEBjD
sVLByMlLQKAkITrBeM0TEHGgvx+KgdGYQENOhHgZgggDQUJFZqu7nrvPPX89
9zyf53P3WRsq3HvI0MDAwEU///Kd2lZ+y2UEBv/Bgn5hO7KTW4KgZ/vwNaOr
LDonXNrfXIYgDOcVBdFv0dsyTZM8KhFUHN6jSBStpJX1l9erriD4MtaxcKvj
clowYn93bxUCcRvvjrGtMY3M2vldNQgy5Tcjfa5iWr6Tv9j/OoLey+yvOlKZ
NBHMl/beQODrx4gorjKiH+VmehxsQLDvnIPJMbYhndC4YUJzC4H9z+xTmnID
2nxCkRHRiKBJ4pHH+VNHXbXw3jZ+B8GswJLlnfOa8uIOtwt/Q6AZU8afS39F
jQklsTMtCE5NxvD8r7+gUvJNWOJWBIbKM59kG89R65uLal8p9f7+nlWyE7NU
4Huql4xOBNaxURW5LdPUindirtWrEbDML25xTHhGNZqxjoi6EUiz5o9xYYqK
W1FnbdOD4JBbOtPfXkttXBIwOtqL4DbUZHe/O051G+kuyfsRTEn4ULl6jDqt
uxASOISgy1XjznEcpSZnHnepRhE8GMy959qioeRaWbbsKQKh2Lmc3jpE+Tyx
9nLWIvBKQPabSgaour6Yu7UzCLwFz1Wleb1U0j1ddYFOf5+Jb84rDnRS25su
Cj9nYBgMzYmQMtupkVvcD00XYbCRNWzhiJTU7prT8pNLMGQ3pOYPFDRRrEJ2
VqQ5hvRow4HPkgupkritUXZWGMLHt5UsE7cSf2H75hlrDHXHecWRQSqyXBA3
XGGDIaBnv1FcUTuJCVEEWu7AMP23m09lvprYu7t4YMBw6KxgTvKgl2i5T1Dj
LgxzrnLh0YW/yAWSdlvCw9An5UaWvz1AFu3osNO6Yygd9y0OCR4ibWuCN6l9
MVhU67w3+Y2S46sYmgw/vX6PreHX1U/Ix6yiQtcADGln+n9QcZ6SPOMxdsMB
DOtkDj+FWmqJOzO9QxSG4aOzTp5utybJwhubDBu+Pm8h7TVaN0VCZ0XMS5EY
vnBR9KzNnibmUxaNgVEY7L0cT9bmzJDmsXop+wiGxmoUd7jkOZEMB9vej8XQ
EP7HxRTVLLHuZzyXxev9329zKl42R/oeFl1xPqrvV5yU9Dj0BclUfxq5kIjB
3CG+Tad+SXbdH9t4/Vv9PuKcvhDBPJn9PX0w+gSGJCqtX7BhgTxaqo54nYyh
hn3lmeqpjtzezZn8PgVDWHMAY1W0AZSmh4nMZBjsaitW7/+OAZltZfPnUzHc
6OJ9UKwwhHiT6RNWGRg8szeXH2QvgiBvu8W1mRg4cTzprxeYwM06nuH0IwY3
v9yFdeEYrDqazZW5GJIX8x+2Ri2BlWYm+X55GFgVwTdrOpfC3L79azXnMLwa
EBb5Va6AvpyCX4QFGMxiZhWdK02hSa3ZMl+IQcoVJUq3m0EZ27omRY7BJ9W3
7MAEC/LXFPu/uYT//yfwD+ZhBOA=
          "]], LineBox[CompressedData["
1:eJw1VQs01fkWPoT//+cRIdQtbydSiggVv11hzDAUcnXL65CiRl6D0vEqkwiT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          "]], LineBox[CompressedData["
1:eJw1lHtM01ccxYsF9V5UEEfl6ahRVxhiYwCnc96vVkFjXXgO5FEQ52MDBaUY
MAyZKB1ggFXAwRRtFQwyoUAykIj3N0CoRqSWQXnJo1JARB4VEXzA2JKd5OT8
+ck5fxxuWKTXkUUsFkuw4H8ztKKzoLEaAes/WTBye8tKVg0Crl214dKWzxiv
/AtBEoogd2gZN97cjFm0asJgRS2CEQV/P7fbhCmXBN7OqkcwkPnEIvfQMibs
Y4PQuhFB3QZNR8V5xJid2qyXPUKQsaX/tLvlEqZWd+0K7wmC7mAjn1JsxJwO
QN+UPkWQ2Frn/5eAzaxtFmtdniG4cDXiw8E/DRi1oE9yvwVBs0omUvmxmPNV
+zcK2hAwnh0Ow2SObt5YqX7UjiC053ABNf1ItbK1sR5dCIIDxDsMLd5TKSfd
VvMcAa8s+Zn0wAzdlTZbG9yHoMy5PqX5zjTVz39/fECL4JPj+4EDDm+pXKxa
Hq5DoJT7h2c0vqEGotv+sSMIbmco+a+Fk1ShNpubG0Vw1O3xw02bJmioe8LN
i+MIrHamJF1zG6MM33dMOoXAJ3nguUH0CI0qYC5bvkOQnXnY66FimNpZOW69
MYugU71e6WU0RBPZ7At35xDIa1ziR1++oPzYk/bOBhhaDsnT7c9oad9ox9Nq
NoabdjLVuZX9FNoUlsqlGG4k57Ef9XZTVpGoVGuGwW3L/u0b/Fpow6jm5HVz
DOOuhtND4yp6ie/pFGSBYa/3pRktv4murhLcbbXFEMNXD6J19dSpkVes5GG4
mC3RtGqu0CCdvrBkBwarL8Rf3nnQRNbaRxwN34khfM3P56Jfq8hwhG49bzeG
nRnF5g3zahI9pbkl24fhXnLed8UuGpLKrpFn+WDoCp60GzfsIx7urmGefhh6
BttTop36CSetlLsiAMOwyH1YGqIlcjP5DUkIBsemwGNh3QPkHleSf/ZHDJUz
cZyukBGScIQl2nICw3LBA2G87hXZXRRnOxWJgdUiTt/+02ui4kdcPRGDYbux
jUNPzATJEesCHWIxtKVElTccniRBVSLrobMYsCjYpjdET4aJZ15o4gK/ouPp
stQpUpL0+KBtEobpdYXS6/ffEnGjwLLzIoZRRV134uJ3ZJtxTXvOLxg+DpoI
TcJnyPy3rr95p2FYukfy1mNsltRLS/1M0zGYfL3nyprsDyS1jbe6KRPDsXVR
XUFHPhEPK3lbymUMYqdLnvuOzhOOyDrHLQfDvNOt2lMqFnTLsnzZuRhqhE1n
iekikOuWmzO/Y+DVJ/Qr49hw3F7yd3w+Bh8vt95IjhFsPMHK2irD0H+m9k2e
fjHoFXHe0zcX9otOjljyOYKqKb1ZReEC/4dgYU+5MSR8FaGOLFro7xiYZNO8
AnbH6351/AOD8WTiNmevlYAZkefLEgyzca/8mx+sAhW73bSwbKHvCK2zGeGA
W9XeF77l+P9/gH8A5f7t7A==
          "]], LineBox[CompressedData["
1:eJw1lWtU1OUWxgdExv7vC8YwchUQQqQYEgRSkHo3CIIUKpNCuBhUHEqIGK5e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          "]], LineBox[CompressedData["
1:eJw1VHs01HkcnZgN9f0aj6bHxpYMMociEsfh+2lPSYhd1Bwsa+wqlY0lawwW
iWzb69Syk5XHoWwOYmk9ot+wNJ6ZWTTlRJLHamhijMewWrvn7D3nnnvuH/eP
e/+4RiER3qFqNBrt0Br/1U0+rqK9JQho/2GrMDl4Rw67FIF9zwXnDswU6jxv
4I+Ur/kuh2+jtPWEeV7+ftmVCMTx+VZxCQzhHtHCAe9qBLyXP/kHdG8UPnbO
3LyhBoEgZ+9QUqem8Njv+5RNdQhOTxXcsXNbL3xpKe6Na0DAfTGYJ2fThXky
3UR1CsG9uWe5GjFqwpD7PqZXmxBkZ3Ie/TFHE5qeyuzZ3IKAFT7IrYUP1CRL
yst/giCve9I1fXiFKh3ZuovdjuCASdMKs1FFReb7d1Z1IkATSLrQtUjZBOWc
d3qKICCiYPKG5gI1v33IUCRGsJMRYl5+WknVv9gh+qwXgZ5G4BVbmYJK/Jkb
OdCPICXaLHksY5aC44Xbvn6OoKbluMyazFB0/bHm6QEE3dV/NW7Z+J4SiU3D
YwcRsCtF17X7pqnL18KY64YRzAVG1OZUySjdDVOnNo0hSPDy6jFon6D6RJa6
uRMIRq1V9qOLY5QgLaLe7C2CL1+j4FdOo9Qn6xTIUY6gTBIc1bI6TFksLlVy
l9b6bnuSQTjPKPlDxwDZMoLSvPpf44p6qd+iE+kxqwjOrLxRV6pJKAc5jZOh
jsHYiRzOloool3GNlXKM4VKYmafLeAGlVXT0rr0OBtvPbxm9OxtIurg/ejbr
YZha4btzfykkPoPaBf1bMJSamaXyghtIcB/TZcUIg7a+JKEiTExYNznyNBaG
acNVX1Xrn2TC67aAYYZhXvNB1F3zfnKu00C2ywLD6Fhdy6zWAIlvNr5x1A4D
J7w7VGo5QpyTQx167THkK3n0H668IWrOxSNfOGJYLJNYXlWOkow69v5IwLD7
9XBGjmyCeMSGDy19iuFB6/WmC/GThLG//FLqYQxd0629CdtlJKvCeiDLDcPH
vm3SE7feEb9z0ak7j2FwtQoy6jvwnhhYPLQo8cKw9yNldeq+GTI8Od9v443B
hrWnDBxnSWGxfVKjLwYde/mRTh8FORnK332Eg0H0tMbQ/Ps5wjZukIj9MBxS
uRZXNShJRS5hjQZhOE+bbuxIWSQKvkKDy8VQPZDq4KahInacYtngVxgsM4Mi
FWXLhGcT0ON/EsNheaHxMv9v8ojBqJKGYfA46t5Sdf4DWZU1Z/mexcDqdeNF
SGgAbd/xJd+s7Tlj5XRNQw1Si9hBnpEYGC9oRs0h6vAkeehgZxSG6MVDQuot
HTQDb5q4xmBIu3fGOOX+enB3cNFqjcVwe2Im3LJUE64xVVMH+RiYbWWvePSN
IJ4pEz9OwHBnSzSzuwOD/lNutWMSBr7AWmf8hg6cKGEKalMwSEs9PExy9UCQ
3h6//+Ja/nWLkG7LhK7LtppH0vH/fwH/ANH29XU=
          "]], LineBox[CompressedData["
1:eJw1lHk01WkYx2+uq0ve92fLUkqjsrUwomls79N+I6UmKmTrhlEo0WIijGpS
MVSUSBFpb1RuUb0/W1qQe65EMsy1Fg1RuVkyd+ac+Z7znOd8z3n++DzPec73
O7/Q9dsUOBzOFnn923NO6xvb5SPg/CddNibkJ8nhKwhsm5aedrLSZsscJ4q4
1xHYBO48lpKoySoZF6fH3ERQ6KTgnLFHnV3FDY0eu41gxmFzcegRhj3eYugX
eQfBEqNe/utCVbamuH750D0EFRnCvKiNKqz6mQTT8PsIempX6s104bMbwh3Q
xyIENaFivfhEJTbVZaA/+BGC/N2bU3V4PLZxbl7de4qgUbeq4fwVLquv7H4/
oBTB0JxME6twBda7A2W0lyPY4Z7cc9lrAptdUnLQtxKBaLI2T03IYdszI7b+
+QxBtn1QXD9nnBpHmq70qJLvmypSXO87RoPcms0aahCEPuHEDbeN0OuWydhV
jODeS8mpw/HD1LJH9mpNPQK2Zs3aeeoyGlF5/cGLBgTpbqGZiUNf6P0cn0xB
EwK7PUrG5v2fqb3nU+GSVjl/yv23hWqfaMyiAwIqRVD6x1BNtPUgLdWymGvX
gYBu+5a3wH+ACqrTBq3fIzC1bUnU6OqnCVecXhf0Inj59nzSVut+Wn1ovMi8
D4GZ0LygSqePrncIiDP9hMBH19blSmYv3XJrofq0bwiCJLJxD5tuWuguw7Uc
DPHMrNUrZndRrFSk+isXwwznOxtspnRS1tOe/46PIcDuXKKtQTs1VFk2flcT
w92O+YvU4ltp5D3eWIA2hh0vdovBvYVKfCqHp+jJ5z39eU6iZhovcvwSMx3D
kUNR5npJb2incN2H1aYYgqa1Km/JqaMOapo943Mw9PKDPHVsJDStuK67YD6G
hblxLW31YirQ2NSua4Xhc3ZEv3RxDb1KvZraHTBo2ZoE5L8uoyFTdjw7sAFD
l7b/2uxl6+mTinmV5hsxfEgdflTGpBCDXX3l0s0Y9K188h+lZ5PayjBW4I3h
qcKKb9sbC4hlxH6RVhAGj6RjP1NZKRl6eTj3+kEM793MPAKJhLj8IsjxjsOQ
W022jsbWkXwjlYsahzDI6j1CyitfEfeoExn7EjDMEhdsnu/VQB6anTq57DQG
qJJxpLSZaNW7Jg+lyf3tS6ujZ7eQ4FidpKvpGLwMZ/edFbSS6Q3pCWoXMBg0
rWV9H/9FYg5djH17FcPMhIE1yY3tBO2d6Oh7A4Nyx+ZJVZkdJD0wWKPzFoa9
Fisir/l3kjtOP+b03cWwa8ynKHtiNwH7rO3hIgwr/HJKQlu7SdV8ntXXBxha
sspcnOk70qkuLlegGEzqmOCR33tIGPeHE0dKMFy2tLaqiO8l458yXFXLMXRE
NTmdivlAdBsCOyc/w5AwaNVWnNJHnM5z+KYS+b0jx8J0pg6QhiT/2huvMBh3
hjWG0AEijK06Y9kg5zXgZC7ZPkiihWdM7ZoxBLoa7jd5+4mouH37yLZgWLp4
Dfd19meStlJYtFyKId9xj8GS8C/ktpmF09ouDBe8vGzqbGXEXj9Vs+4dhkjV
72/kWX0lz9Fo06ZeDJNbFTdl2A8Tt3HfS81/Y+jLejZ8dtMIaeuv3OH3EUP1
JBO+5Mgo2SmdZ901iEFB3dvnTfUYGZWcHNv+Rf6fR11jRfPGydGKrxX9Mgyl
gWdfxrhyQFvknRgxgiGN1G6YMHsC5ORXuA2PYRBNf5AwMFEBLNLnGBzkMOCs
EuGwbwIXHh5L7uJyGVB1DIsLnqwIq6KGbv3GY8Awa6tZhoAH9SFb9iE+A5fv
XnuofFEJ/HzKIEWFgYczGi2FRnzoW2eqrIMYmCIK5mZJleHA0iTxOYYBnqbi
vibpJFC2/nx2hgYDwqIeneeLMKQaefjlajEgTuqWBkWrgaFuiZmZDgOVew5G
1ZtowC1l48GbenK++MLYWdZaYDdyvHiBPgOjoY/r/J5rQ5un4OjUacz/+Q3/
AEgioYQ=
          "]], LineBox[CompressedData["
1:eJwBUQOu/CFib1JlAgAAADQAAAACAAAAx6cXcRY/D0AAAAAAAAAYwO4wILF2
Pw9A34tPTZVPF8B6IoZ5+0EPQL0lKVIJ6hPABxTsQYBED0BrL/wsT04RwJQF
UgoFRw9ADAQqVAd5DsAg97fSiUkPQF2UaPpBGgvAregdmw5MD0CMSHFmx0wI
wIidhWDeTg9AMx3xI+WsBcBkUu0lrlEPQKOF5FbodAPAQAdV631UD0BgzWrV
M40BwBy8vLBNVw9At1of4YfJ/7/4cCR2HVoPQHQyRpEL3vy/0yWMO+1cD0As
79xX9ET6v67a8wC9Xw9APbF5L6Pv97+Kj1vGjGIPQChVuf2l0vW/ZkTDi1xl
D0CUGNFl5OTzv0L5KlEsaA9AWPf7AAsf8r8erpIW/GoPQGKMJXcge/C/+WL6
28ttD0AVBwafbujtv9QXYqGbcA9AgAwMq2cM67+wzMlma3MPQNr7W41AW+i/
aDaZ8Qp5D0CBSU1X3GLjv0TrALfaew9AFGgAZjAS4b8foGh8qn4PQChXNW97
st2/1gk4B0qED0C7KVpZrELVv0Xd1hyJjw9AiD7Al1txtr8ihBRIB6YPQGnX
KdAie9g//jh8DdeoD0BFX5IBEWzcP9nt49Kmqw9AqDez94Q64D+QV7NdRrEP
QLQKqSeUceQ/bAwbIxa0D0D41WSnzKnmP0jBgujltg9ANFM5s3T56D//KlJz
hbwPQCzL2FSb7u0/2t+5OFW/D0BzevqWp07wP7aUIf4kwg9AekAikRG78T+S
SYnD9MQPQCyFubPoP/M/bv7wiMTHD0Df3zSoKeH0P0qzWE6Uyg9AlXlAdJqj
9j8laMATZM0PQDRGs8UBjfg/AB0o2TPQD0BUwZ4ocaT6P9zRj54D0w9A2n4x
Nary/D+4hvdj09UPQN0gcu2qgv8/lDtfKaPYD0CLh2UiOjEBQHDwxu5y2w9A
SKz0iBTSAkBLpS60Qt4PQALOUYvbrwRAJlqWeRLhD0CVABc6r9oGQAIP/j7i
4w9AKmFaL9ZoCUDew2UEsuYPQBDVWNv9eQxAunjNyYHpD0AnJ/J0ZB4QQJYt
NY9R7A9A8R1dpmp8EkBx4pxUIe8PQLN6910IkRVASHTBwsPwD0AAAAAAAAAY
QAeUdso=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ], {}}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 1]], 
            Line[CompressedData["
1:eJwdUwk0lQsXvcZEGUJcpchQmVIpJeyvaESoTD1RQjQgRJFEiCgNSKEk/aYi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             "]], 
            
            Line[{{2.0253997252909666`, -6.}, {
             2.025846542788437, -5.223995978989361}, {
             2.027062670575905, -3.781239979233763}, {
             2.028278798363373, -2.718195603956154}, {
             2.029494926150841, -1.8890168319115048`}, {
             2.030711053938309, -1.211814237128575}, {
             2.031927181725777, -0.6365764351564785}, {
             2.0331433095132447`, -0.13049938942056727`}, {
             2.0343594373007123`, 0.32943316789182053`}, {2.0355755650881804`,
              0.760545544288068}, {2.0380078206631165`, 
             1.5911894106183084`}, {2.0393271393937447`, 
             2.0525101200128035`}, {2.0406464581243724`, 
             2.5430417918038004`}, {2.041965776855, 3.0837513831879515`}, {
             2.0432850955856283`, 3.702744922063891}, {2.0446044143162565`, 
             4.441008810993611}, {2.0459237330468847`, 5.363276464892997}, {
             2.0466136576415557`, 6.}}], 
            Line[CompressedData["
1:eJwBwQM+/CFib1JlAgAAADsAAAACAAAAPu6JN8N/AEAAAAAAAAAYwIiun2Yt
gQBAS1jAd9fMFcAUF5Ya4YMAQOn+eXA2qBLAoH+MzpSGAECC1uEuIjUQwCzo
goJIiQBA0DemobR5DMC4UHk2/IsAQPAl+R08OgnAQ7lv6q+OAEBpQYBkxn4G
wM4hZp5jkQBA0kGvkm0oBMBailxSF5QAQACxdflKIQLA5vJSBsuWAEDaIZfO
ZlkAwHJbSbp+mQBAsnEAY6iJ/b/+wz9uMpwAQDU5prL2tPq/iSw2IuaeAECH
qLDQmSb4vxSVLNaZoQBA09Hn7W3T9b+g/SKKTaQAQKyXD+aIsvO/LGYZPgGn
AEAqawf9sLzxv7fOD/K0qQBAJ53NCvPX779CNwamaKwAQHcBh3rzduy/zp/8
WRyvAECAUB1ELE7pv1oI8w3QsQBA8hez/q1W5r/mcOnBg7QAQNTqjTuRiuO/
/UHWKeu5AEBqUoPY0MHcv4iqzN2evABAqgBMAFb2178UE8ORUr8AQFemJMJp
YNO/LOSv+bnEAEA6QJOzkHzFv1qGicmIzwBAJ5UWh5uBsz/m7n99PNIAQACv
1WGtDME/cVd2MfDUAEAUoIUerDDIP4goY5lX2gBAetohhIML0z+2yjxpJuUA
QKUdNT0UOuA/Ew/wCMT6AECkTC0j1qftP9K9iodJ/QBAkHL1MqVO7z+SbCUG
z/8AQGu+dEn2fvA/EspaA9oEAUDNfIycpz3yP9J49YFfBwFAw6r9ZjYm8z+S
J5AA5QkBQDw/wzwJFvQ/EoXF/e8OAUAV7bpYaA/2P9IzYHx1EQFAjJYBfDUb
9z+S4vr6+hMBQFAQ8n/TMvg/EUAw+AUZAUBw3Jws0Iv6P9DuynaLGwFABY7Z
5+rQ+z+QnWX1EB4BQF2TcqVnKf0/EPua8hsjAUB7HJEq4Q8AQNCpNXGhJQFA
DGRlg0LiAECQWNDvJigBQGtGdPZZxQFAUAdrbqwqAUAv1AbT1bsCQA+2Be0x
LQFAIGFrI/jIA0DOZKBrty8BQPhOcFHB8ARAjhM76jwyAUBNwedsKjgGQE7C
1WjCNAFANH6TNHalB0AOcXDnRzcBQK3tZvqjQAlAzh8LZs05AUAl35IhFhQL
QI7OpeRSPAFAb0iccYktDUBOfUBj2D4BQNrfCRGPnw9ADSzb4V1BAUCDxhO7
8EERQMzadWDjQwFAsQY4Dpz/EkCMiRDfaEYBQHPMSE7tIxVATDirXe5IAUDl
YJI0yNgXQI29lFEKSQFAAAAAAAAAGECm0aJn
             "]], 
            Line[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAAzNQ9QvVqAUAAAAAAAAAYwMjGIEo7
bAFAhd/oZATHFcCIdbvIwG4BQJ+Myu+mghLASCRWR0ZxAUDtw99JTvcPwAjT
8MXLcwFA1bkctBTuC8DIgYtEUXYBQPRMlI39nwjAiDAmw9Z4AUD1ZnKGrtwF
wEjfwEFcewFA4//MXxaDA8AHjlvA4X0BQEpa56TSewHAxjz2PmeAAUA8VvMi
wmv/v4brkL3sggFALwe9VStJ/L9Gmis8coUBQO9X3PSZfPm/BknGuveHAUA/
50yIH/f2v8b3YDl9igFAdHQaOfus9L+Gpvu3Ao0BQA1qITfKlPK/RlWWNoiP
AUCy4PVn9KbwvwUEMbUNkgFAx2hhu4O67b/Essszk5QBQLg8lvAYZeq/hGFm
shiXAUDwGDexCkXnvwS/m68jnAFAzxlKivWI4b/aPERI354BQMfiUTGnU92/
r7rs4JqhAUD9NPhuuNrXv1q2PRISpwFAdejOBUwiy7+xrd90ALIBQLT3m0+y
9rQ/hiuIDby0AUAMCKZSXXLDP1ypMKZ3twFAFQc+QAtTzD8IpYHX7rwBQCTi
SjOW/dY/XpwjOt3HAUDNdGuyv4LkPzQazNKYygFAB2aXteLd5j8JmHRrVM0B
QMRAbmS0Sek/tJPFnMvSAUCE7pM4LWLuP4oRbjWH1QFA/+JjKamL8D9gjxbO
QtgBQCeCGGwt9/E/C4tn/7ndAUDJXF8uTw31P+AIEJh14AFAP/NKwWO/9j+2
hrgwMeMBQM7Dg9ygkfg/jARhyezlAUAQKrOrzon6P2KCCWKo6AFA5IZfJfiu
/D84ALL6Y+sBQPB68zXNCf8/DX5akx/uAUBx2GMzldIAQOL7Aizb8AFAtnlz
92tHAkC4eavElvMBQEXpB05O7ANAjvdTXVL2AUCeDA1+6cwFQGN1/PUN+QFA
8eCChef4B0A486SOyfsBQJVRxbjOhQpADnFNJ4X+AUD/jod7C5INQOTu9b9A
AQJAjVudogqlEEC6bJ5Y/AMCQF1f7CbO+BJAkOpG8bcGAkDoL+BNf/oVQB+O
s1sVCAJAAAAAAAAAGEAy6Hs2
             "]], 
            Line[CompressedData["
1:eJw1lHs0FGgYxs33JREGKaRdR8qmMy21pIvmexPlksilXMM0KjFIiRaltpBu
6HKW1cklpag2l4j4Ru4plzKRmDAZlmkrdwpr95x9z3nP88fzx3Pe33nOq80J
tPdBUlJSrnP7r14q+ez2lx4Cqf9GnX9ol+AxezWClMFEw+Rjanz2y0irKRaC
W6vmucSvVeUvstIVFegj8LH3TqB5yvz+mobwI+sQFLQMM5pDmfwy81DVNUYI
wuTHj4dvl+dfq9B60G+M4GLdn1pb0mT5vltrzW9vQlBX5L9U84AMn02DhJ5b
EKjGRu2ziJTmq27RCNUEBOMnanKTBJg/UFzObDVFsDKjN8Wdg/j8DYezEs0R
5Kfutp7UYPBvPFHZussCQQvHV1dzYJb6GZa8k7VGkKgynpb5fprymwQ5RTYI
YpiXAx7LfKeLeV9OHbRDYP9zfMdKjyl6WHahwxIHBHelBrpt305QmrlSt8oJ
wafO2uGIgHGqagqTR50RXBD/0F+pPUZ9ha4vl7shqM+6Ot0lGaGL1OKDo7wQ
fE/KN5bQIXoo7765/n4EuZfLa8MrvtJS2yp1oQ8C5gUOa0bwhR6MnSrb7Ieg
Rq3WWdHsb/psxeLEAR6CqLT0eINcCVUu1/dJCkJgfH1Rr7nhIC2Z5C4cD0Hg
Znomx4PXT5VunBJmhiGofJBpwtXuoz7rkh87hiM4GaXd5CzqpUy/xr25UQjK
vp3PuHdRRLkyA6u9f0NQGzGRqRHcQ59mzJthRiOIi7E78Lt3N93fsfE27wKC
IIfvY/cKhbQozDF02WUExx56dca96KAKiwOt6uMRGMzq2OyUtNNCm9tfVt1A
MMFr63V1bqULqeKWj6kI9pi61VsWN1EvNz2lqxkIpkMvhZntaaAF49tEW+/M
9cFgaEWXRT31NDhx/lY2guv2KaPu7lU0L00kcH2C4LPaxwTe1nzqdrYooLke
ga2ayd4sVgHJtuSklo3N+TXeTX4ZbcSQpc0mkwj8eSXzRdXvSJli13v6DUGO
+GUqkrSTpjceauVSGFYYWOf/ZNJJRjxcLlfIYSgt1HseMt1FIkGdZaaAYdlo
ThdJ6ibzdVrrKpkYYuIGJOL1PUSj31G6WhXDoaRqnl+YiLCD7SJqf8Tw+LXH
huUaYlLjyFxqqY2h8vma3Ju1YmJn3FBYp4PhUwzP62h4H+F8tx5+sWou76lC
sa6kn8RE7zj8ah2G3lIn/0iGhCj5zl+wywhDyL02k3NvJCTZuiqzwRiD2i+b
WjyzP5EcpW3djSYYFOpvTVoFfCZNyWzn19sxDAh9ThTd/UpcIqdH7S0xZDTn
d7L0h0iP57Orb6wxeLYc0OstGSIjKzY1tthhIOqJCZ/EwyRSZtLfyQHDiKwD
d1v0CJk/UCj31gnD2zrGeglrlGg8Mtre6orhvT17eCJxjKQnjIj2emCQFNQt
GXUYJ6xjeafbPDFs6Er/EK41QQr2BGu5cDCkR15XTR+bIOyNa0vfcTGEnnTs
SW+fJDWaX1xdD2IoPGTQKH45RexmHk60+87x3PiIyDd+I5wKlmFHAIb7p4eN
KuVmyGDmYLP7EQxWJi3SCpaz5Fjs/cDOoxgcIiajuXZSMHPYV2HfcQyd+UOM
cjkGxNisyhaGYegoPBpYJGCAkkGfhWc4hlllxBbkIUhWuSP+EIlhRzl395os
DDqj3LNeURgWpE5cOf9kHuS06izvPoPhTsnmgj9E0mBU3EO9z2Gw/ZW+sjCS
gbKUNI+eGAyvmUFEJW8B7Djl9Y0Th0FwKV/xwQE5aPLWShJdxBDHW83odpcH
FzPheu6VuXueM7ra7yhCj+7Nlo8Jc7zELoIfHyqBv6x7sM81DLtDyivYtiow
OrhUSXxjjofw9tgOW1W4drOvJiUJg3+iVuwDZTVgL/Co3pmM///H8A9Ld5l8

             "]], 
            Line[CompressedData["
1:eJw1VAlM03cYLfx+QIeAHCq36BCnHGMO2SQE/p+MU6QMMR0MUCrFC8FwKGMB
OrCoGUIN4IqIIocrzKJAQM7y/4+EY0wOdQiCIrRyVKgU5IbBuiX7ki8vL3nf
y0te8u0+dfFYuDKNRnNR7L9oz/Joj2pCQPtvDChB0VHTdwq+ESuc8NinT7kf
N+zLIxGsnsMa27P1qDGV8Rt+LQjmjhkwc95qU9zaKld6KwK14FdT9WmalPk5
znpzOwJBWFJ0rZk61WJ0tPpSJ4LnO5v5hf5qFOupwQXrLgT8UzNL2muYoiWP
mUt6EKSmt0Wx15SpAtuqodvPEaimpT3jHVainEeTs7/tQ9ClIb5sw9kk32R5
e6sNIBh8p+I327dOJroaoOZBBGzOQgozfpU0XnzXEPcGAUovZ/Yzl8kGQWWM
1QgCFVFEd8b5RTIwMNlSLEbQaSqWp/82Ty6re4tzxxA0sufkYdofSX6Tfp7v
JILvy4dlvb/Mkn1mlZ+IZAiqo3+tPimVkXHPkn6PlSPAT6fz+3+eIvWuHEmw
/IggRGltr9kxKek3LpnkLyOI5gSzpmCMlPMr7jPWFHnDt2l7siQkzyspQGUD
Qdn5Hx/N5Y6SXcIdHTEIQ2nEng+C66/JCycknP2qGEIdeszvnXlFbtGu+HqE
jsHUe5G9g/2S9Ir1EvhoYXj894jcsKyXbHVIvLrPEENHSQZ740IdyZ7ydH5r
jMG1dzn08ZCQRHe3L97aicEnxy7ws7As8jDtcTjagyFpo+DOl0HlhKht1HX4
cwzy7E2VS1adRI2/B8pxVfgnsMVSixHiunddmokHhq11b8P+YI4Swd/spz/w
wkB3p4akGWJC2W6L5hMGhtmRAN/vdMeIPstEnrMfBpPMeyFc1jhR+qlMp90f
A/9PXau6hgmCoduzYyAAw8kX/qfnee+J3epwOzQIg4W1lPFQa5qYV6o0loYo
9D+1Ovbmy4g7s1m7Vk9h0Gman/GKlxNRUlScGo5hxU21xiZolnAZjbPYchaD
3cOZ+rUjc8RkL9PSJBJDkZJbi+PxeaKxo11YchHDF4KyPbbRC0QmdcjWJgbD
tP3G/N7CRYJVV1ZZE4dBHy7eFI4vEQcrjA46x2MY4LpkNriuEGql6U/aEjDY
FDtp9DevEoMF64d8EzGkRrTetw9cJx7xIxv7kzHk/fWgXGKwQaTwhp1CUzBs
+kYmKSnT4Pg1X2ryCoZdBMNcQ0cJ9nEol+irGCQ3JgwdnZVh7fKB1pXrGLia
+YKzPATdUUUeqekY0oShkXQNFSg8rdepnolB5POyRyRShbgT3KPZNxX59YZk
DpV08GAudBtnK/y3vnG/saQORozTfiW3MFBsfu2BUk2QufW/sM7FUHCGYf9V
jDZQTp7MmjzFfdVrrR+idCHbvn7A6a6iL5t8HvqwDbjve4qKC/D//wD+AYcX
4nQ=
             "]], 
            Line[CompressedData["
1:eJw1VXk01fkbvvH9fmRJlgyyjWyTdY4MU64+b7a5dscQyVIS2fdkpiZEuIwx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             "]], 
            Line[CompressedData["
1:eJw1VH1Q03UcZuC+X8UXJNgim4mapoTild5BgN8PshEvQqhgxKsCLhrJEBjD
sVLByMlLQKAkITrBeM0TEHGgvx+KgdGYQENOhHgZgggDQUJFZqu7nrvPPX89
9zyf53P3WRsq3HvI0MDAwEU///Kd2lZ+y2UEBv/Bgn5hO7KTW4KgZ/vwNaOr
LDonXNrfXIYgDOcVBdFv0dsyTZM8KhFUHN6jSBStpJX1l9erriD4MtaxcKvj
clowYn93bxUCcRvvjrGtMY3M2vldNQgy5Tcjfa5iWr6Tv9j/OoLey+yvOlKZ
NBHMl/beQODrx4gorjKiH+VmehxsQLDvnIPJMbYhndC4YUJzC4H9z+xTmnID
2nxCkRHRiKBJ4pHH+VNHXbXw3jZ+B8GswJLlnfOa8uIOtwt/Q6AZU8afS39F
jQklsTMtCE5NxvD8r7+gUvJNWOJWBIbKM59kG89R65uLal8p9f7+nlWyE7NU
4Huql4xOBNaxURW5LdPUindirtWrEbDML25xTHhGNZqxjoi6EUiz5o9xYYqK
W1FnbdOD4JBbOtPfXkttXBIwOtqL4DbUZHe/O051G+kuyfsRTEn4ULl6jDqt
uxASOISgy1XjznEcpSZnHnepRhE8GMy959qioeRaWbbsKQKh2Lmc3jpE+Tyx
9nLWIvBKQPabSgaour6Yu7UzCLwFz1Wleb1U0j1ddYFOf5+Jb84rDnRS25su
Cj9nYBgMzYmQMtupkVvcD00XYbCRNWzhiJTU7prT8pNLMGQ3pOYPFDRRrEJ2
VqQ5hvRow4HPkgupkritUXZWGMLHt5UsE7cSf2H75hlrDHXHecWRQSqyXBA3
XGGDIaBnv1FcUTuJCVEEWu7AMP23m09lvprYu7t4YMBw6KxgTvKgl2i5T1Dj
LgxzrnLh0YW/yAWSdlvCw9An5UaWvz1AFu3osNO6Yygd9y0OCR4ibWuCN6l9
MVhU67w3+Y2S46sYmgw/vX6PreHX1U/Ix6yiQtcADGln+n9QcZ6SPOMxdsMB
DOtkDj+FWmqJOzO9QxSG4aOzTp5utybJwhubDBu+Pm8h7TVaN0VCZ0XMS5EY
vnBR9KzNnibmUxaNgVEY7L0cT9bmzJDmsXop+wiGxmoUd7jkOZEMB9vej8XQ
EP7HxRTVLLHuZzyXxev9329zKl42R/oeFl1xPqrvV5yU9Dj0BclUfxq5kIjB
3CG+Tad+SXbdH9t4/Vv9PuKcvhDBPJn9PX0w+gSGJCqtX7BhgTxaqo54nYyh
hn3lmeqpjtzezZn8PgVDWHMAY1W0AZSmh4nMZBjsaitW7/+OAZltZfPnUzHc
6OJ9UKwwhHiT6RNWGRg8szeXH2QvgiBvu8W1mRg4cTzprxeYwM06nuH0IwY3
v9yFdeEYrDqazZW5GJIX8x+2Ri2BlWYm+X55GFgVwTdrOpfC3L79azXnMLwa
EBb5Va6AvpyCX4QFGMxiZhWdK02hSa3ZMl+IQcoVJUq3m0EZ27omRY7BJ9W3
7MAEC/LXFPu/uYT//yfwD+ZhBOA=
             "]], 
            Line[CompressedData["
1:eJw1VQs01fkWPoT//+cRIdQtbydSiggVv11hzDAUcnXL65CiRl6D0vEqkwiT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             "]], 
            Line[CompressedData["
1:eJw1lHtM01ccxYsF9V5UEEfl6ahRVxhiYwCnc96vVkFjXXgO5FEQ52MDBaUY
MAyZKB1ggFXAwRRtFQwyoUAykIj3N0CoRqSWQXnJo1JARB4VEXzA2JKd5OT8
+ck5fxxuWKTXkUUsFkuw4H8ztKKzoLEaAes/WTBye8tKVg0Crl214dKWzxiv
/AtBEoogd2gZN97cjFm0asJgRS2CEQV/P7fbhCmXBN7OqkcwkPnEIvfQMibs
Y4PQuhFB3QZNR8V5xJid2qyXPUKQsaX/tLvlEqZWd+0K7wmC7mAjn1JsxJwO
QN+UPkWQ2Frn/5eAzaxtFmtdniG4cDXiw8E/DRi1oE9yvwVBs0omUvmxmPNV
+zcK2hAwnh0Ow2SObt5YqX7UjiC053ABNf1ItbK1sR5dCIIDxDsMLd5TKSfd
VvMcAa8s+Zn0wAzdlTZbG9yHoMy5PqX5zjTVz39/fECL4JPj+4EDDm+pXKxa
Hq5DoJT7h2c0vqEGotv+sSMIbmco+a+Fk1ShNpubG0Vw1O3xw02bJmioe8LN
i+MIrHamJF1zG6MM33dMOoXAJ3nguUH0CI0qYC5bvkOQnXnY66FimNpZOW69
MYugU71e6WU0RBPZ7At35xDIa1ziR1++oPzYk/bOBhhaDsnT7c9oad9ox9Nq
NoabdjLVuZX9FNoUlsqlGG4k57Ef9XZTVpGoVGuGwW3L/u0b/Fpow6jm5HVz
DOOuhtND4yp6ie/pFGSBYa/3pRktv4murhLcbbXFEMNXD6J19dSpkVes5GG4
mC3RtGqu0CCdvrBkBwarL8Rf3nnQRNbaRxwN34khfM3P56Jfq8hwhG49bzeG
nRnF5g3zahI9pbkl24fhXnLed8UuGpLKrpFn+WDoCp60GzfsIx7urmGefhh6
BttTop36CSetlLsiAMOwyH1YGqIlcjP5DUkIBsemwGNh3QPkHleSf/ZHDJUz
cZyukBGScIQl2nICw3LBA2G87hXZXRRnOxWJgdUiTt/+02ui4kdcPRGDYbux
jUNPzATJEesCHWIxtKVElTccniRBVSLrobMYsCjYpjdET4aJZ15o4gK/ouPp
stQpUpL0+KBtEobpdYXS6/ffEnGjwLLzIoZRRV134uJ3ZJtxTXvOLxg+DpoI
TcJnyPy3rr95p2FYukfy1mNsltRLS/1M0zGYfL3nyprsDyS1jbe6KRPDsXVR
XUFHPhEPK3lbymUMYqdLnvuOzhOOyDrHLQfDvNOt2lMqFnTLsnzZuRhqhE1n
iekikOuWmzO/Y+DVJ/Qr49hw3F7yd3w+Bh8vt95IjhFsPMHK2irD0H+m9k2e
fjHoFXHe0zcX9otOjljyOYKqKb1ZReEC/4dgYU+5MSR8FaGOLFro7xiYZNO8
AnbH6351/AOD8WTiNmevlYAZkefLEgyzca/8mx+sAhW73bSwbKHvCK2zGeGA
W9XeF77l+P9/gH8A5f7t7A==
             "]], 
            Line[CompressedData["
1:eJw1lWtU1OUWxgdExv7vC8YwchUQQqQYEgRSkHo3CIIUKpNCuBhUHEqIGK5e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             "]], 
            Line[CompressedData["
1:eJw1VHs01HkcnZgN9f0aj6bHxpYMMociEsfh+2lPSYhd1Bwsa+wqlY0lawwW
iWzb69Syk5XHoWwOYmk9ot+wNJ6ZWTTlRJLHamhijMewWrvn7D3nnnvuH/eP
e/+4RiER3qFqNBrt0Br/1U0+rqK9JQho/2GrMDl4Rw67FIF9zwXnDswU6jxv
4I+Ur/kuh2+jtPWEeV7+ftmVCMTx+VZxCQzhHtHCAe9qBLyXP/kHdG8UPnbO
3LyhBoEgZ+9QUqem8Njv+5RNdQhOTxXcsXNbL3xpKe6Na0DAfTGYJ2fThXky
3UR1CsG9uWe5GjFqwpD7PqZXmxBkZ3Ie/TFHE5qeyuzZ3IKAFT7IrYUP1CRL
yst/giCve9I1fXiFKh3ZuovdjuCASdMKs1FFReb7d1Z1IkATSLrQtUjZBOWc
d3qKICCiYPKG5gI1v33IUCRGsJMRYl5+WknVv9gh+qwXgZ5G4BVbmYJK/Jkb
OdCPICXaLHksY5aC44Xbvn6OoKbluMyazFB0/bHm6QEE3dV/NW7Z+J4SiU3D
YwcRsCtF17X7pqnL18KY64YRzAVG1OZUySjdDVOnNo0hSPDy6jFon6D6RJa6
uRMIRq1V9qOLY5QgLaLe7C2CL1+j4FdOo9Qn6xTIUY6gTBIc1bI6TFksLlVy
l9b6bnuSQTjPKPlDxwDZMoLSvPpf44p6qd+iE+kxqwjOrLxRV6pJKAc5jZOh
jsHYiRzOloool3GNlXKM4VKYmafLeAGlVXT0rr0OBtvPbxm9OxtIurg/ejbr
YZha4btzfykkPoPaBf1bMJSamaXyghtIcB/TZcUIg7a+JKEiTExYNznyNBaG
acNVX1Xrn2TC67aAYYZhXvNB1F3zfnKu00C2ywLD6Fhdy6zWAIlvNr5x1A4D
J7w7VGo5QpyTQx167THkK3n0H668IWrOxSNfOGJYLJNYXlWOkow69v5IwLD7
9XBGjmyCeMSGDy19iuFB6/WmC/GThLG//FLqYQxd0629CdtlJKvCeiDLDcPH
vm3SE7feEb9z0ak7j2FwtQoy6jvwnhhYPLQo8cKw9yNldeq+GTI8Od9v443B
hrWnDBxnSWGxfVKjLwYde/mRTh8FORnK332Eg0H0tMbQ/Ps5wjZukIj9MBxS
uRZXNShJRS5hjQZhOE+bbuxIWSQKvkKDy8VQPZDq4KahInacYtngVxgsM4Mi
FWXLhGcT0ON/EsNheaHxMv9v8ojBqJKGYfA46t5Sdf4DWZU1Z/mexcDqdeNF
SGgAbd/xJd+s7Tlj5XRNQw1Si9hBnpEYGC9oRs0h6vAkeehgZxSG6MVDQuot
HTQDb5q4xmBIu3fGOOX+enB3cNFqjcVwe2Im3LJUE64xVVMH+RiYbWWvePSN
IJ4pEz9OwHBnSzSzuwOD/lNutWMSBr7AWmf8hg6cKGEKalMwSEs9PExy9UCQ
3h6//+Ja/nWLkG7LhK7LtppH0vH/fwH/ANH29XU=
             "]], 
            Line[CompressedData["
1:eJw1lHk01WkYx2+uq0ve92fLUkqjsrUwomls79N+I6UmKmTrhlEo0WIijGpS
MVSUSBFpb1RuUb0/W1qQe65EMsy1Fg1RuVkyd+ac+Z7znOd8z3n++DzPec73
O7/Q9dsUOBzOFnn923NO6xvb5SPg/CddNibkJ8nhKwhsm5aedrLSZsscJ4q4
1xHYBO48lpKoySoZF6fH3ERQ6KTgnLFHnV3FDY0eu41gxmFzcegRhj3eYugX
eQfBEqNe/utCVbamuH750D0EFRnCvKiNKqz6mQTT8PsIempX6s104bMbwh3Q
xyIENaFivfhEJTbVZaA/+BGC/N2bU3V4PLZxbl7de4qgUbeq4fwVLquv7H4/
oBTB0JxME6twBda7A2W0lyPY4Z7cc9lrAptdUnLQtxKBaLI2T03IYdszI7b+
+QxBtn1QXD9nnBpHmq70qJLvmypSXO87RoPcms0aahCEPuHEDbeN0OuWydhV
jODeS8mpw/HD1LJH9mpNPQK2Zs3aeeoyGlF5/cGLBgTpbqGZiUNf6P0cn0xB
EwK7PUrG5v2fqb3nU+GSVjl/yv23hWqfaMyiAwIqRVD6x1BNtPUgLdWymGvX
gYBu+5a3wH+ACqrTBq3fIzC1bUnU6OqnCVecXhf0Inj59nzSVut+Wn1ovMi8
D4GZ0LygSqePrncIiDP9hMBH19blSmYv3XJrofq0bwiCJLJxD5tuWuguw7Uc
DPHMrNUrZndRrFSk+isXwwznOxtspnRS1tOe/46PIcDuXKKtQTs1VFk2flcT
w92O+YvU4ltp5D3eWIA2hh0vdovBvYVKfCqHp+jJ5z39eU6iZhovcvwSMx3D
kUNR5npJb2incN2H1aYYgqa1Km/JqaMOapo943Mw9PKDPHVsJDStuK67YD6G
hblxLW31YirQ2NSua4Xhc3ZEv3RxDb1KvZraHTBo2ZoE5L8uoyFTdjw7sAFD
l7b/2uxl6+mTinmV5hsxfEgdflTGpBCDXX3l0s0Y9K188h+lZ5PayjBW4I3h
qcKKb9sbC4hlxH6RVhAGj6RjP1NZKRl6eTj3+kEM793MPAKJhLj8IsjxjsOQ
W022jsbWkXwjlYsahzDI6j1CyitfEfeoExn7EjDMEhdsnu/VQB6anTq57DQG
qJJxpLSZaNW7Jg+lyf3tS6ujZ7eQ4FidpKvpGLwMZ/edFbSS6Q3pCWoXMBg0
rWV9H/9FYg5djH17FcPMhIE1yY3tBO2d6Oh7A4Nyx+ZJVZkdJD0wWKPzFoa9
Fisir/l3kjtOP+b03cWwa8ynKHtiNwH7rO3hIgwr/HJKQlu7SdV8ntXXBxha
sspcnOk70qkuLlegGEzqmOCR33tIGPeHE0dKMFy2tLaqiO8l458yXFXLMXRE
NTmdivlAdBsCOyc/w5AwaNVWnNJHnM5z+KYS+b0jx8J0pg6QhiT/2huvMBh3
hjWG0AEijK06Y9kg5zXgZC7ZPkiihWdM7ZoxBLoa7jd5+4mouH37yLZgWLp4
Dfd19meStlJYtFyKId9xj8GS8C/ktpmF09ouDBe8vGzqbGXEXj9Vs+4dhkjV
72/kWX0lz9Fo06ZeDJNbFTdl2A8Tt3HfS81/Y+jLejZ8dtMIaeuv3OH3EUP1
JBO+5Mgo2SmdZ901iEFB3dvnTfUYGZWcHNv+Rf6fR11jRfPGydGKrxX9Mgyl
gWdfxrhyQFvknRgxgiGN1G6YMHsC5ORXuA2PYRBNf5AwMFEBLNLnGBzkMOCs
EuGwbwIXHh5L7uJyGVB1DIsLnqwIq6KGbv3GY8Awa6tZhoAH9SFb9iE+A5fv
XnuofFEJ/HzKIEWFgYczGi2FRnzoW2eqrIMYmCIK5mZJleHA0iTxOYYBnqbi
vibpJFC2/nx2hgYDwqIeneeLMKQaefjlajEgTuqWBkWrgaFuiZmZDgOVew5G
1ZtowC1l48GbenK++MLYWdZaYDdyvHiBPgOjoY/r/J5rQ5un4OjUacz/+Q3/
AEgioYQ=
             "]], 
            Line[CompressedData["
1:eJwBUQOu/CFib1JlAgAAADQAAAACAAAAx6cXcRY/D0AAAAAAAAAYwO4wILF2
Pw9A34tPTZVPF8B6IoZ5+0EPQL0lKVIJ6hPABxTsQYBED0BrL/wsT04RwJQF
UgoFRw9ADAQqVAd5DsAg97fSiUkPQF2UaPpBGgvAregdmw5MD0CMSHFmx0wI
wIidhWDeTg9AMx3xI+WsBcBkUu0lrlEPQKOF5FbodAPAQAdV631UD0BgzWrV
M40BwBy8vLBNVw9At1of4YfJ/7/4cCR2HVoPQHQyRpEL3vy/0yWMO+1cD0As
79xX9ET6v67a8wC9Xw9APbF5L6Pv97+Kj1vGjGIPQChVuf2l0vW/ZkTDi1xl
D0CUGNFl5OTzv0L5KlEsaA9AWPf7AAsf8r8erpIW/GoPQGKMJXcge/C/+WL6
28ttD0AVBwafbujtv9QXYqGbcA9AgAwMq2cM67+wzMlma3MPQNr7W41AW+i/
aDaZ8Qp5D0CBSU1X3GLjv0TrALfaew9AFGgAZjAS4b8foGh8qn4PQChXNW97
st2/1gk4B0qED0C7KVpZrELVv0Xd1hyJjw9AiD7Al1txtr8ihBRIB6YPQGnX
KdAie9g//jh8DdeoD0BFX5IBEWzcP9nt49Kmqw9AqDez94Q64D+QV7NdRrEP
QLQKqSeUceQ/bAwbIxa0D0D41WSnzKnmP0jBgujltg9ANFM5s3T56D//KlJz
hbwPQCzL2FSb7u0/2t+5OFW/D0BzevqWp07wP7aUIf4kwg9AekAikRG78T+S
SYnD9MQPQCyFubPoP/M/bv7wiMTHD0Df3zSoKeH0P0qzWE6Uyg9AlXlAdJqj
9j8laMATZM0PQDRGs8UBjfg/AB0o2TPQD0BUwZ4ocaT6P9zRj54D0w9A2n4x
Nary/D+4hvdj09UPQN0gcu2qgv8/lDtfKaPYD0CLh2UiOjEBQHDwxu5y2w9A
SKz0iBTSAkBLpS60Qt4PQALOUYvbrwRAJlqWeRLhD0CVABc6r9oGQAIP/j7i
4w9AKmFaL9ZoCUDew2UEsuYPQBDVWNv9eQxAunjNyYHpD0AnJ/J0ZB4QQJYt
NY9R7A9A8R1dpmp8EkBx4pxUIe8PQLN6910IkRVASHTBwsPwD0AAAAAAAAAY
QAeUdso=
             "]]}, "Charting`Private`Tag#1"], {}}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0., 4.}, {-6., 6.}}, 
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
          "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 1]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 4.}, {-6., 6.}}, 
         "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[0, 0, 1]], 
         Line[CompressedData["
1:eJwdUwk0lQsXvcZEGUJcpchQmVIpJeyvaESoTD1RQjQgRJFEiCgNSKEk/aYi
IU9SkihRkpIK7+Wap2u6k3vv99//P2udddZea6+z9zlnHXUP/31ewhQKpVCQ
/6t7vAa/1A6dMaet9T93NbEdohYqAT3UAzg57mz38Wo71t9PzyyjeoKSY1g8
/3o7rFo6nmVRg1E2FExeTmmHkyez5iY1BuOVvbwrWe3oWnPZ4io1BXa9u24X
lrQjW9E27go1Fwntuwrs29sRJVG2MoFajgDaUlmr5d/g7PKghD5ZD/Ku937W
h2+QIqNcdy77DF4vi7cj+Du07McH3wp8tb9fQs/X7kDop81In+lEfX5VfDCj
A0rlct1CQj0Ib6Hqhjb+wPM/Fs2fTf8gc+zj5ocvO1F3PGuJyygNlmk/R0bq
fmJW20zmyakBHNu61Lu+5ReE2UWyS7SGceinopOJVBc2koef7y8exapRcdeg
fd1ojjH61KAzAbE6uHtX9GD59RF2wTgdOfub6FrP/sEIs6f7m+EU5LJMtiP1
X+QOVzdJX5uGZ3XL7TfFfyCtmjdBo81gXvTU3lR6LwjHS129QzPwHVC2L5rt
RWCy+8c/4zPwOa0aV8/pxXch5bx/WDPYXHMmjSJGw73+eLffC2aR3hJeep9K
g8HT4y1fjQS42HXkvAUNNhYGRXUxs/jqb3uy5Q4NSb4V3tmaDLw4VaZbZN+H
YeJJvJQOA8npif8YOPdhp/KjwpA1DNTvskqpdOuDcGPKuLUJA7snqhb9ONGH
c5rBIWxbBlZfSNVyjOuDd8+6uH3hDMzuV7tv/bIPWx2ePhJtE/Rfsuiyg14/
GEQRzSeSiX8tD5XcWzaAl7kjGaExTPzuWLhosfYAoiX09sclMEE4qD+8pT8A
6dbHbx7eYmKecUbQA9MBaLsX3+vOYyLLf6JR4q8BOEaUOh9oZSL9T6GV9J0B
VFRVNkOdhdkrl0w3qwwiTJV1aa82C8oOXj3xKwZBRG3ackiXhaTsuokenUE0
76oqCNvAQseynLjcLYOgdbyIq9jNAmXkYFv8oUEoMGoI3UAW6qgvPd7nDCJ4
XX354rcsWNJerI1YPwRvI7XsG+9Z6Po+UnfXbAjOG88nLvjEwqDoDk7dziFs
MTHyEO5kYVt1U/561yEIb8uVGR9nIYXur58eO4Rk+5jj71TYiFavqI/8OYTC
AEu14EA2AjxXeHleHUZmYLbURCgb2V19Wyl3hnE1mMvwjWDjiXVJZkHuMALO
lre4x7OxlFqwSevlMIwvaoZb3WMj1fCR3NuRYdQni35f0cTG6+D+5Gc2I+gp
rk/8os5B9jGqn5nqKFrHREfXrRTgUsmSGJ1R1Optt07R4+DgkbOdv41HkV34
boGTMQcq2m8ia/eNwuM/DVd/W3Og+jzT3CVhFP1Z75MHQjlIzXGKmmaPYiyp
+RavhYOb32t1yKExdH9cMOP2lQND9zVnKthj+CRpc6D2Bwfvj/s5Rc8fR3F8
i8KlXg66HpjUH149joCYT6kSbA702+RvbDw+jpnw1tvymnM41etgEU4fx9zx
9ozVYXPQaLUxy5Gg48DGQzcMIueQIHmmLUqOjsdC/XHrY+aQsapVxl+FDrd0
5mmza3OQ6UhTCNKj4807lV32OXMYGRF317Kn47LakZmzTXN4aqGU45BFh/z3
Mev3KlxMXJW8tXTbJE4+CNnWspyLnt43LiI2k6g/SRq3aXLhIyycynOaRIiI
nMZvAy7yHPa56PtNotPQiD2xjYufnkzaxYxJ3E8Me6R0QsDXa5Bbx5mE7tZ5
fO9qLk7ElPa3fpjC08KilT9quTBWzJrf/WMKRgp29rsbuFgp2di2cHAKpgPp
ubpfuCjZUx3ZIT6NvVd1rOj9XDQHlElo7JhGYKdN+rlFPGRcf7RMs3kajG1T
b4aVeJCqvL/hYdc0wh+njfylykOZq6yW7cQ0YiJ7zM1X8bBcUzXfUH4GaVqn
+4TNeZi310l27aEZVJ1OWZfky4OzGVeYzpmB+a9Nrjw/Hkyrg4ZyZWZRZ9kV
6xfMgxdtfU6q5iyalLQ77SJ5iBy4bLTGdha/ayojFVN5iHVwdfHKmwVF8lfz
vVqB3uj+K7JeDMQERTJkGnhQu+SRpn6BgfldGmpRH3l4/U0vNvY2A4uengw6
+p2HZ4FhfjYfGdB05FNXjfKQPb8jUsGYiZ056sdKlfhI2mN28LTgz43SpbUb
lvIh4b+Pc9ecBbVrc7Sf6nwIy0qn6LuywDn3zUNUjw9xb2r37XQWntgnuDkR
Ar6YzXjzYjbu7gxRPbmdjw66+3SCMRtxZkd/X9zDx+PGqucNzmwcXm12sPAA
HyZW013NmWzIC0068Hz4yAtpyQjQ5YDC7FJY5MfHgpq0mmQ7DkZHm75qB/HB
EuKPWIdw0PAj194ugg9LG7PosrccnHvqbPPwBh+Ddkn5L7zn0ONea7n7BR+N
SslmFW2Cuzo8EXF7zcfL6Rr2dlEe/ra6WxdYz0d98IUdPzbycNM4mMj8xEfJ
TWak1n0etsusMp34w0e5dl1lqEBnnZjinMggH8ZR3wpW/s3HsjmhF8pjfERI
/aLrzwh89f8y3sbkw2mJ3pKgABJFr5LXp0qRCBM33P3GjEKkl5+fKpAlsWWV
5betRyhETKFv6StFEo9TRTWLYymEW5rFmsHlJBqpdJXgLxTCKslwnKtJYonV
62Aai0JsilZ9IqdDYsPaIFk/dSFCzo+ps8WIBLnyElc4RIjgH6UN2W4m0U1x
vqabI0QMu3zJ9zQnYR4eKZ3/WYio316kfW0XCd0sxd29BsJEqKr7in9dSfxd
bRKSSREhPOwMHX8fIaFXQt0avEmE2HtJ6EqHN4lrh9ukiUARQnvo4WSLYC5l
26oLeqMixKKlZ7Q+nCFRee6z0HU9UYK3d4dLfRgJr7C07lP+okR7+WDtixgS
NKmgoq08UaJ2oGqmIoHE+TRjjbRdYkSRSuKq0msk1MrFRDRuixHRF/Wv56UL
9uZr+/anuTjhV8Z/m5NFovToii3X08UJl/7PzKwcErvyRZRSGeKEoXWge8pj
EkPr6iv4tfOIpZEWt5JLSUiG94lsMpAg5j1TaLzynERrdPieUw8kiClaHye2
WoD5nVN6S+YT3UqVBlG1JG6SeY7KmfOJpj3xHuffkbgYMCI3oClJVES4pIU2
kWg6aSt74rkkkdQ7xzvVLvBLcdKIYEoRZxe3rPXtJHE8sbLcq2ABcXT3PS/P
bhILgy72f/BZSOw973/HvZfEO5+T144ZSxMmJUTLwUESNdkHo2yVZAjtP3JC
jmMkNAIV5CLEZAk5xV4j+ykSK73vGJVekSW4O8t9rJkk9KkGMwqqcsRgWGzm
Ti6JO3Hur2mv5IhhR12fBxQK8fBQtOZw4CLiMF1eeLkIhZjaL11QaCpPfE/g
ZmSKUYi65YllhWoKhJVG3wYVCQrR/OQv58+aikTty5bPtyUpxHo5hvyk3WJi
o+NzX8WFFEKD6pbzqkSJMDU7YH1dgCn/D2XivzIcTJQ=
          "]], 
         Line[{{2.0253997252909666`, -6.}, {
          2.025846542788437, -5.223995978989361}, {
          2.027062670575905, -3.781239979233763}, {
          2.028278798363373, -2.718195603956154}, {
          2.029494926150841, -1.8890168319115048`}, {
          2.030711053938309, -1.211814237128575}, {
          2.031927181725777, -0.6365764351564785}, {
          2.0331433095132447`, -0.13049938942056727`}, {2.0343594373007123`, 
          0.32943316789182053`}, {2.0355755650881804`, 0.760545544288068}, {
          2.0380078206631165`, 1.5911894106183084`}, {2.0393271393937447`, 
          2.0525101200128035`}, {2.0406464581243724`, 2.5430417918038004`}, {
          2.041965776855, 3.0837513831879515`}, {2.0432850955856283`, 
          3.702744922063891}, {2.0446044143162565`, 4.441008810993611}, {
          2.0459237330468847`, 5.363276464892997}, {2.0466136576415557`, 
          6.}}], 
         Line[CompressedData["
1:eJwBwQM+/CFib1JlAgAAADsAAAACAAAAPu6JN8N/AEAAAAAAAAAYwIiun2Yt
gQBAS1jAd9fMFcAUF5Ya4YMAQOn+eXA2qBLAoH+MzpSGAECC1uEuIjUQwCzo
goJIiQBA0DemobR5DMC4UHk2/IsAQPAl+R08OgnAQ7lv6q+OAEBpQYBkxn4G
wM4hZp5jkQBA0kGvkm0oBMBailxSF5QAQACxdflKIQLA5vJSBsuWAEDaIZfO
ZlkAwHJbSbp+mQBAsnEAY6iJ/b/+wz9uMpwAQDU5prL2tPq/iSw2IuaeAECH
qLDQmSb4vxSVLNaZoQBA09Hn7W3T9b+g/SKKTaQAQKyXD+aIsvO/LGYZPgGn
AEAqawf9sLzxv7fOD/K0qQBAJ53NCvPX779CNwamaKwAQHcBh3rzduy/zp/8
WRyvAECAUB1ELE7pv1oI8w3QsQBA8hez/q1W5r/mcOnBg7QAQNTqjTuRiuO/
/UHWKeu5AEBqUoPY0MHcv4iqzN2evABAqgBMAFb2178UE8ORUr8AQFemJMJp
YNO/LOSv+bnEAEA6QJOzkHzFv1qGicmIzwBAJ5UWh5uBsz/m7n99PNIAQACv
1WGtDME/cVd2MfDUAEAUoIUerDDIP4goY5lX2gBAetohhIML0z+2yjxpJuUA
QKUdNT0UOuA/Ew/wCMT6AECkTC0j1qftP9K9iodJ/QBAkHL1MqVO7z+SbCUG
z/8AQGu+dEn2fvA/EspaA9oEAUDNfIycpz3yP9J49YFfBwFAw6r9ZjYm8z+S
J5AA5QkBQDw/wzwJFvQ/EoXF/e8OAUAV7bpYaA/2P9IzYHx1EQFAjJYBfDUb
9z+S4vr6+hMBQFAQ8n/TMvg/EUAw+AUZAUBw3Jws0Iv6P9DuynaLGwFABY7Z
5+rQ+z+QnWX1EB4BQF2TcqVnKf0/EPua8hsjAUB7HJEq4Q8AQNCpNXGhJQFA
DGRlg0LiAECQWNDvJigBQGtGdPZZxQFAUAdrbqwqAUAv1AbT1bsCQA+2Be0x
LQFAIGFrI/jIA0DOZKBrty8BQPhOcFHB8ARAjhM76jwyAUBNwedsKjgGQE7C
1WjCNAFANH6TNHalB0AOcXDnRzcBQK3tZvqjQAlAzh8LZs05AUAl35IhFhQL
QI7OpeRSPAFAb0iccYktDUBOfUBj2D4BQNrfCRGPnw9ADSzb4V1BAUCDxhO7
8EERQMzadWDjQwFAsQY4Dpz/EkCMiRDfaEYBQHPMSE7tIxVATDirXe5IAUDl
YJI0yNgXQI29lFEKSQFAAAAAAAAAGECm0aJn
          "]], 
         Line[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAAzNQ9QvVqAUAAAAAAAAAYwMjGIEo7
bAFAhd/oZATHFcCIdbvIwG4BQJ+Myu+mghLASCRWR0ZxAUDtw99JTvcPwAjT
8MXLcwFA1bkctBTuC8DIgYtEUXYBQPRMlI39nwjAiDAmw9Z4AUD1ZnKGrtwF
wEjfwEFcewFA4//MXxaDA8AHjlvA4X0BQEpa56TSewHAxjz2PmeAAUA8VvMi
wmv/v4brkL3sggFALwe9VStJ/L9Gmis8coUBQO9X3PSZfPm/BknGuveHAUA/
50yIH/f2v8b3YDl9igFAdHQaOfus9L+Gpvu3Ao0BQA1qITfKlPK/RlWWNoiP
AUCy4PVn9KbwvwUEMbUNkgFAx2hhu4O67b/Essszk5QBQLg8lvAYZeq/hGFm
shiXAUDwGDexCkXnvwS/m68jnAFAzxlKivWI4b/aPERI354BQMfiUTGnU92/
r7rs4JqhAUD9NPhuuNrXv1q2PRISpwFAdejOBUwiy7+xrd90ALIBQLT3m0+y
9rQ/hiuIDby0AUAMCKZSXXLDP1ypMKZ3twFAFQc+QAtTzD8IpYHX7rwBQCTi
SjOW/dY/XpwjOt3HAUDNdGuyv4LkPzQazNKYygFAB2aXteLd5j8JmHRrVM0B
QMRAbmS0Sek/tJPFnMvSAUCE7pM4LWLuP4oRbjWH1QFA/+JjKamL8D9gjxbO
QtgBQCeCGGwt9/E/C4tn/7ndAUDJXF8uTw31P+AIEJh14AFAP/NKwWO/9j+2
hrgwMeMBQM7Dg9ygkfg/jARhyezlAUAQKrOrzon6P2KCCWKo6AFA5IZfJfiu
/D84ALL6Y+sBQPB68zXNCf8/DX5akx/uAUBx2GMzldIAQOL7Aizb8AFAtnlz
92tHAkC4eavElvMBQEXpB05O7ANAjvdTXVL2AUCeDA1+6cwFQGN1/PUN+QFA
8eCChef4B0A486SOyfsBQJVRxbjOhQpADnFNJ4X+AUD/jod7C5INQOTu9b9A
AQJAjVudogqlEEC6bJ5Y/AMCQF1f7CbO+BJAkOpG8bcGAkDoL+BNf/oVQB+O
s1sVCAJAAAAAAAAAGEAy6Hs2
          "]], 
         Line[CompressedData["
1:eJw1lHs0FGgYxs33JREGKaRdR8qmMy21pIvmexPlksilXMM0KjFIiRaltpBu
6HKW1cklpag2l4j4Ru4plzKRmDAZlmkrdwpr95x9z3nP88fzx3Pe33nOq80J
tPdBUlJSrnP7r14q+ez2lx4Cqf9GnX9ol+AxezWClMFEw+Rjanz2y0irKRaC
W6vmucSvVeUvstIVFegj8LH3TqB5yvz+mobwI+sQFLQMM5pDmfwy81DVNUYI
wuTHj4dvl+dfq9B60G+M4GLdn1pb0mT5vltrzW9vQlBX5L9U84AMn02DhJ5b
EKjGRu2ziJTmq27RCNUEBOMnanKTBJg/UFzObDVFsDKjN8Wdg/j8DYezEs0R
5Kfutp7UYPBvPFHZussCQQvHV1dzYJb6GZa8k7VGkKgynpb5fprymwQ5RTYI
YpiXAx7LfKeLeV9OHbRDYP9zfMdKjyl6WHahwxIHBHelBrpt305QmrlSt8oJ
wafO2uGIgHGqagqTR50RXBD/0F+pPUZ9ha4vl7shqM+6Ot0lGaGL1OKDo7wQ
fE/KN5bQIXoo7765/n4EuZfLa8MrvtJS2yp1oQ8C5gUOa0bwhR6MnSrb7Ieg
Rq3WWdHsb/psxeLEAR6CqLT0eINcCVUu1/dJCkJgfH1Rr7nhIC2Z5C4cD0Hg
Znomx4PXT5VunBJmhiGofJBpwtXuoz7rkh87hiM4GaXd5CzqpUy/xr25UQjK
vp3PuHdRRLkyA6u9f0NQGzGRqRHcQ59mzJthRiOIi7E78Lt3N93fsfE27wKC
IIfvY/cKhbQozDF02WUExx56dca96KAKiwOt6uMRGMzq2OyUtNNCm9tfVt1A
MMFr63V1bqULqeKWj6kI9pi61VsWN1EvNz2lqxkIpkMvhZntaaAF49tEW+/M
9cFgaEWXRT31NDhx/lY2guv2KaPu7lU0L00kcH2C4LPaxwTe1nzqdrYooLke
ga2ayd4sVgHJtuSklo3N+TXeTX4ZbcSQpc0mkwj8eSXzRdXvSJli13v6DUGO
+GUqkrSTpjceauVSGFYYWOf/ZNJJRjxcLlfIYSgt1HseMt1FIkGdZaaAYdlo
ThdJ6ibzdVrrKpkYYuIGJOL1PUSj31G6WhXDoaRqnl+YiLCD7SJqf8Tw+LXH
huUaYlLjyFxqqY2h8vma3Ju1YmJn3FBYp4PhUwzP62h4H+F8tx5+sWou76lC
sa6kn8RE7zj8ah2G3lIn/0iGhCj5zl+wywhDyL02k3NvJCTZuiqzwRiD2i+b
WjyzP5EcpW3djSYYFOpvTVoFfCZNyWzn19sxDAh9ThTd/UpcIqdH7S0xZDTn
d7L0h0iP57Orb6wxeLYc0OstGSIjKzY1tthhIOqJCZ/EwyRSZtLfyQHDiKwD
d1v0CJk/UCj31gnD2zrGeglrlGg8Mtre6orhvT17eCJxjKQnjIj2emCQFNQt
GXUYJ6xjeafbPDFs6Er/EK41QQr2BGu5cDCkR15XTR+bIOyNa0vfcTGEnnTs
SW+fJDWaX1xdD2IoPGTQKH45RexmHk60+87x3PiIyDd+I5wKlmFHAIb7p4eN
KuVmyGDmYLP7EQxWJi3SCpaz5Fjs/cDOoxgcIiajuXZSMHPYV2HfcQyd+UOM
cjkGxNisyhaGYegoPBpYJGCAkkGfhWc4hlllxBbkIUhWuSP+EIlhRzl395os
DDqj3LNeURgWpE5cOf9kHuS06izvPoPhTsnmgj9E0mBU3EO9z2Gw/ZW+sjCS
gbKUNI+eGAyvmUFEJW8B7Djl9Y0Th0FwKV/xwQE5aPLWShJdxBDHW83odpcH
FzPheu6VuXueM7ra7yhCj+7Nlo8Jc7zELoIfHyqBv6x7sM81DLtDyivYtiow
OrhUSXxjjofw9tgOW1W4drOvJiUJg3+iVuwDZTVgL/Co3pmM///H8A9Ld5l8

          "]], 
         Line[CompressedData["
1:eJw1VAlM03cYLfx+QIeAHCq36BCnHGMO2SQE/p+MU6QMMR0MUCrFC8FwKGMB
OrCoGUIN4IqIIocrzKJAQM7y/4+EY0wOdQiCIrRyVKgU5IbBuiX7ki8vL3nf
y0te8u0+dfFYuDKNRnNR7L9oz/Joj2pCQPtvDChB0VHTdwq+ESuc8NinT7kf
N+zLIxGsnsMa27P1qDGV8Rt+LQjmjhkwc95qU9zaKld6KwK14FdT9WmalPk5
znpzOwJBWFJ0rZk61WJ0tPpSJ4LnO5v5hf5qFOupwQXrLgT8UzNL2muYoiWP
mUt6EKSmt0Wx15SpAtuqodvPEaimpT3jHVainEeTs7/tQ9ClIb5sw9kk32R5
e6sNIBh8p+I327dOJroaoOZBBGzOQgozfpU0XnzXEPcGAUovZ/Yzl8kGQWWM
1QgCFVFEd8b5RTIwMNlSLEbQaSqWp/82Ty6re4tzxxA0sufkYdofSX6Tfp7v
JILvy4dlvb/Mkn1mlZ+IZAiqo3+tPimVkXHPkn6PlSPAT6fz+3+eIvWuHEmw
/IggRGltr9kxKek3LpnkLyOI5gSzpmCMlPMr7jPWFHnDt2l7siQkzyspQGUD
Qdn5Hx/N5Y6SXcIdHTEIQ2nEng+C66/JCycknP2qGEIdeszvnXlFbtGu+HqE
jsHUe5G9g/2S9Ir1EvhoYXj894jcsKyXbHVIvLrPEENHSQZ740IdyZ7ydH5r
jMG1dzn08ZCQRHe3L97aicEnxy7ws7As8jDtcTjagyFpo+DOl0HlhKht1HX4
cwzy7E2VS1adRI2/B8pxVfgnsMVSixHiunddmokHhq11b8P+YI4Swd/spz/w
wkB3p4akGWJC2W6L5hMGhtmRAN/vdMeIPstEnrMfBpPMeyFc1jhR+qlMp90f
A/9PXau6hgmCoduzYyAAw8kX/qfnee+J3epwOzQIg4W1lPFQa5qYV6o0loYo
9D+1Ovbmy4g7s1m7Vk9h0Gman/GKlxNRUlScGo5hxU21xiZolnAZjbPYchaD
3cOZ+rUjc8RkL9PSJBJDkZJbi+PxeaKxo11YchHDF4KyPbbRC0QmdcjWJgbD
tP3G/N7CRYJVV1ZZE4dBHy7eFI4vEQcrjA46x2MY4LpkNriuEGql6U/aEjDY
FDtp9DevEoMF64d8EzGkRrTetw9cJx7xIxv7kzHk/fWgXGKwQaTwhp1CUzBs
+kYmKSnT4Pg1X2ryCoZdBMNcQ0cJ9nEol+irGCQ3JgwdnZVh7fKB1pXrGLia
+YKzPATdUUUeqekY0oShkXQNFSg8rdepnolB5POyRyRShbgT3KPZNxX59YZk
DpV08GAudBtnK/y3vnG/saQORozTfiW3MFBsfu2BUk2QufW/sM7FUHCGYf9V
jDZQTp7MmjzFfdVrrR+idCHbvn7A6a6iL5t8HvqwDbjve4qKC/D//wD+AYcX
4nQ=
          "]], 
         Line[CompressedData["
1:eJw1VXk01fkbvvH9fmRJlgyyjWyTdY4MU64+b7a5dscQyVIS2fdkpiZEuIwx
NzXJlEpRlhLDYNT3IrKcshTuwVjK7trJnp/f75zfc8573vO+533Oec7z/vEo
eoU4nOeh0WgBu/XfXhnJDL5dSwDtf5BiL1Y7XzGqJyDQSM9irVaC3VjatNPQ
QMC4bXsun4I4O6vgaLxtEwFzfU/7QwRE2YEPC4ieFgIYV6Jivq0QZsMdmSTP
twRshV9MeMYVZIuz0vgn2gi43T/jcTyTnz2Wsp0a2kmAiZ01kX6Dj10VFyy8
/oGA6PkQUycOyU6LGcyI6yGg9bdlGyEngu0ZZi8u0EuAkf3Q75d2eNi6frU3
Wf0EcN4ulVe17WGTZ3WlZAYJeDrf2fWYorE5Lrl3cocJeD0UPlySuUMV2R+Q
0xwhgPv6qmFDzzZ1lZGY89cYAW+5HmZKxltUp8cFt28nCagb7MpP79qglKOs
pIumCQg1DS/9PXGdik7V7labJeCJOT2oynaNankgeiN3ngDlsP7LMtqrlGzl
sp3CEgE6uRMFdMXPVMi7HqHsFQIyBNy5Wyor1IHNu9dZGwRsops55u5LlI9o
nInwNgH+TM8iTtoiVaXmTWPuEJDUmZi5t2mB8nBU/ymOIOFI7PYtJfd5qsR/
n8E2IiE+eV/LTf85ijdufukSPwklFs0SNI1Z6klxRVCoMAl3mT7S/D3T1EZ9
ljpXZHfuop8KZE9RNr2Xx33FSVAQdOcGlE9Si8jkrKcUCSbuGz2jr8YpUzlV
+b6DJMg9NH4+0jFG/XGEv++kHAlG9ZN2CTOjFP1Mm6PtIRIGq8fSTtNHqPSL
paItyiSIuKa8Swv+RA2n3XxnpkaC1oetdLv8j9T1qtMMI00SQvz1T0+pD1Pt
YhOGmvokfHNKSjh+uJ86dLh1Lf97Eixv3H+5L7uPisLPypUMSTj0JFfyvlsv
dTAwUkcGSPhuLmVd9HMP5d1AUxKwJIFXTUfNJPo9tRYtLTDhTgL3pXFSam8j
ZZm+1XjuDAmBlIzv+uZr6u6jwWuDXiQcPnUtlke5njLueLzd7UvCo4/OJstC
FJWmrrvQELar72Rtx0vJF5Tiv5ac3EQS3ojxiWfdeYiZdYbPnZJJGE/XceYm
P8WL+ZrX+VJJWOwt/NNbvwTXhQvrBWSQ8BUn/mWx0N/Ye2/nb7rZJGjw2vNk
M+rwkyOnfqgtIWGmeLy1oqwNi0hbykeUkdDIVU8qe9GOY74cW1GuIMHlcXat
HrMDWzbL5ib/Q8I/5hxamdF7PO0x9MWukQRW6/h5k9JurM30rRjoI6GGmdjS
uPAvvhXi8mvGAAlrBtYdKyMDeMfRwtt4mAQV1YDoE32DuF1BQyxvbPcfOWOB
PJNDOKx8NihogQSLyPsxrqsfce+dQVOFZRLqSzS7smI/YePYdpmOz7t8AxrD
R2gEi1mVNuttkSB5yZZupTmK/xqKUtlCCFoYncfOscaxbKPPVjE/ghXrcn+Z
7yZwYqHze08hBEoH9iZs9k3gkxePxtWLIhDpjDhrYzCFX51Wd4k6gKB37gWf
K3cKq56Q0VGTRPDc9eu0hrxpvCq43c+URRBffHLyqNYMPrMwU0ZXQLDfrF9N
amMGN3UPMGcVETyyWuPleTeLbz9gf++ghiDwgqRNqvk8PmaQkCmti0DeO0xd
2mgRd3tJ69/VQ9D3Nk+Vj1rEEenPer42QJBZmUdnmS/holHOwW/oCG6oKrw/
d2EZM0SDawqPI/gQIFf4incFj9J5PXROIGjw+tvxU94Kls/UeqBvjmCt82hk
DN8qrqbqjKsZCCr3Z3DuNa5i52nnESMrBCmTa0vbGWt4+auZxFobBB6hY0ls
33WcYRyvZmaPwOFebuUx6w2sGSzZ3OSAQIzv+Ngi3sTNWUX+1k4IEqVGHAtN
tzDPQnfxj66794PHHf5M+YLvyQba9bgh8J0jEmhtO9iQsWfB1ROBoLp8xtIf
NOBE3GINnEUQF3aEJe+yByJzNPS8vBEkye1VcVPnAZFWdteoD4I3rk1TiaK8
UPzZKdrPD4FpOOcXSVECLA9NS80EIPBj/yDhoUXCmE1sdWjwrv7xpOWq3X18
jITbciiCmp0ouY1OPlB4XLAdHYFAw+yBwWAAP9S045zNqF0/Vs6P9J4QBJet
D3D1EoILussl2t77YEXN/yPPzwhG54Ni8sf3A+vHnWvXryAQV7zs8iJSFLSv
ZqoIxCLQqQlQqLAQh9aCw29+jUdAb2RI+rEkQOunZPPcBPT/fIL/ANbeDp4=

          "]], 
         Line[CompressedData["
1:eJw1VH1Q03UcZuC+X8UXJNgim4mapoTild5BgN8PshEvQqhgxKsCLhrJEBjD
sVLByMlLQKAkITrBeM0TEHGgvx+KgdGYQENOhHgZgggDQUJFZqu7nrvPPX89
9zyf53P3WRsq3HvI0MDAwEU///Kd2lZ+y2UEBv/Bgn5hO7KTW4KgZ/vwNaOr
LDonXNrfXIYgDOcVBdFv0dsyTZM8KhFUHN6jSBStpJX1l9erriD4MtaxcKvj
clowYn93bxUCcRvvjrGtMY3M2vldNQgy5Tcjfa5iWr6Tv9j/OoLey+yvOlKZ
NBHMl/beQODrx4gorjKiH+VmehxsQLDvnIPJMbYhndC4YUJzC4H9z+xTmnID
2nxCkRHRiKBJ4pHH+VNHXbXw3jZ+B8GswJLlnfOa8uIOtwt/Q6AZU8afS39F
jQklsTMtCE5NxvD8r7+gUvJNWOJWBIbKM59kG89R65uLal8p9f7+nlWyE7NU
4Huql4xOBNaxURW5LdPUindirtWrEbDML25xTHhGNZqxjoi6EUiz5o9xYYqK
W1FnbdOD4JBbOtPfXkttXBIwOtqL4DbUZHe/O051G+kuyfsRTEn4ULl6jDqt
uxASOISgy1XjznEcpSZnHnepRhE8GMy959qioeRaWbbsKQKh2Lmc3jpE+Tyx
9nLWIvBKQPabSgaour6Yu7UzCLwFz1Wleb1U0j1ddYFOf5+Jb84rDnRS25su
Cj9nYBgMzYmQMtupkVvcD00XYbCRNWzhiJTU7prT8pNLMGQ3pOYPFDRRrEJ2
VqQ5hvRow4HPkgupkritUXZWGMLHt5UsE7cSf2H75hlrDHXHecWRQSqyXBA3
XGGDIaBnv1FcUTuJCVEEWu7AMP23m09lvprYu7t4YMBw6KxgTvKgl2i5T1Dj
LgxzrnLh0YW/yAWSdlvCw9An5UaWvz1AFu3osNO6Yygd9y0OCR4ibWuCN6l9
MVhU67w3+Y2S46sYmgw/vX6PreHX1U/Ix6yiQtcADGln+n9QcZ6SPOMxdsMB
DOtkDj+FWmqJOzO9QxSG4aOzTp5utybJwhubDBu+Pm8h7TVaN0VCZ0XMS5EY
vnBR9KzNnibmUxaNgVEY7L0cT9bmzJDmsXop+wiGxmoUd7jkOZEMB9vej8XQ
EP7HxRTVLLHuZzyXxev9329zKl42R/oeFl1xPqrvV5yU9Dj0BclUfxq5kIjB
3CG+Tad+SXbdH9t4/Vv9PuKcvhDBPJn9PX0w+gSGJCqtX7BhgTxaqo54nYyh
hn3lmeqpjtzezZn8PgVDWHMAY1W0AZSmh4nMZBjsaitW7/+OAZltZfPnUzHc
6OJ9UKwwhHiT6RNWGRg8szeXH2QvgiBvu8W1mRg4cTzprxeYwM06nuH0IwY3
v9yFdeEYrDqazZW5GJIX8x+2Ri2BlWYm+X55GFgVwTdrOpfC3L79azXnMLwa
EBb5Va6AvpyCX4QFGMxiZhWdK02hSa3ZMl+IQcoVJUq3m0EZ27omRY7BJ9W3
7MAEC/LXFPu/uYT//yfwD+ZhBOA=
          "]], 
         Line[CompressedData["
1:eJw1VQs01fkWPoT//+cRIdQtbydSiggVv11hzDAUcnXL65CiRl6D0vEqkwiT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          "]], 
         Line[CompressedData["
1:eJw1lHtM01ccxYsF9V5UEEfl6ahRVxhiYwCnc96vVkFjXXgO5FEQ52MDBaUY
MAyZKB1ggFXAwRRtFQwyoUAykIj3N0CoRqSWQXnJo1JARB4VEXzA2JKd5OT8
+ck5fxxuWKTXkUUsFkuw4H8ztKKzoLEaAes/WTBye8tKVg0Crl214dKWzxiv
/AtBEoogd2gZN97cjFm0asJgRS2CEQV/P7fbhCmXBN7OqkcwkPnEIvfQMibs
Y4PQuhFB3QZNR8V5xJid2qyXPUKQsaX/tLvlEqZWd+0K7wmC7mAjn1JsxJwO
QN+UPkWQ2Frn/5eAzaxtFmtdniG4cDXiw8E/DRi1oE9yvwVBs0omUvmxmPNV
+zcK2hAwnh0Ow2SObt5YqX7UjiC053ABNf1ItbK1sR5dCIIDxDsMLd5TKSfd
VvMcAa8s+Zn0wAzdlTZbG9yHoMy5PqX5zjTVz39/fECL4JPj+4EDDm+pXKxa
Hq5DoJT7h2c0vqEGotv+sSMIbmco+a+Fk1ShNpubG0Vw1O3xw02bJmioe8LN
i+MIrHamJF1zG6MM33dMOoXAJ3nguUH0CI0qYC5bvkOQnXnY66FimNpZOW69
MYugU71e6WU0RBPZ7At35xDIa1ziR1++oPzYk/bOBhhaDsnT7c9oad9ox9Nq
NoabdjLVuZX9FNoUlsqlGG4k57Ef9XZTVpGoVGuGwW3L/u0b/Fpow6jm5HVz
DOOuhtND4yp6ie/pFGSBYa/3pRktv4murhLcbbXFEMNXD6J19dSpkVes5GG4
mC3RtGqu0CCdvrBkBwarL8Rf3nnQRNbaRxwN34khfM3P56Jfq8hwhG49bzeG
nRnF5g3zahI9pbkl24fhXnLed8UuGpLKrpFn+WDoCp60GzfsIx7urmGefhh6
BttTop36CSetlLsiAMOwyH1YGqIlcjP5DUkIBsemwGNh3QPkHleSf/ZHDJUz
cZyukBGScIQl2nICw3LBA2G87hXZXRRnOxWJgdUiTt/+02ui4kdcPRGDYbux
jUNPzATJEesCHWIxtKVElTccniRBVSLrobMYsCjYpjdET4aJZ15o4gK/ouPp
stQpUpL0+KBtEobpdYXS6/ffEnGjwLLzIoZRRV134uJ3ZJtxTXvOLxg+DpoI
TcJnyPy3rr95p2FYukfy1mNsltRLS/1M0zGYfL3nyprsDyS1jbe6KRPDsXVR
XUFHPhEPK3lbymUMYqdLnvuOzhOOyDrHLQfDvNOt2lMqFnTLsnzZuRhqhE1n
iekikOuWmzO/Y+DVJ/Qr49hw3F7yd3w+Bh8vt95IjhFsPMHK2irD0H+m9k2e
fjHoFXHe0zcX9otOjljyOYKqKb1ZReEC/4dgYU+5MSR8FaGOLFro7xiYZNO8
AnbH6351/AOD8WTiNmevlYAZkefLEgyzca/8mx+sAhW73bSwbKHvCK2zGeGA
W9XeF77l+P9/gH8A5f7t7A==
          "]], 
         Line[CompressedData["
1:eJw1lWtU1OUWxgdExv7vC8YwchUQQqQYEgRSkHo3CIIUKpNCuBhUHEqIGK5e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          "]], 
         Line[CompressedData["
1:eJw1VHs01HkcnZgN9f0aj6bHxpYMMociEsfh+2lPSYhd1Bwsa+wqlY0lawwW
iWzb69Syk5XHoWwOYmk9ot+wNJ6ZWTTlRJLHamhijMewWrvn7D3nnnvuH/eP
e/+4RiER3qFqNBrt0Br/1U0+rqK9JQho/2GrMDl4Rw67FIF9zwXnDswU6jxv
4I+Ur/kuh2+jtPWEeV7+ftmVCMTx+VZxCQzhHtHCAe9qBLyXP/kHdG8UPnbO
3LyhBoEgZ+9QUqem8Njv+5RNdQhOTxXcsXNbL3xpKe6Na0DAfTGYJ2fThXky
3UR1CsG9uWe5GjFqwpD7PqZXmxBkZ3Ie/TFHE5qeyuzZ3IKAFT7IrYUP1CRL
yst/giCve9I1fXiFKh3ZuovdjuCASdMKs1FFReb7d1Z1IkATSLrQtUjZBOWc
d3qKICCiYPKG5gI1v33IUCRGsJMRYl5+WknVv9gh+qwXgZ5G4BVbmYJK/Jkb
OdCPICXaLHksY5aC44Xbvn6OoKbluMyazFB0/bHm6QEE3dV/NW7Z+J4SiU3D
YwcRsCtF17X7pqnL18KY64YRzAVG1OZUySjdDVOnNo0hSPDy6jFon6D6RJa6
uRMIRq1V9qOLY5QgLaLe7C2CL1+j4FdOo9Qn6xTIUY6gTBIc1bI6TFksLlVy
l9b6bnuSQTjPKPlDxwDZMoLSvPpf44p6qd+iE+kxqwjOrLxRV6pJKAc5jZOh
jsHYiRzOloool3GNlXKM4VKYmafLeAGlVXT0rr0OBtvPbxm9OxtIurg/ejbr
YZha4btzfykkPoPaBf1bMJSamaXyghtIcB/TZcUIg7a+JKEiTExYNznyNBaG
acNVX1Xrn2TC67aAYYZhXvNB1F3zfnKu00C2ywLD6Fhdy6zWAIlvNr5x1A4D
J7w7VGo5QpyTQx167THkK3n0H668IWrOxSNfOGJYLJNYXlWOkow69v5IwLD7
9XBGjmyCeMSGDy19iuFB6/WmC/GThLG//FLqYQxd0629CdtlJKvCeiDLDcPH
vm3SE7feEb9z0ak7j2FwtQoy6jvwnhhYPLQo8cKw9yNldeq+GTI8Od9v443B
hrWnDBxnSWGxfVKjLwYde/mRTh8FORnK332Eg0H0tMbQ/Ps5wjZukIj9MBxS
uRZXNShJRS5hjQZhOE+bbuxIWSQKvkKDy8VQPZDq4KahInacYtngVxgsM4Mi
FWXLhGcT0ON/EsNheaHxMv9v8ojBqJKGYfA46t5Sdf4DWZU1Z/mexcDqdeNF
SGgAbd/xJd+s7Tlj5XRNQw1Si9hBnpEYGC9oRs0h6vAkeehgZxSG6MVDQuot
HTQDb5q4xmBIu3fGOOX+enB3cNFqjcVwe2Im3LJUE64xVVMH+RiYbWWvePSN
IJ4pEz9OwHBnSzSzuwOD/lNutWMSBr7AWmf8hg6cKGEKalMwSEs9PExy9UCQ
3h6//+Ja/nWLkG7LhK7LtppH0vH/fwH/ANH29XU=
          "]], 
         Line[CompressedData["
1:eJw1lHk01WkYx2+uq0ve92fLUkqjsrUwomls79N+I6UmKmTrhlEo0WIijGpS
MVSUSBFpb1RuUb0/W1qQe65EMsy1Fg1RuVkyd+ac+Z7znOd8z3n++DzPec73
O7/Q9dsUOBzOFnn923NO6xvb5SPg/CddNibkJ8nhKwhsm5aedrLSZsscJ4q4
1xHYBO48lpKoySoZF6fH3ERQ6KTgnLFHnV3FDY0eu41gxmFzcegRhj3eYugX
eQfBEqNe/utCVbamuH750D0EFRnCvKiNKqz6mQTT8PsIempX6s104bMbwh3Q
xyIENaFivfhEJTbVZaA/+BGC/N2bU3V4PLZxbl7de4qgUbeq4fwVLquv7H4/
oBTB0JxME6twBda7A2W0lyPY4Z7cc9lrAptdUnLQtxKBaLI2T03IYdszI7b+
+QxBtn1QXD9nnBpHmq70qJLvmypSXO87RoPcms0aahCEPuHEDbeN0OuWydhV
jODeS8mpw/HD1LJH9mpNPQK2Zs3aeeoyGlF5/cGLBgTpbqGZiUNf6P0cn0xB
EwK7PUrG5v2fqb3nU+GSVjl/yv23hWqfaMyiAwIqRVD6x1BNtPUgLdWymGvX
gYBu+5a3wH+ACqrTBq3fIzC1bUnU6OqnCVecXhf0Inj59nzSVut+Wn1ovMi8
D4GZ0LygSqePrncIiDP9hMBH19blSmYv3XJrofq0bwiCJLJxD5tuWuguw7Uc
DPHMrNUrZndRrFSk+isXwwznOxtspnRS1tOe/46PIcDuXKKtQTs1VFk2flcT
w92O+YvU4ltp5D3eWIA2hh0vdovBvYVKfCqHp+jJ5z39eU6iZhovcvwSMx3D
kUNR5npJb2incN2H1aYYgqa1Km/JqaMOapo943Mw9PKDPHVsJDStuK67YD6G
hblxLW31YirQ2NSua4Xhc3ZEv3RxDb1KvZraHTBo2ZoE5L8uoyFTdjw7sAFD
l7b/2uxl6+mTinmV5hsxfEgdflTGpBCDXX3l0s0Y9K188h+lZ5PayjBW4I3h
qcKKb9sbC4hlxH6RVhAGj6RjP1NZKRl6eTj3+kEM793MPAKJhLj8IsjxjsOQ
W022jsbWkXwjlYsahzDI6j1CyitfEfeoExn7EjDMEhdsnu/VQB6anTq57DQG
qJJxpLSZaNW7Jg+lyf3tS6ujZ7eQ4FidpKvpGLwMZ/edFbSS6Q3pCWoXMBg0
rWV9H/9FYg5djH17FcPMhIE1yY3tBO2d6Oh7A4Nyx+ZJVZkdJD0wWKPzFoa9
Fisir/l3kjtOP+b03cWwa8ynKHtiNwH7rO3hIgwr/HJKQlu7SdV8ntXXBxha
sspcnOk70qkuLlegGEzqmOCR33tIGPeHE0dKMFy2tLaqiO8l458yXFXLMXRE
NTmdivlAdBsCOyc/w5AwaNVWnNJHnM5z+KYS+b0jx8J0pg6QhiT/2huvMBh3
hjWG0AEijK06Y9kg5zXgZC7ZPkiihWdM7ZoxBLoa7jd5+4mouH37yLZgWLp4
Dfd19meStlJYtFyKId9xj8GS8C/ktpmF09ouDBe8vGzqbGXEXj9Vs+4dhkjV
72/kWX0lz9Fo06ZeDJNbFTdl2A8Tt3HfS81/Y+jLejZ8dtMIaeuv3OH3EUP1
JBO+5Mgo2SmdZ901iEFB3dvnTfUYGZWcHNv+Rf6fR11jRfPGydGKrxX9Mgyl
gWdfxrhyQFvknRgxgiGN1G6YMHsC5ORXuA2PYRBNf5AwMFEBLNLnGBzkMOCs
EuGwbwIXHh5L7uJyGVB1DIsLnqwIq6KGbv3GY8Awa6tZhoAH9SFb9iE+A5fv
XnuofFEJ/HzKIEWFgYczGi2FRnzoW2eqrIMYmCIK5mZJleHA0iTxOYYBnqbi
vibpJFC2/nx2hgYDwqIeneeLMKQaefjlajEgTuqWBkWrgaFuiZmZDgOVew5G
1ZtowC1l48GbenK++MLYWdZaYDdyvHiBPgOjoY/r/J5rQ5un4OjUacz/+Q3/
AEgioYQ=
          "]], 
         Line[CompressedData["
1:eJwBUQOu/CFib1JlAgAAADQAAAACAAAAx6cXcRY/D0AAAAAAAAAYwO4wILF2
Pw9A34tPTZVPF8B6IoZ5+0EPQL0lKVIJ6hPABxTsQYBED0BrL/wsT04RwJQF
UgoFRw9ADAQqVAd5DsAg97fSiUkPQF2UaPpBGgvAregdmw5MD0CMSHFmx0wI
wIidhWDeTg9AMx3xI+WsBcBkUu0lrlEPQKOF5FbodAPAQAdV631UD0BgzWrV
M40BwBy8vLBNVw9At1of4YfJ/7/4cCR2HVoPQHQyRpEL3vy/0yWMO+1cD0As
79xX9ET6v67a8wC9Xw9APbF5L6Pv97+Kj1vGjGIPQChVuf2l0vW/ZkTDi1xl
D0CUGNFl5OTzv0L5KlEsaA9AWPf7AAsf8r8erpIW/GoPQGKMJXcge/C/+WL6
28ttD0AVBwafbujtv9QXYqGbcA9AgAwMq2cM67+wzMlma3MPQNr7W41AW+i/
aDaZ8Qp5D0CBSU1X3GLjv0TrALfaew9AFGgAZjAS4b8foGh8qn4PQChXNW97
st2/1gk4B0qED0C7KVpZrELVv0Xd1hyJjw9AiD7Al1txtr8ihBRIB6YPQGnX
KdAie9g//jh8DdeoD0BFX5IBEWzcP9nt49Kmqw9AqDez94Q64D+QV7NdRrEP
QLQKqSeUceQ/bAwbIxa0D0D41WSnzKnmP0jBgujltg9ANFM5s3T56D//KlJz
hbwPQCzL2FSb7u0/2t+5OFW/D0BzevqWp07wP7aUIf4kwg9AekAikRG78T+S
SYnD9MQPQCyFubPoP/M/bv7wiMTHD0Df3zSoKeH0P0qzWE6Uyg9AlXlAdJqj
9j8laMATZM0PQDRGs8UBjfg/AB0o2TPQD0BUwZ4ocaT6P9zRj54D0w9A2n4x
Nary/D+4hvdj09UPQN0gcu2qgv8/lDtfKaPYD0CLh2UiOjEBQHDwxu5y2w9A
SKz0iBTSAkBLpS60Qt4PQALOUYvbrwRAJlqWeRLhD0CVABc6r9oGQAIP/j7i
4w9AKmFaL9ZoCUDew2UEsuYPQBDVWNv9eQxAunjNyYHpD0AnJ/J0ZB4QQJYt
NY9R7A9A8R1dpmp8EkBx4pxUIe8PQLN6910IkRVASHTBwsPwD0AAAAAAAAAY
QAeUdso=
          "]]}, "Charting`Private`Tag#1"], {}}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PlotRange" -> {{0., 4.}, {-6., 6.}}, 
       "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[0, 0, 1]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Epilog->{
    GrayLevel[0.5], 
    LineBox[{{0, 2.5}, {4, 2.5}}], 
    InsetBox[
     FormBox[
      StyleBox["\"1/4u\"", 
       Directive[FontSize -> 16], StripOnInput -> False], TraditionalForm], {
     0.66, 3.}], 
    GrayLevel[0], 
    PointSize[Large], {
     PointBox[{4.45787752540585, 2.5000045378670173`}], 
     PointBox[{4.433462408701431, 2.4999980490128513`}], 
     PointBox[{4.378668208600178, 2.50000347778907}], 
     PointBox[{4.324804544076598, 2.499998439710522}], 
     PointBox[{4.219072951092543, 2.500001739710168}], 
     PointBox[{4.137425209573348, 2.4999992563414097`}], 
     PointBox[{3.983042908444541, 2.5000005210287863`}], 
     PointBox[{3.8763812727742315`, 2.499999800817788}], 
     PointBox[{3.6803427155918262`, 2.5000000915104135`}], 
     PointBox[{3.5533671469498134`, 2.4999999697709505`}], 
     PointBox[{3.3265050484203775`, 2.5000000095265964`}], 
     PointBox[{3.1863178934068297`, 2.499999997316039}], 
     PointBox[{2.944341451601695, 2.5000000006204774`}], 
     PointBox[{2.801392462925225, 2.4999999998489484`}], 
     PointBox[{2.567264915025017, 2.5000000000294165`}], 
     PointBox[{2.436873206592828, 2.499999999993474}], 
     PointBox[{2.2439983332174167`, 2.5000000000014544`}], 
     PointBox[{2.147306180007024, 2.4999999999997318`}], 
     PointBox[{2.0405350267782314`, 2.500000000000264}], 
     PointBox[{1.9654194650101002`, 2.5000000000000044`}]}},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"f\\\",FontSlant->\\\"Italic\\\"]\\)(\[Omega])\"\
", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["\"\[Omega]\"", HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[FontSize -> 16],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Large,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 4.}, {-6., 6.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Prolog->{
    GrayLevel[0.96], 
    RectangleBox[{0, -6}, {2., 6}]},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6859412573954763`*^9, 3.685941328953821*^9}, 
   3.685941421648086*^9, {3.685942045092661*^9, 3.685942069530216*^9}, {
   3.685942242210415*^9, 3.685942300015469*^9}, 3.6859426001769543`*^9, {
   3.685942832602088*^9, 3.685942842150478*^9}, {3.685942966627302*^9, 
   3.685942995218377*^9}, {3.6859431492277517`*^9, 3.685943162008463*^9}, 
   3.906545142626898*^9, 3.93754491191785*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"1e526e41-6f95-4ecb-81e5-8924656ed08d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]q", "=", "0.1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[CurlyEpsilon]", "[", 
       RowBox[{"k", ",", "v"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Blue", "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"FontSize", "\[Rule]", "16"}], "]"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"k\",FontSlant->\"Italic\"]\)\>\"", ",", 
         "\"\<\[Omega]\>\"", ",", "\"\<Excitation spectrum\>\""}], "}"}]}], 
      ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"\[Pi]", "/", "2"}], ",", "\[Pi]"}], "}"}], ",", 
         "Automatic", ",", "None", ",", "None"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Filling", "\[Rule]", "Top"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "Large"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"q", "+", 
           RowBox[{"\[Pi]", "/", "2"}]}], ",", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"NSolve", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"\[Omega]", ",", "q", ",", "v"}], "]"}], "\[Equal]", 
                
                RowBox[{"1", "/", 
                 RowBox[{"(", 
                  RowBox[{"4", "u"}], ")"}]}]}], ",", "\[Omega]"}], "]"}], 
             "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1", ",", "2"}], "]"}], "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"\[CapitalDelta]", "[", "v", "]"}], "/", "2"}]}]}], "}"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", 
          RowBox[{"-", "\[CapitalDelta]q"}], ",", "\[CapitalDelta]q", ",", 
          "0.1"}], "}"}]}], "]"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], 
   "\[IndentingNewLine]", "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.68594232385261*^9, 3.685942475281839*^9}, 
   3.6859425346355333`*^9, {3.685942614429184*^9, 3.685942789947144*^9}, {
   3.685942854360304*^9, 3.685942951476561*^9}, {3.6859430742110777`*^9, 
   3.6859431402336597`*^9}, {3.685943816866067*^9, 3.685943912994564*^9}, {
   3.906545155762065*^9, 3.9065451566757107`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"8e98b76a-bc11-440f-8c79-b450ec491a53"],

Cell[BoxData[
 GraphicsBox[{
   InterpretationBox[{
     TagBox[{GraphicsComplexBox[CompressedData["
1:eJw1mXk41N37x+cjzXyEkqIQQtmTsha6TxKhUIpKWpQUJTyWFGmzpWSJorIk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        "], {{
          {RGBColor[0, 0, 1], Opacity[0.2], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwl1HV41WUYBuDRGzVidI5mow0UCWmQ0mFMQqVFYiqKSjNaUDBQwQSlBAtU
2la6lBYTC1RMQECR+7344z7P875n187Z9/uupfbNyhieMyEhIQczvDSS03Nc
7LGr4+VLOUo+J4fKimQz1HyLLMI4dpvvkTXooF8rc/KBfqeswhx9oCzNQf0S
Wup/yVVMpK85hb16bzL1/GzVnyK+b13zV/J5htGR6+xy8aH+CJfSyvy3fJPs
+L7kop791/IFhnMNl9Ha/qR8i0ncSm7q238jF5BFJy6njf0p+TaTuY08NLD/
Vi6Mv53ONCYvDb13VL7IXXThCvKRSBL5KUBBClGYZIpQlGIUJ4USNPI7v5Mv
cTdduZKSccbe+14uYgTdaEJb+9NyNVPoQ6k4N/sf5OJ4nvEcybDLzUf6o1xF
O/M/cg1T47lROs7R/ke5hHvjudDdLg8f64/RlPbmM3It0+hnLsG+6NysF2Cb
Po/Bejk+18vE+es/yaVxB/RKjIxnJouyJz5f1iRDv17mZQyfxNnLqkzmcfMg
WYYJHDLfL9OYSjNzB3lWjpbr4t7Iykxiurm/LMl49ptHylr013vIgmyP5yOr
MV+/Q5bniF427oh+TC7jvrhP5mJ8GmfIDXo+NulzaR5333xOrmcGA+hpV4gd
+tOUiztmPi5fjr8tzoMWcfft/5UbeJCBlI/7Y/+zXM4D8dlcTYW4P977Ra5g
FDfSkopUojKpVKEq1ahODWpSi9qkkU6duFN+56/ylThjbqIVdeO+eO+EfJUx
ZNKaTvb/yY3MjGdIPZrZ/yZfY2zcJdrQ2f68fIdZ3E79OEf73+XrjIvnRVu6
2P8v3+WhuIM0iHOz/0O+wfg47zgDu0Q260/Qjq7xT5T3xMPxvOllLsxO/Rka
xrma/5QrmUAfc3E+i5+Ps9CT2KI/Gd9bL8thvT3d4v817+tZMpXZcRdkKQ7E
fZK1GaL3lsmMZZd5hKzOFJ41D5EVmMgX8fxlOtO4AAc6pzc=
             "]]]}, {}, {}, {}}, {{}, {}, 
          TagBox[
           {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1.], 
            LineBox[CompressedData["
1:eJwl1Xe4DnQUB/Br7723a++VUWa27G4USWWErJuEkr2aRpG9ZWREqLSHUdo0
KAqZZZRUZH/O0x+f93vOee/zjt/vPO9N7JmcNDhFQkLCUx4iK3n4RY6Ui+VA
WZQJDNTfL7Mzhm/0j8kytFJ3lCn5WP2ILMEMdR+Zn/3qW2isviC3MJ6e+tx8
p+5OF3VGPlPPJSWV9YfkEgZxB3eapWK7+gVq0kT/t9zKhPi8pKKK+WG5lMG0
phZNzf+RrzORB0hNVfMjchnJtKE2zcz/lW8wiQdJQzXzX+Xy+O60pQ5pqe65
o3IFQ2jHraQjPRnISCYyk4WsZCM7OchJLnKThxpe85h8mUdpz23kjTP23HG5
kqF0oC7NzS/KN5lMD/LFuZmfkKviPuMeSTJLzQ71i9Sjhf6S3MaUuDfyxzma
n5SrGRb3wl1madipnkl9Wur/k2/FvtFLn4fvo6arOhOfq+fxsLoQB9QF4vzV
p+Sa2AF1MYbHnckc7In3l2VJUneSaRnFrjh7WZJJzNL3lQUYx4/6x2UFptBA
30pelk/Kt2NvZHEm8rS+t8zLWH7QD5fl6K2+V2bmi7gfWYr56v6yMAfVBWNH
1L/JVxgR+6TPyd44Qzqr0/GJ+iUaxu7rr8h3eIaH6GaWhS/VCygUO6b/Xa6N
7xbnQaPYffOr8l2epQ+FY3/MT8t1PBHvze0Uif3x3Bm5npHcTWOKUoziJFKC
kpSiNGUoSznKU4GKVIqd8ppn5YY4Y+6hCZVjXzx3Tr7KKLrQlDbm1+R7PBd3
SBUamP8hNzI6dolmtDW/Lt/nefpRNc7R/E+5iTFxXzSnnfkN+QFTYwepFudm
fl6+xtg47zgDs/R8qp5NC9rHjygfimlx39ynz8pX6oVUj3PV/yU3M44e+lx8
G38fZ6HOwG71nPjc6oL8pG5Jh/i95iN1skxkeuyCzMe+2CdZngHq7jIbo/la
P1SWZjKL9ANkEcbzc9y/rJji//8LNfQ3AZ/WpiA=
             "]]},
           Annotation[#, "Charting`Private`Tag#1"]& ]}}], {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {
         GraphicsComplex[CompressedData["
1:eJw1mXk41N37x+cjzXyEkqIQQtmTsha6TxKhUIpKWpQUJTyWFGmzpWSJorIk
Wz1kTZJCyJaEZEllCeHRZyxjZmy/0++6vv5xvS9nznKf837d9z1kHC7sc+Sh
0WihBI329/eid0sa+7TctyVO3n/o00egyPEj+bFRL2DbJvn9174RSK/KbInh
P2XwdYJzzKSKQG6XLE7ku9XAMX5vX55kAp1/5RjOI9cESvIuqYQbgVqHTPnS
HVohUlzLVEGVQLc2smgvD7WDpc2wgM8PGnJXqYkpS/0GI4JMXscrNMQ96ZLd
7foTPHw9fQqX05BDqY1VxOlecJLc+MrScAFOMlvLykL6gfZcZGW7zjzcVi+6
kBY0API23SU6qnPAU1akc/PSEIgsenbIX3QWliubN/54MAwrz9sOU51c2JVo
mEJFjQIr8aqS8zMOrPrTYBxQNAar6H19EYfYEP/hNbHoLAV3n22JFhacBn3J
7QtrTzEhegfvp4TOKVD5KdTv7zkO193eTAw8mISsDOEzhR4TIPfwC1XrPwF+
3+1bVIImoV7jefXw6XFw19c1T7g3Be29X0PiLjOBm2jkMBLBAsmYr57/1VPQ
5BZ/3OfJNJw3nLCdN6Zgi4nsfHcyGzb947pAIymo3bklAz3igJncxTtmDApS
c+O29D7ngvmHYyvazSgQkVN1Ppo5A2qZORPy1RQ0E+R1sTezsE7QtSw7kAmF
5D9pTbVzkGZw5Letxzioigg5O1TNw/gq3Whx9wn4E85aqdG2ACJLvlxKT5oE
ueDgjRecacgrJvSJ08cp6D3c1Wk4SEOMmiVJ1XMs2PWrhVPoSiBTwzsm+rvZ
cNHD8YzofwTquVgzvHCdAxYvH5qJevOgFs84mvdHLozNOvstYvGgbTDxQoA9
A8lfrxW4/rMIxYhL+xkIzQH3jMFx35lFiH+ACF22cR4k5yLt3C/xItG1k691
FBdgwCSsjuRdjBqX7nBoXEZD7+UbQCpsMSpSez1f6UdDzmQarwwfHanZnbrm
20ZDRUnrDN5H0lHAmzS1eSUCNerpV+1bzkCBB8XyApwJxHZ+aH08nIGe6l14
kfuIQDVWiQcERUn0Rubd3MZKAjls0U9Pv0ei79W84+86CbRJL9N8RoYP/c8P
+86JdT6ISgSxHJHvxT0E+kHIFg3avoLB+7Rzo80EaktsKOS6V0Jpyus9/QUE
Sp0SgCN2DfDTZE2Wwi0CJTV9rW81bAbRoK39LEsCbRRYG6h2tA0eGMSsO8Ug
kLeg+TJHwSnI4+8fbxphgrbr27ZKYRZkWh/e9VuSCY4hF07kik1Da5rL9XPX
KOA9cvSFsiwbeLReTNZKU3CteoP1MmkO6LzbvJygUVB0+bfb8nX4Hqx9Dx1e
S4H9cO/eJOUZUH+l3/sAf95TWJxVsnkWDKX/vTQrxQSjQIOVU4ZzoJl3+XQm
iwkR+3+t9dhDR99W+sgI8RDI0FWdCPtMR1HNXrUD5gQ62eJyu8OSgYr0nb30
Agn00/5xq3YzA3VIDiqdySOQSNX5K4cPkOiDeex+zc8EMnvt4bu3i0SRTzrO
meL4fTkWpfA46i78euigROL43jM4ExInVAB0573aW9oJFJLHfzzBowISij7J
BJUSaMmrDU2M03VQPDYpvBBDoKBKqayRzZ+h1I747nWcQNe5mh+cj3+Bn4+X
TKuIE4jjtd+9pnYSOvM3qq5SHIf9B2YiclumYKvhnmg7cyaor+w8YfGFBa7S
dQMlTylwPj3L2Ns7Dc5bm99f2URBNz0jw/snGwb90hxX81BQdjxSQOknB9IG
rwo8Wk4BYfF25/YRLkzuzst0P0VBpbicuuDYDIhOLHSVURSEvZc1D16YhfTJ
O/Jlb5jgn10VZapCRzOR22NejdKQX7CydHouHe0qWHrfTo9ADxitirHqDCR2
8mPKzosEOndqzT3zHAYq457YsCSDQGO36MP5WiSavOjPWluP35uvbcRsEYnC
U1LG734nkH2rZgQzKx1UbaDz9g8CKVd3/dJKfAN+ngqRDxsIJHfnDr+tezXU
KJq/d3hOIKQxmpVj1Qhhg70e/v4EWh18bU37XhY4Ug22pyYoiJ/lPbHy6DTs
qabFyjpQkLC3zIbXgQ3qk249FD7/+qD8uXR7DlgdEyFKCQqyY7d/4ThxQZ5v
H/LSoKA4iHF04ewMbOPdM6fxhALygHafK5OOeHNl+BLsCKSWuIhac4GBnkds
+nEskkD7baVEZCcZyNfAxquuhED6C63ChBeJCsQbrpxtI9Bb7h2HtHkSfbUL
5B/tJVCn8c2K1KgA8CGb3trh9+Nqx+8+PpoLGjlH+vyxf3v1VLQoj3K4L5f3
83o5gQzE3j6wd6mFhd0Ttg8fEujStgrJ6WdN4FHPa3z4DIGeu8NQSE8rGHnQ
LHfIEWir8iFZbvok2Cr0zG8yGYfeGrExhYIpiJvL1JM7yQSRw8t61+SzIMdE
v7iziILHLuaapyqmwXJG/XS1HgX8Co7WyuU4Xn90G6N4KTCyduzUfMuBfTef
f+/np6Bl4fm7yHoueAlvSd9kS8FogsLHwvoZYBbNSM114ng6xJxu6p4FlSCN
+o4kJnh2FZpridPRUcHopsIeGhK/p6BWmExH519/EfiwmUD5MqTP5Frsv7eP
4vzcCZQ32DVxIJGBug+5K/s/IVDXf82JP9eTKGQ7IVf5gUCPOmol9qWR6J3a
pTd1OL/vqEqaTyhJAf1nh9Tf/SQQb/+VxvDLr0E0scir/xOB/ESzfma4V8Gj
JBc3yCGQxz0/b7rNRxhZttA2eoNA6dxEX4vNLOha8UnYhGTCVcOtPb160/Dp
yUCVkTsFn22W3VhlyIZAdjT9xGoKrNPcMuy2cWCxwMbUU5hXm0NFUhYbcyEz
PNzZXgn7R3fqq6UZzhuUYrpvJM5/JzTG/Xro6I2PN0+3NYF2Fetsu3yMgVTu
DQ47hREovrPbU7WPgcxQ1FfdIgIpOiTXbHAk0VBr36vhFgLdPEwbmxkl0RQ9
4aEBfj9SFsyXE1n3oc73YLcf1q+lqxKR5kto9s+2z/+CedX4tCdgmgWLiywy
Y6Io0DmR1WXAw4b/HD79UFKk4MXA8FzFAhtuCY8dicL713ct3SbJw4WSwLqr
rvh8PIpbNYN3kuip17SDcSOBhMR/8abXkkjR8VnQMhxfn74aGaOk57Bxv0Gf
LPbvud3uysxrbIiYdll1WYCCaUfWvkk/DthnpDbz4fej/PQ8YyyUCzG9H2QS
t1Fg+Yi0b71JoqiPj2JzMC/Z8RJfrYT4kDbaVrQf++HXyjPsl1EXQPm53VM3
rO2Gj/yS6soBBe/tlcFdBAqnlUiLTZSBJf2r0rn3mCemdH9yrAbCDc3vHkgg
kOfMirbZ003w3MctXusc5kVWJXvVk1ZYw7pfUqKA57vZxRW+PwnF0wJcrs04
POPJXHPy6RTUDtxr3nWBCeSckizvExZMXd0wUFVOgfaYR935vGnINFhxxWg7
BbJF7xVv5rLhrIynrwqdgqDdluVbsziwLFmS15OPgjftT2aLS7hgJejSM2hF
Aa0nU+LW6xnoTr5D92yiAOVZTE42zMJBiaNBqtFM+MPcoPh8OR15Br5slfpG
Q2fE07TexNHRJofwdWfVCFSmJpsgJ8ZACq+qE3hxHXMgs0SuK5aB4tKttyQm
4vwuXcxlSeL8b6jDoVUTKIDvRo/fYxLt0G4jG3G8Xpa2FXpVJMMJ8yy/HTh/
jXs0GZacLQZGvEiEG85vSl369Z+ZlXDZiN35AOc/garKw7ntDVA+u7tNKBjz
SXNjRqgsC25pfw+grWCCx6/9MnXK09BiGaih64vzT4e2mMxmNpyOGQlgSWCt
/cm/UI0DdQ9sYSV+X57XF0L5tbhw6WTY2uJ1WC8fXXlx6wz0d77oPB9KweRg
LudGBx0xuqZChnB9YVO91/GZLQOpa/82OBiC+feo9GluJwMJkVHH23F9khAd
LGdkT6Lmyqu+sbh+cbpVnC/fTyJBsSy9Bnw+XrBfn1wSDVd4F12qxf5IzxZd
eV62EBQvHHCdxzw2cH8n4zTAAhF783OhD3E929fqbjI+Dds01nwpVKWg2tu0
ZQ3FhntS0o3aOD9ccUpfL8fkwIi1NrdnJQUXD629+9iARF8Sf8a/xvlpwjSh
7nMZiTju+e4Hcf4a7ppvF0/PBGczm+bv2B+LPz0o47qz4XOpZrzoMgqWsvYr
WpznQOOy6N5KnJ/PPbYdm7jIBcmkGskhXbz+x7GiYT8S+b09Rdz7ivlX1/ro
MoMPHXdREFfCfkje7szLzgqGvgciI7pYT8bSrzQ1sWG+WkBUZxH27+HLE2qf
OMDSeMB8tBTns0whG4UXJEpJ4uF/2U2gpgZnk5qCVKii/+aoYj/rtg6OCu5j
w6GiE2V8IpgHosIthAUH9v4aNhjH95esbKL4eYpEeRs+hT3G8dS1D9xlnPQQ
ym07rWWxfmBzW/HsMg78IgckVPD4DcMq4NdMIkemrHohnr+51vTeYCQbvARW
XZdaQsHPL/f9429zgD/0T2nYYgpWujgslxfjQ8s+ePa64vNwczae6og6Bl+G
K7u9sG7ODZTW2pcDIkrusXTM+/5enpgN+WVQpOIbbIfrXzkH5T/2L2qAb940
Owv7gerQz1swaoKqlvBQSeyXJeaMa8eut8IxsVKpCVxfn8td45QYPgkf4ZfQ
2NFxCE+k8q8+mgJ2h1uzixcTrlnoVPjEsSD05JRyM+5PbrwIivF4Ng0vmgXY
YkYUqC14rMjNZEP31oonS3F/o2haWVD6lANrllQfssH9j/pOKYnGfC5cV24u
bN9DwRKeEcPJ3BmwNbs4vhP3T3yHVfSCK2fhklJfhtNtJqjOnRU9LYjr/0iT
qT0dNBRh71j8LoaO2k99NdPC/aeJ1otNeiIMtPPX3uodmGfyt56XPI5iIOW6
dU7KmHeCuqqKPOIkcg69oSX+t79NPmYkHEeiWlaekin2P1XsvrynKgky/9Q5
X8X+OLOV4/f55ytI7lscpI79c7X0JhrIrQSyJdy6LJ9AB7uHGujxDZCyYcXg
Y+y/fZ+9IV2cBRmISbuwmgmj2g7lBrLTsN1AwsTMH9fr8Wb965XZEGMScKVd
kgLvK1fO9Mpz4OQteWIRfg+iAZ7+4apcGF5WxbgmS8GQv5PG7c0z4HRgtb9f
IAUSKu7+wV/oSEEgbO/vPQT61vCdXW7NQGFf6v3qgwi01D9L37MN8+7giP4T
vL/D/3KtLA+R6LhMvNwg5tdB2VjRNz9IdDpIiOcOPp+PTvQ3n4pIMKl3uDv8
N196g8WNuAIwyLjT9Rj76WVFQ3lnNwu2CD7tEk+iQDJ1SH/38DR4bqnOFd6I
+9G37FLTITaUpnZMJWL/S59aI5Y2xIHYuJuq2iso0PCIfpOxhUTur4Ru/sH1
bH/PpQ1Ob0jkwrY5xsJ+X9cepxn0LAPWmRhG62Ae7Iv4N2zhLBuMadzBy0IU
iG/jXXHZkQO0sT8WW7D/BeMberzduND5ZPc6eW3cDw2c+DV1kUTfctL9aXi/
DQ65C0KL+NCZ9US5APZD8OY2j9SSGxBYUyi8G2vaj8IzczVsmB04tq8b+z/F
hhrIreZAkP7CIl1BCp5t/+/Vm2e4njgZEGGI/b+kdnGKxqun8EPPttkH+/Nm
zEyRsBkbbsS+jcsSpWDX0fJSNWMORP1Irk/B9xdVIRd2mkmiOOGS8gs4ns8P
lCysSY+DrtsqNnuxfpqgtyKWwYFkw1ERWzxe6jr5ZHkjiUYuj4ScwvNLh9kf
Gw1lg09BxqgRrh9HJU3OfLjJgXupBsrvcX1AXwSeJSv5kPEtsZmT+DxpikcS
adk+4Ljt6B8nrEUvrNxmW8yGVKn+IFvMi6Nj0tEh2hzIpm7Ua+L1vMe/WUUO
kWjftQgxBt5PpLGCa11BDCxVtvr99G99pBY/9GeaDdvfkdQ3PJ4nO9VAxgvX
/79/Fx/D8RrezN4ywM+HQg4Pi27H65VYzceYJYXB6j8sE1mshyxso1Pa2cCI
LZZIwvel3ugw1HqAA1uVv3Mt8fvIiXKu0uOSyIenklON17u9tNtAfxUHuEk3
LizF68m2BGZHSPIh51Sz8395tv73Wz2paEvwMJVR/duf3xGJ1y8TzIF/o777
GGG+CbWmfdKJLoP1hSf7P2O+mbnqZ5ARNXCt1OHKwSTcf5juXUtoNsHFgInl
QhcI9CdOcecNj1ZQjJR8KKiC84GJwWPHW5PAs3T7lhGHcaC53gu4+2AKHCSG
bK9dZMK2aYOoTTG4f3S5RNnX4vosQmjGM20a7huPmd/aSYFmSl3Ih1Q2ZH7s
Hw7EfLv44YpaQBIH6jdF6jRi7Txjp9z+ggtbjN5H2eymICIqzCYzawaGRNXu
FtRQMJYVd9SqbBZcr+cX8IUyoZ4n5M4Ofjqy//hxQ/9XGlq3YHS5PJqOzpou
rBPH+731ymvGeAUDffj5RM7BhUB3L6UwAiIYaHApFez6mEDOlb/eMlaTSOuZ
ZEgqjsfZ/z5OfYsl0frVv1cvxnwT0IV3sSZJkCbeEP0Y+39dgmD8kUevYP9J
xkw45tvzbMXLVGQlnLvmW7YP1w9XfnMDcy81gKCMr8bJUAJVJorzvxRlwVuj
/n+VJZiQ8eNM5LTkNHScaD9+KAC/t8utporybJh5K27+SYoCP9m2brYsBxzl
T0rT8P2enlObtlTkgnBn0XUXGXzfmqmGsWoz0LLflxVyA/dDDVYQ2kJHwlYh
PkO7CbTWKrXi414Gmint6FmE+eZzPjXkQCsDxdJ25y7GfHulWzC435ZEM1d0
VMIx3/a68tYEdZOo0m6gwgWfL1dDTbevKgImPD7Vc/B76+iwdll6oAAgzpB/
FPPiH5eWyHsdLNg8/9P1LO5fKwM9nlgMTEPtmbxWY3UK2h2sNI73s0FXpcOo
E79ft962KKd+3N8VHRo4LYzvc363dbYOiYI9xf8NwXzr3vD7+6bXJGoT2Vnw
HvMN2Tj16qlmQEgNLc0B843tps0kTrNhp17cBU3cX6/ttQuJPMGBJWHKwMHz
H10dbKd7jgtF9f3h9ZoUfPeQ8JvxJlE5X/z5QlyPVWVL53bR+FDcfANzFp+H
qyyg7FdxDQyENA/+7QfoNwS/r6hig0ZEoKI25sVk67Pj/1Rgftwa1bmN+42U
O3bOwRkk2nMucxMD803epMXq95ansCo3nXqI+aPsHSgpYswG9wHZo4GrKLDg
EdPYaciBs7rdFtfx/YUtjdLf9Ae/L3XVrbZ4/f69NnYhzx5AZYpCqBPWzwyj
Q/5dhPl/s/OTBx6/qtHb+ls97kfjlKK34vmrXQYrxwLZsGiZ5ZLvmG/j5Qnd
3Vc5wDNSFnsK73fBImt9kDAfuutX0n8En+e2WI1gdsk/YLnbsvgc1mtWnMs/
X8iGi3Fr495hvp2K8iETN3OgsLLgoSxez3WbOc+RARJV1a3SHsb3X2dYUav1
6h7wSK1ILsL7K2tm2tMn2aAdXTPFwPEm983l6bhzwPr+iKMQ5lvvldMjOXx8
qERE9KlW319+aO6RSQ+Fw+FTpBrWY+PZ5OtWNlxq9s/5jfmm7fHafmQvB3qN
12lI4/kyvrd709kkmmiyaMzD60XlaebvW8GBDWvZXeJ4fxLSk8fsJPhQR7Jb
vgeeL5cFX5ZnO4E153rOP1i7dcpP1CtzwEPp0ks+PL5BPHmXxigbpB7/uHgW
z98qusPCeDEfauyV9pXA41duTSppLAgEr4UDY4ZYG74+u2u1GQdmZ49I1OLP
J3D7Hgfwc0C9yWAjYC1Y1FRBifIhpdu23LN4fJkOpW6ddBkq2SHGDlgfNKuR
9NjKgYdF+Y1meHzBLcN/OmbY4F1OlhZizRwIDZFYyoc8W594mOPxQc6BNesl
OBB6/l7bYvx35eBVc1XSfCjHj0foL6//9/0q7f9/SPS//z/8T/8ftkB/Mg==

          "], {{{
             EdgeForm[], 
             Directive[
              RGBColor[0, 0, 1], 
              Opacity[0.2]], 
             GraphicsGroup[{
               Polygon[CompressedData["
1:eJwl1HV41WUYBuDRGzVidI5mow0UCWmQ0mFMQqVFYiqKSjNaUDBQwQSlBAtU
2la6lBYTC1RMQECR+7344z7P875n187Z9/uupfbNyhieMyEhIQczvDSS03Nc
7LGr4+VLOUo+J4fKimQz1HyLLMI4dpvvkTXooF8rc/KBfqeswhx9oCzNQf0S
Wup/yVVMpK85hb16bzL1/GzVnyK+b13zV/J5htGR6+xy8aH+CJfSyvy3fJPs
+L7kop791/IFhnMNl9Ha/qR8i0ncSm7q238jF5BFJy6njf0p+TaTuY08NLD/
Vi6Mv53ONCYvDb13VL7IXXThCvKRSBL5KUBBClGYZIpQlGIUJ4USNPI7v5Mv
cTdduZKSccbe+14uYgTdaEJb+9NyNVPoQ6k4N/sf5OJ4nvEcybDLzUf6o1xF
O/M/cg1T47lROs7R/ke5hHvjudDdLg8f64/RlPbmM3It0+hnLsG+6NysF2Cb
Po/Bejk+18vE+es/yaVxB/RKjIxnJouyJz5f1iRDv17mZQyfxNnLqkzmcfMg
WYYJHDLfL9OYSjNzB3lWjpbr4t7Iykxiurm/LMl49ptHylr013vIgmyP5yOr
MV+/Q5bniF427oh+TC7jvrhP5mJ8GmfIDXo+NulzaR5333xOrmcGA+hpV4gd
+tOUiztmPi5fjr8tzoMWcfft/5UbeJCBlI/7Y/+zXM4D8dlcTYW4P977Ra5g
FDfSkopUojKpVKEq1ahODWpSi9qkkU6duFN+56/ylThjbqIVdeO+eO+EfJUx
ZNKaTvb/yY3MjGdIPZrZ/yZfY2zcJdrQ2f68fIdZ3E79OEf73+XrjIvnRVu6
2P8v3+WhuIM0iHOz/0O+wfg47zgDu0Q260/Qjq7xT5T3xMPxvOllLsxO/Rka
xrma/5QrmUAfc3E+i5+Ps9CT2KI/Gd9bL8thvT3d4v817+tZMpXZcRdkKQ7E
fZK1GaL3lsmMZZd5hKzOFJ41D5EVmMgX8fxlOtO4AAc6pzc=
                "]]}]}, {}, {}, {}}, {{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1]], 
              Line[CompressedData["
1:eJwl1Xe4DnQUB/Br7723a++VUWa27G4USWWErJuEkr2aRpG9ZWREqLSHUdo0
KAqZZZRUZH/O0x+f93vOee/zjt/vPO9N7JmcNDhFQkLCUx4iK3n4RY6Ui+VA
WZQJDNTfL7Mzhm/0j8kytFJ3lCn5WP2ILMEMdR+Zn/3qW2isviC3MJ6e+tx8
p+5OF3VGPlPPJSWV9YfkEgZxB3eapWK7+gVq0kT/t9zKhPi8pKKK+WG5lMG0
phZNzf+RrzORB0hNVfMjchnJtKE2zcz/lW8wiQdJQzXzX+Xy+O60pQ5pqe65
o3IFQ2jHraQjPRnISCYyk4WsZCM7OchJLnKThxpe85h8mUdpz23kjTP23HG5
kqF0oC7NzS/KN5lMD/LFuZmfkKviPuMeSTJLzQ71i9Sjhf6S3MaUuDfyxzma
n5SrGRb3wl1madipnkl9Wur/k2/FvtFLn4fvo6arOhOfq+fxsLoQB9QF4vzV
p+Sa2AF1MYbHnckc7In3l2VJUneSaRnFrjh7WZJJzNL3lQUYx4/6x2UFptBA
30pelk/Kt2NvZHEm8rS+t8zLWH7QD5fl6K2+V2bmi7gfWYr56v6yMAfVBWNH
1L/JVxgR+6TPyd44Qzqr0/GJ+iUaxu7rr8h3eIaH6GaWhS/VCygUO6b/Xa6N
7xbnQaPYffOr8l2epQ+FY3/MT8t1PBHvze0Uif3x3Bm5npHcTWOKUoziJFKC
kpSiNGUoSznKU4GKVIqd8ppn5YY4Y+6hCZVjXzx3Tr7KKLrQlDbm1+R7PBd3
SBUamP8hNzI6dolmtDW/Lt/nefpRNc7R/E+5iTFxXzSnnfkN+QFTYwepFudm
fl6+xtg47zgDs/R8qp5NC9rHjygfimlx39ynz8pX6oVUj3PV/yU3M44e+lx8
G38fZ6HOwG71nPjc6oL8pG5Jh/i95iN1skxkeuyCzMe+2CdZngHq7jIbo/la
P1SWZjKL9ANkEcbzc9y/rJji//8LNfQ3AZ/WpiA=
               "]]}, "Charting`Private`Tag#1"]}}], {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 3.141592653589793}, {0., 3.}}, 
           "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {{{{
                EdgeForm[], 
                Directive[
                 RGBColor[0, 0, 1], 
                 Opacity[0.2]], 
                GraphicsGroup[{{
                   Polygon[CompressedData["
1:eJxd2Xk4VF/8B/C50swVSopCCJU1KWuhz0kiFEVRSYuSooSvJUXabClZoqgs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                    "]]}}]}, {}, {}, {}}, {{}, {}, 
               Annotation[{
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  RGBColor[0, 0, 1]], 
                 Line[CompressedData["
1:eJw12Xk8VN//B/C50swVSopCCJU1KWuh90kiFEVRSYuSooQsKUubLSVLFJUl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                  "]]}, "Charting`Private`Tag#1"]}}, {}}, "GCFlag" -> True|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0., 3.141592653589793}, {0., 3.}}, 
          "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
          "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 1]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {{{{
               EdgeForm[], 
               Directive[
                RGBColor[0, 0, 1], 
                Opacity[0.2]], 
               GraphicsGroup[{{
                  Polygon[CompressedData["
1:eJxd2Xk4VF/8B/C50swVSopCCJU1KWuhz0kiFEVRSYuSooSvJUXabClZoqgs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                   "]]}}]}, {}, {}, {}}, {{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 RGBColor[0, 0, 1]], 
                Line[CompressedData["
1:eJw12Xk8VN//B/C50swVSopCCJU1KWuh90kiFEVRSYuSooQsKUubLSVLFJUl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                 "]]}, "Charting`Private`Tag#1"]}}, {}}, "GCFlag" -> True|>, 
        "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{
      GraphicsComplex[CompressedData["
1:eJw1mXk41N37x+cjzXyEkqIQQtmTsha6TxKhUIpKWpQUJTyWFGmzpWSJorIk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       "], {{{
          EdgeForm[], 
          Directive[
           RGBColor[0, 0, 1], 
           Opacity[0.2]], 
          GraphicsGroup[{
            Polygon[CompressedData["
1:eJwl1HV41WUYBuDRGzVidI5mow0UCWmQ0mFMQqVFYiqKSjNaUDBQwQSlBAtU
2la6lBYTC1RMQECR+7344z7P875n187Z9/uupfbNyhieMyEhIQczvDSS03Nc
7LGr4+VLOUo+J4fKimQz1HyLLMI4dpvvkTXooF8rc/KBfqeswhx9oCzNQf0S
Wup/yVVMpK85hb16bzL1/GzVnyK+b13zV/J5htGR6+xy8aH+CJfSyvy3fJPs
+L7kop791/IFhnMNl9Ha/qR8i0ncSm7q238jF5BFJy6njf0p+TaTuY08NLD/
Vi6Mv53ONCYvDb13VL7IXXThCvKRSBL5KUBBClGYZIpQlGIUJ4USNPI7v5Mv
cTdduZKSccbe+14uYgTdaEJb+9NyNVPoQ6k4N/sf5OJ4nvEcybDLzUf6o1xF
O/M/cg1T47lROs7R/ke5hHvjudDdLg8f64/RlPbmM3It0+hnLsG+6NysF2Cb
Po/Bejk+18vE+es/yaVxB/RKjIxnJouyJz5f1iRDv17mZQyfxNnLqkzmcfMg
WYYJHDLfL9OYSjNzB3lWjpbr4t7Iykxiurm/LMl49ptHylr013vIgmyP5yOr
MV+/Q5bniF427oh+TC7jvrhP5mJ8GmfIDXo+NulzaR5333xOrmcGA+hpV4gd
+tOUiztmPi5fjr8tzoMWcfft/5UbeJCBlI/7Y/+zXM4D8dlcTYW4P977Ra5g
FDfSkopUojKpVKEq1ahODWpSi9qkkU6duFN+56/ylThjbqIVdeO+eO+EfJUx
ZNKaTvb/yY3MjGdIPZrZ/yZfY2zcJdrQ2f68fIdZ3E79OEf73+XrjIvnRVu6
2P8v3+WhuIM0iHOz/0O+wfg47zgDu0Q260/Qjq7xT5T3xMPxvOllLsxO/Rka
xrma/5QrmUAfc3E+i5+Ps9CT2KI/Gd9bL8thvT3d4v817+tZMpXZcRdkKQ7E
fZK1GaL3lsmMZZd5hKzOFJ41D5EVmMgX8fxlOtO4AAc6pzc=
             "]]}]}, {}, {}, {}}, {{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1]], 
           Line[CompressedData["
1:eJwl1Xe4DnQUB/Br7723a++VUWa27G4USWWErJuEkr2aRpG9ZWREqLSHUdo0
KAqZZZRUZH/O0x+f93vOee/zjt/vPO9N7JmcNDhFQkLCUx4iK3n4RY6Ui+VA
WZQJDNTfL7Mzhm/0j8kytFJ3lCn5WP2ILMEMdR+Zn/3qW2isviC3MJ6e+tx8
p+5OF3VGPlPPJSWV9YfkEgZxB3eapWK7+gVq0kT/t9zKhPi8pKKK+WG5lMG0
phZNzf+RrzORB0hNVfMjchnJtKE2zcz/lW8wiQdJQzXzX+Xy+O60pQ5pqe65
o3IFQ2jHraQjPRnISCYyk4WsZCM7OchJLnKThxpe85h8mUdpz23kjTP23HG5
kqF0oC7NzS/KN5lMD/LFuZmfkKviPuMeSTJLzQ71i9Sjhf6S3MaUuDfyxzma
n5SrGRb3wl1madipnkl9Wur/k2/FvtFLn4fvo6arOhOfq+fxsLoQB9QF4vzV
p+Sa2AF1MYbHnckc7In3l2VJUneSaRnFrjh7WZJJzNL3lQUYx4/6x2UFptBA
30pelk/Kt2NvZHEm8rS+t8zLWH7QD5fl6K2+V2bmi7gfWYr56v6yMAfVBWNH
1L/JVxgR+6TPyd44Qzqr0/GJ+iUaxu7rr8h3eIaH6GaWhS/VCygUO6b/Xa6N
7xbnQaPYffOr8l2epQ+FY3/MT8t1PBHvze0Uif3x3Bm5npHcTWOKUoziJFKC
kpSiNGUoSznKU4GKVIqd8ppn5YY4Y+6hCZVjXzx3Tr7KKLrQlDbm1+R7PBd3
SBUamP8hNzI6dolmtDW/Lt/nefpRNc7R/E+5iTFxXzSnnfkN+QFTYwepFudm
fl6+xtg47zgDs/R8qp5NC9rHjygfimlx39ynz8pX6oVUj3PV/yU3M44e+lx8
G38fZ6HOwG71nPjc6oL8pG5Jh/i95iN1skxkeuyCzMe+2CdZngHq7jIbo/la
P1SWZjKL9ANkEcbzc9y/rJji//8LNfQ3AZ/WpiA=
            "]]}, "Charting`Private`Tag#1"]}}], {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{0., 3.141592653589793}, {0., 3.}}, 
        "Frame" -> {{True, True}, {True, True}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {{{{
             EdgeForm[], 
             Directive[
              RGBColor[0, 0, 1], 
              Opacity[0.2]], 
             GraphicsGroup[{{
                Polygon[CompressedData["
1:eJxd2Xk4VF/8B/C50swVSopCCJU1KWuhz0kiFEVRSYuSooSvJUXabClZoqgs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                 "]]}}]}, {}, {}, {}}, {{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1]], 
              Line[CompressedData["
1:eJw12Xk8VN//B/C50swVSopCCJU1KWuh90kiFEVRSYuSooQsKUubLSVLFJUl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               "]]}, "Charting`Private`Tag#1"]}}, {}}, "GCFlag" -> True|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[2], 
          LineBox[{{1.4707963267948965`, 0.9654194650101002}, {
           1.5707963267948966`, 0.9527178581671709}, {1.6707963267948966`, 
           0.9654194650101002}}]},
         Annotation[#, "Charting`Private`Tag#1"]& ]},
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               Rational[7, 360]], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]], 
             
             Line[{{1.4707963267948965`, 0.9654194650101002}, {
              1.5707963267948966`, 0.9527178581671709}, {1.6707963267948966`, 
              0.9654194650101002}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{1.4666296601282334`, 1.6707963267948966`}, {
             0.9520122133425661, 0.9654194650101002}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {1.4666296601282334`, 0.9520122133425661}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[
                Rational[7, 360]], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 1]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLinePlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{1.4666296601282334`, 1.6707963267948966`}, {
            0.9520122133425661, 0.9654194650101002}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {1.4666296601282334`, 0.9520122133425661}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[
               Rational[7, 360]], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLinePlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{{}, {}, 
        Annotation[{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[
            Rational[7, 360]], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 1]], 
          
          Line[{{1.4707963267948965`, 0.9654194650101002}, {
           1.5707963267948966`, 0.9527178581671709}, {1.6707963267948966`, 
           0.9654194650101002}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{1.4666296601282334`, 1.6707963267948966`}, {
          0.9520122133425661, 0.9654194650101002}}, 
         "Frame" -> {{False, False}, {False, False}}, 
         "AxesOrigin" -> {1.4666296601282334`, 0.9520122133425661}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[
             Rational[7, 360]], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 1]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListLinePlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"\[Omega]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"k\\\",FontSlant->\\\"Italic\\\"]\\)\"", 
       HoldForm], TraditionalForm], 
     FormBox[
      TagBox["\"Excitation spectrum\"", HoldForm], TraditionalForm]}},
  FrameStyle->Directive[FontSize -> 16],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Large,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}, "AxesInFront" -> True},
  PlotRange->{{0., 3.141592653589793}, {0., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.685943142647715*^9, 3.685943163731738*^9}, {
  3.6859438365795527`*^9, 3.6859439159063597`*^9}, {3.9065451640918837`*^9, 
  3.9065451676007843`*^9}, {3.9375449266311913`*^9, 3.937544930933155*^9}},
 CellLabel->"Out[14]=",ExpressionUUID->"48e65977-2a2f-4398-a9ec-49decee5f62d"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{Full, Full},
WindowMargins->{{Automatic, 53}, {Automatic, 30}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"13.3 for Mac OS X ARM (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"869859da-9010-460d-94ee-18336402ea20"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 926, 20, 40, "Title",ExpressionUUID->"5af9acf0-1c3c-4c65-a71c-f7ab277b8a19"],
Cell[1508, 44, 826, 17, 38, "Subtitle",ExpressionUUID->"9f9f883e-63d2-416f-88c5-dac916295fcb"],
Cell[2337, 63, 220, 5, 30, "Input",ExpressionUUID->"5b7209ec-5987-49e1-8aeb-bd0965991d68"],
Cell[2560, 70, 166, 3, 35, "Text",ExpressionUUID->"2ca82f14-3cad-49f2-8178-df8dfc02d599"],
Cell[CellGroupData[{
Cell[2751, 77, 256, 4, 67, "Section",ExpressionUUID->"83302b6c-5299-4ae8-b51e-a09f9e4254dc"],
Cell[CellGroupData[{
Cell[3032, 85, 1030, 23, 54, "Input",ExpressionUUID->"a3feb665-3e90-4b49-8504-36559e53e7fe"],
Cell[4065, 110, 631, 14, 37, "Output",ExpressionUUID->"d6ec1704-549c-48f5-9527-d9f454a17b66"]
}, Open  ]],
Cell[4711, 127, 1335, 33, 62, "Input",ExpressionUUID->"382f65c7-4d7b-49c4-a5f9-7a85ab93aeec"],
Cell[6049, 162, 995, 24, 136, "Input",ExpressionUUID->"81983b49-c288-440d-bd04-a617505e80c5"],
Cell[CellGroupData[{
Cell[7069, 190, 3606, 101, 52, "Input",ExpressionUUID->"ace25234-b7e5-4341-a6e7-77e7867bd46a"],
Cell[10678, 293, 84194, 1490, 419, "Output",ExpressionUUID->"1e526e41-6f95-4ecb-81e5-8924656ed08d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94909, 1788, 3138, 80, 136, "Input",ExpressionUUID->"8e98b76a-bc11-440f-8c79-b450ec491a53"],
Cell[98050, 1870, 91762, 1611, 412, "Output",ExpressionUUID->"48e65977-2a2f-4398-a9ec-49decee5f62d"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

