#!/usr/bin/env python

# The code performs a blocking analysis on the input data
# Output: sigma(I) and tau as a function of the block transformation 
#         step.
# Author: Sai Lyu, EPFL, Nov 2019

## paramters
ntrans=10 # number of transformations applied

## paramters

import math
f1=open('DATA.dat','r')
ff1=f1.readlines()
f1.close()

f1=open('DATA.dat','r')
nline=0
for line in f1:
   nline+=1
f1.close()

g1=open('BLOCKING.dat','w')
g1.write('# step, Sigma_I(M), tau(M)\n')

A0list=[]
for i in range (nline):
  aa=ff1[i].split()[0]
  A0list.append(float(aa))

Alist=[]
Blist=[]
def blocking (Alist) :
  Blist=[]
  for i in range (int(math.floor(len(Alist)/2))) :
    b=0.5*(Alist[2*i]+Alist[2*i+1])
    Blist.append(b)
  return Blist
  

def var2 (Alist) :
  var2=0
  suma=sum(Alist)
  for i in range (len(Alist))  :
     var2 += (Alist[i]-suma/len(Alist))**2/len(Alist)
  return var2  

g1.write(str(0)+' '+str(math.sqrt(var2(A0list)/len(A0list))) \
          +' '+str(0.5)+'\n')
Alist=A0list
for iblock in range (ntrans) : 
  Blist=blocking(Alist)
  taum=var2(Blist)*2**(iblock+1-1)/var2(A0list)
  sigmaI=math.sqrt(2*taum*var2(A0list)/len(A0list))
  Alist=Blist
  g1.write( str(iblock+1)+' '+str(sigmaI)+' '+str(taum)+'\n')
  
g1.close() 
