!
! The code generates a sequence of exponentially correlated
! and Gaussian distributed random numbers
! (cf. the documentation)
!
! Author: Giacomo Miceli
! EPFL, November 2012  
!
program stochastic
 implicit none
 integer :: n               ! counter
 integer :: nstep           ! max number of steps
 
 real :: tau                ! correlation time
 real :: G, G0              ! uncorrelated Gaussian deviates
 real :: A                  ! exponentially correlated Gaussian deviates
 
 ! auxiliary variables
 real :: f, s
 integer :: idum
 real, external :: gasdev
 
 call read_input

 f = exp(-1.0/tau)
 G0 = gasdev(idum)
 A = G0
 do n = 1, nstep
   G = gasdev(idum)
   A = f*A + sqrt(1.0-f*f)*G
   write(*,*)A
 enddo

!###############################################################################

 contains
 
!-------------------------------------------------------------------------------
!   READ input file
!-------------------------------------------------------------------------------

 subroutine read_input

 namelist/stochastic/&
         nstep,tau

! default parameter 
 nstep=10000
 tau=10.0

 read(*,nml=stochastic,end=200,err=800)

 return   !  successful exit
200 continue
   write(0,*)'Read_Input: FATAL: premature end-of-file in standard input'
   stop
800 continue
   write(0,*)'Read_Input: FATAL: read error in standard input'
   stop

 end subroutine read_input
 
 end program
