!
! The code makes a histogram of the input data
!
! Author: Giacomo Miceli
! EPFL, November 2012  
!
program histo
 implicit none
 integer :: i, iostat
 integer :: cnt
 integer :: nbins, ibin
 real :: a,b
 real :: delta
 real :: x
 real, dimension (:), allocatable :: h
 character(256) :: string,inputfile
 
 if (iargc() /= 8) then
 write(*,*)'-in     name of the input file (one column only!)'
 write(*,*)'-min    minimum value of the data set'
 write(*,*)'-max    maximum value of the data set'
 write(*,*)'-nbins  number of bins used for the histogram'
 write(*,*)''
 write(*,*) 'PROGRAM STOPPED!!'
 stop
 endif

 do i = 1, IARGC()
    call getarg(i, string)
    if (INDEX(string,'-min').NE.0)then
      call getarg(i+1,string)
      read(string,*) a
    endif
    if (INDEX(string,'-max').NE.0)then
      call getarg(i+1,string)
      read(string,*) b
    endif
    if (INDEX(string,'-nbin').NE.0)then
      call getarg(i+1,string)
      read(string,*) nbins
    endif
    if (INDEX(string,'-in').NE.0)then
      call getarg(i+1,inputfile)
    endif
 enddo
 
 allocate (h(nbins)) 
 delta=real(b-a)/real(nbins)
 
 open(22,file=inputfile,status='old')

 h=0.0
 cnt=0
 do
   read(22,*,iostat=iostat)x
   if(iostat .lt. 0) exit
   if(x .lt. a)cycle
   cnt=cnt+1
   ibin=int( (x-a)/delta )+1
   h(ibin)=h(ibin)+1
 enddo
 
 do i=1,nbins
  write(*,*)delta*(i-1)+a,h(i)/cnt/delta
 enddo
 
end program
