#!/usr/bin/env python

import osc1d as solver
import numpy as np

# dt: step
# x[0], v[0]: boundary conditions
# j: number of cycles
n = 100; j=2
dt = 2*np.pi*j/n #step size
t = np.zeros(n)

for i in range(n):
    t[i] = i*dt
x = np.zeros(n); v = np.zeros(n)
x[0] = 0; v[0] = 1

X_ex, V_ex = solver.exact(t)
#simple Euler integrator
X, V = solver.euler(x,v,dt)

#uncomment to use predictor-corrector Euler 
#X, V = solver.euler_pred_corr(x,v,dt)

E = x**2 + v**2

print("#INFO:  number of steps: %f" %n)
#print("#INFO: number of cycles: %f" %j)
print("#INFO:        time step: %f" %dt)
print("#     time   x   v    x-analytical v-analytic energy")
for ti,x,v,x_ex,v_ex,Ei in zip(t,X,V,X_ex,V_ex,E):
    print ("  {:5.4f}  {:5.4f}  {:5.4f}  {:5.4f}  {:5.4f}  {:5.4f}"\
            .format(ti,x,v,x_ex,v_ex,Ei))
