import numpy as np
import matplotlib.pylab as plt

def exact(t):
    # exact solution based on the initial value
    x_ex = np.sin(t)
    v_ex = np.cos(t)
    return x_ex, v_ex

def euler(x,v,dt):
    for i in range(x.size-1):
        x[i+1] = x[i] + dt * v[i]
        v[i+1] = v[i] - dt * x[i]
    return x, v

def euler_pred_corr(x,v,dt):
    for i in range(x.size-1):
        xp = x[i] + dt * v[i]
        vp = v[i] - dt * x[i]
        x[i+1] = x[i] + dt * (v[i] + vp)/2
        v[i+1] = v[i] - dt * (x[i] + xp)/2 
    return x, v

def euler2nd(x,v,dt):
    #implement here 2nd order Euler integrator
    return x, v

def verlet(x,v,dt):
    #implement here Verlet integrator
    return x, v

def verletv(x,v,dt):
    #implement here velocity Verlet integrator
    return x, v

def fit(t,E):
    poly = np.polyfit(t,E,1)
    g_E = lambda x: poly[0]*x + poly[1]
    return g_E(t),poly[0] #return fitted E and slope 

def plotxv(x_ex, v_ex, x, v, t):
    font = {'fontname':'sans-serif'}
    fig = plt.figure()
    ax = fig.add_subplot(111)
    ax.plot(t, x_ex, 'r-', t, x, 'r.', t, v_ex, 'g-', t, v, 'g.')
    ax.set_xlabel('time', **font)  
    ax.autoscale(axis='x', tight=True)
    plt.show()
 
def plotE(E, t):
    fig = plt.figure()
    ax = fig.add_subplot(111)
    ax.plot(t, E, 'b.')
    ax.set_xlabel('time')
    ax.set_ylabel('energy')
    ax.autoscale(axis='x', tight=True)
    plt.show()
