#!/bin/bash

cat > plot_chisq.gnu << EOF
###
f(x) = igamma(5,x)

EOF

cat > plot_chisq2d.gnu << EOF
###
f2d(x) = igamma(60,x)

EOF

for iran in 0 1 2 3;
do
    echo "iran=$iran"

    echo -e "set title 'testing ran$iran'\nplot\\" >> plot_chisq.gnu
    echo -e "set title 'testing ran$iran'\nplot\\" >> plot_chisq2d.gnu

    for ntry in 110000 1100000 11000000 110000000; 
    do
        echo "ntry=$ntry"

	./test_ran.x << EOF
$iran
$ntry
11
1000
EOF

    echo " 'chisq-ran${iran}_1000x${ntry}-11' u (\$1/2):3 w lp title 'ntry=$ntry',\\" \
         >> plot_chisq.gnu
    echo " 'chisq2d-ran${iran}_1000x${ntry}-11' u (\$1/2):3 w lp title 'ntry=$ntry',\\" \
         >> plot_chisq2d.gnu
    done 

    echo -e "f(x)\n\npause -1\n" >> plot_chisq.gnu
    echo -e "f2d(x)\n\npause -1\n" >> plot_chisq2d.gnu
done

