import matplotlib.pyplot as plt
from scipy.stats import maxwell, norm
from MD import *

# Step 2.1 
#  Test N-H for several values of Q
#############################################################

N, L, pos, vel, xi, lns = read_pos_vel('sampleNVT94.4.dat')

Q = 10.
T = 0.7807
nsteps = 500
dt = 0.0046

v = np.linspace(-10,10,499)
for Q in [0.1,1,10]:

    # Run MD simulation in NVT ensemble
    output = run_NVT(pos, vel, L, nsteps, N, dt, T, Q)

    # Plot p(v) distribution
    plt.plot(v, np.mean(output['pv'], axis=0), label="Q=%s"%Q)

plt.plot(v,norm.pdf(v,0,np.sqrt(T)),label='M-B dist'
plt.legend()
plt.show()

'''
# Step 2.2
#  Study a change of temperature
#############################################################

Told = 0.7807
Tnew = 1.25
nsteps = 400
dt = 0.0046

N, L, pos, vel, xi, lns = read_pos_vel('sampleNVT94.4.dat')

for Q in [0.1,1,10]:

    # Run NVT in equilibrated system
    output = run_NVT(pos, vel, L, nsteps, N, dt, Told, Q, xi, lns)
    EnKin = output['EnKin']

    # Change T 
    output = run_NVT(output['pos'],output['vel'], L, nsteps, N, dt, Tnew, Q)
    EnKin = np.concatenate((EnKin, output['EnKin']))

    plt.plot(np.linspace(0,nsteps*2,nsteps*2)*dt, EnKin/3*2, label="Q=%s"%Q)

plt.legend()
plt.show()
'''
