/*
 * tiny26.c
 *
 * Created: 12.06.2017 10:14:25
 *  Author: Nicolas
 */ 
#define F_CPU 8000000UL

#include "tiny.h"

void setStatePinC(unsigned char pin,bool state){
	if(state)
	PORTC |= (1<<pin);
	else
	PORTC &= ~(1<<pin);
}




//Writing a logic one to PINxn toggles the value of PORTxn, independent on the value of DDRxn.
//Note that the SBI instruction can be used to toggle one single bit in a port.
void setStatePinBToggle(unsigned char pin){ 
	sbi(PINB,pin);
}

void delay_ms(int ms){ // delay routine to use after build constant
	for(;ms >0;ms--)
	_delay_ms(1);
}

bool buttonMiddlePushed(){ // push button for decreasing
	if((PIND & 0b00100000) != 0)//pin PD5
		return false;
	else
		return true;
}
bool buttonRightPushed(){ // push button for increasing
	if((PIND & 0b01000000) != 0) //pin PD6
		return false;
	else
		return true;
}
bool buttonLeftPushed(){ // push button for increasing
	if((PIND & 0b10000000) != 0) //pin PD7
		return false;
	else
		return true;
}