/*
 * main.h
 *
 * Created: 19.06.2017 09:45:37
 *  Author: Nicolas
 */ 


#ifndef MAIN_H_
#define MAIN_H_

#ifndef F_CPU
#define F_CPU 8000000UL
#endif

#include <avr/io.h>
#include <stdbool.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <avr/sleep.h>
#include "constantes.h"
#include "tiny.h"
#include "display.h"
#include "interruption.h"
#include "alarm.h"
#include "ds18b20.h"

extern unsigned char alarmSong;
extern unsigned char snoozeMinutes;

extern unsigned char pwm_OCR;
extern unsigned char display[4]; /*display global variable*/
extern unsigned long timeSecondActual;
extern unsigned long timeSecondAlarm;
extern unsigned char timeSecondSinceNoise;
extern long temperature;
extern unsigned char adcLow, adcHigh;
extern bool adc_luminosity_updated;
extern bool manualLuminosity,displayEnable;
extern bool alarmEnable;
extern bool alarmRunning;

//extern unsigned int timer0count;


//void checkTimeAdjust(bool);
void adjustLuminosity(bool);
void readADC();
void setAlarm();
void adjustTime();
void adjustAlarm();
void snoozeSetup();
void menu();
void goToSelectedMenu(unsigned char);
void setBrightnessMode();
void chooseSong();


void delay_ms(int);
void startADC();

int checkUserAction();

bool checkForUserAction();

bool checkWakerTime();


void setEepromValues(bool);
void readEepromValues();
void EEPROM_write(unsigned int , unsigned int );
unsigned char EEPROM_read(unsigned int );
void saveLongInEEprom(unsigned long , unsigned int );
unsigned long readLongFromEEprom(unsigned int );

#endif /* MAIN_H_ */