/*
 * interrupt.c
 *
 * Created: 12.06.2017 17:08:55
 *  Author: Nicolas
 */ 

#include "interruption.h"

#define buzzer_pin_toggle PORTD ^= (1<<PIND0);	// toggle the state of PIND0 alarm sound generator

// Constant pointers to constant data
const unsigned char * const numeralCodes = digitCodeMap;
static unsigned char digit = 0;


//initialize interrupts
void init_interrupt(){
	init_adc();
	init_ext_int();
	init_timer();
}

void init_ext_int(){

	sbi(MCUCR,ISC00);
	sbi(MCUCR,ISC01); // The rising edge of PIND2 --> INT0 generates an interrupt request.
	sbi(MCUCR,ISC11);
	sbi(MCUCR,ISC10); // The rising edge of PIND3 --> INT1 generates an interrupt request.
	
	sbi(GICR,INT0); // enable external interrupt 0
	sbi(GICR,INT1); // enable external interrupt 1
}

// regarder les vidos https://www.youtube.com/watch?v=FE4KfnEHPGU&list=PLtQdQmNK_0DRhBWYZ32BEILOykXLpJ8tP&index=9
// pwm avec 1 seul timer

void init_timer(){
	//init timer 1 for multiplexing display
/*CS22 CS21 CS20 Description
	0	0	0 No clock source (Timer/Counter stopped)
	0	0	1 clkT2S/(No prescaling)
	0	1	0 clkT2S/8 (From prescaler)
	0	1	1 clkT2S/32 (From prescaler)
	1	0	0 clkT2S/64 (From prescaler)
	1	0	1 clkT2S/128 (From prescaler)
	1	1	0 clkT2S/256 (From prescaler)
	1	1	1 clkT2S/1024 (From prescaler)*/

	
	TCCR2 	= 0b00000100;// 8MHz/64-->125kHz (CS22 to 1)
	
	TCNT2 	= 0; 		// load timer value for 125kHz/256 ->488Hz --> 2.048ms
 	TIMSK |= (1<<TOIE2); // enable timer 2 overflow interrupt
 	TIMSK |= (1<<OCIE2);// output compare interrupt for PWM

// init timer 1 16bit for music 
/*
CS12 CS11 CS10 Description
0	0	0 No clock source. (Timer/Counter stopped)
0	0	1 clkI/O/1 (No prescaling)
0	1	0 clkI/O/8 (From prescaler)
0	1	1 clkI/O/64 (From prescaler)
1	0	0 clkI/O/256 (From prescaler)
1	0	1 clkI/O/1024 (From prescaler)
*/
	TCCR1A &= 0x00; // disconnect OC1A & B and run normal mode
	
	cbi(TCCR1B,ICNC1); 
	cbi(TCCR1B,ICES1);
	 
 	cbi(TCCR1B,CS12); // 8MHz/8-->1MHz
 	sbi(TCCR1B,CS11);
 	cbi(TCCR1B,CS10);
// 	
  	 
	TCNT1H = 0;
	TCNT1L = 0; 		// load timer value for 1MHz/65536
	
	//timer 0 for timing second if not 50Hz
// 	sbi(TCCR0,CS02); //presacaler at 8e6/256 = 31250Hz
// 	cbi(TCCR0,CS01);
// 	cbi(TCCR0,CS00);
// 	TCNT0 = 0; // set for 125 clk at 31250-->125Hz
// 	TIMSK |= (1 << TOIE0);
	
}
void init_adc(){
		//ADC initialize
	
		cbi(ADMUX,MUX3); // Choose AD input ADC1 PC1 luminosity
		cbi(ADMUX,MUX2);	
		cbi(ADMUX,MUX1);
		sbi(ADMUX,MUX0);
				
		sbi(ADMUX,ADLAR);//AD result store in (more significant bit in ADCH)
	
		sbi(ADMUX,REFS0); // VCC voltage reference
		cbi(ADMUX,REFS1);
		
		sbi(ADCSRA,ADPS0);
		sbi(ADCSRA,ADPS1);
		sbi(ADCSRA,ADPS2);// prescaler = 128	-->62.5kHz
		cbi(ADCSRA,ADFR); // disable free running mode
		sbi(ADCSRA,ADIE); // Interrupt enable
		sbi(ADCSRA,ADIF); // Interrupt Flag
		sbi(ADCSRA,ADEN); // enable ADC
		
		//sbi(ADCSRA,ADSC);  // Start ADC Conversion
		
		//ADCSRA = ADCSRA | 0xC0;       // Start ADC Conversion (ADEN & ADSC to 1)
		
}
/*
ISR (TIMER0_OVF_vect)  // timer0 overflow interrupt for timing seconds without 50Hz
{
	TCNT0 =2;
	timer0count++;
	if(timer0count == 125){
		timeSecondActual++; //increment the time from 1 (every second)
		timeSecondSinceNoise++;
		timer0count = 0;
	}
	
}*/

//interrupt to play music
ISR(TIMER1_COMPA_vect){
//	cli();
	buzzer_pin_toggle;
 	TCNT1H = 0;
 	TCNT1L 	= 0; 		// load timer value for 1MHz/65536
	//sei();
}




// PWM display to adjust intensity
ISR(TIMER2_COMP_vect){
	PORTB &= 0x00; // turn off all segments
	PORTC &= 0b111000011;
	if(!alarmRunning)
		cbi(PORTD,PIND4);//alarmLed(off);
		
}



//timer 1 interrupt routine Write values to 7 segments display

ISR(TIMER2_OVF_vect){
	
	unsigned char pinDigit = 0, value = 0;
	if(alarmEnable & !alarmRunning & displayEnable)
		sbi(PORTD,PIND4);//alarmLed(on);
	switch(digit){
		case(0): pinDigit = PC5; // Digit 1 (Thousands)
		break;
		case(1): pinDigit = PC4; // Digit 2 (Hundreds)
		break;
		case(2): pinDigit = PC3; // Digit 3 (Decades)
		break;
		case(3): pinDigit = PC2; // Digit 4 (Units)
		break;
		default:;
	}	
	
	PORTC &= 0b11000011 ;// Turn off all segments (PC5-2 to 0)
	value = display[digit];
	PORTB = numeralCodes[value];
	setStatePinC(pinDigit,on); // select the digit to light on

	if(digit < 3){ // increment to next digit
		digit++;
	}else{
		digit = 0;
	}
	
	TCNT2 =0; // load timer 1 value
	OCR2 = 255-pwm_OCR; // set the value of timer 2 output compare for PWM
}

//interrupt ADC conversion finish
ISR(ADC_vect){
	
	// always read ADCL first!!
	adcLow = ADCL; // store ADC value
	adcHigh = ADCH;
	        
	adc_luminosity_updated = true; 
}

 // external interrupt routine call every time PD2 is high
 // Used for counting seconds for the clock
ISR(INT0_vect){
	cli();
	timeSecondActual++; //increment the time from 1 (every second)
	timeSecondSinceNoise++;
	sei(); 	
}

// external interrupt routine call every time PD3 is high
// Used to wakeup the display when is off
ISR(INT1_vect){
	cli();
	timeSecondSinceNoise = 0;
	displayEnable = true;
	// do something when a clap is listen
	sei();
}

// 
// void goToSleep(){
// 	cli();
// 	turnOffAllSeg();	
// 	// 	sbi(MCUCR,SM1);
// 	// 	cbi(MCUCR,SM0);
// 	set_sleep_mode(SLEEP_MODE_PWR_DOWN);    // replaces above statement
// 	sleep_enable();                         // Sets the Sleep Enable bit in the MCUCR Register (SE BIT)
// 	//sleep_bod_disable();
// 	cbi(TIMSK,TOIE1); // disable timer 1 interrupt
// 	sei();
// 	sleep_cpu();                            // sleep
// 	
// }