/*
 * display.h
 *
 * Created: 12.06.2017 16:18:26
 *  Author: Nicolas
 */ 


#ifndef DISPLAY_H_
#define DISPLAY_H_

#include "main.h"

void writeToDigit(unsigned char,unsigned char);

void turnOffAllSeg();
void doublePoint(bool state);
void alarmLed(bool state);
void sendNumberToDigit(long , bool);
void displayTime();
void displayTemperature();
void displayNothing();
void blinkDisplay(int,unsigned char);
void writeToDisplay(int);
void displayAlarm();
int computeTime(unsigned long);
void displaySelectedSong();

void displayMenu(unsigned char);
void displayText(char[]);
void displaySentence(char text[],int speed);



#define BLANK_IDX 36 // Must match with 'digitCodeMap'
#define DASH 37
#define DEGREE 40
#define CELSIUS 12


static const unsigned char digitCodeMap[] = {
	//     GFEDCBA  Segments      7-segment map:
	0B00111111, // 0   "0"   0      AAA
	0B00000110, // 1   "1"   1     F   B
	0B01011011, // 2   "2"   2     F   B
	0B01001111, // 3   "3"   3      GGG
	0B01100110, // 4   "4"   4     E   C
	0B01101101, // 5   "5"   5     E   C
	0B01111101, // 6   "6"   6      DDD
	0B00000111, // 7   "7"	 7
	0B01111111, // 8   "8"   8
	0B01101111, // 9   "9"	 9
	0B01110111, // 65  'A'	10
	0B01111100, // 66  'b'	11
	0B00111001, // 67  'C'	12
	0B01011110, // 68  'd'	13
	0B01111001, // 69  'E'	14
	0B01110001, // 70  'F'	15
	0B00111101, // 71  'G'	16
	0B01110110, // 72  'H'	17
	0B00000110, // 73  'I'	18
	0B00001110, // 74  'J'	19
	0B01110110, // 75  'K'  20 Same as 'H'
	0B00111000, // 76  'L'	21
	0B00000000, // 77  'M'	22	NO DISPLAY
	0B01010100, // 78  'n'	23
	0B00111111, // 79  'O'	24
	0B01110011, // 80  'P'	25
	0B01100111, // 81  'q'	26	
	0B01010000, // 82  'r'	27
	0B01101101, // 83  'S'	28
	0B01111000, // 84  't'	29
	0B00111110, // 85  'U'	30
	0B00111110, // 86  'V'  31 Same as 'U'
	0B00000000, // 87  'W'	32	NO DISPLAY
	0B01110110, // 88  'X'	33 Same as 'H'
	0B01101110, // 89  'y'	34
	0B01011011, // 90  'Z'  35 Same as '2'
	0B00000000, // 32  ' '	36	BLANK
	0B01000000, // 45  '-'  37 DASH
	0B10000000, // 46  '.'  38 PERIOD
	0B00001000, // 47  '_'  39 underscore
	0B01100011 //	   ''  40 for degrees 
};



#endif /* DISPLAY_H_ */