/*
 * tiny26.c
 *
 * Created: 12.06.2017 10:14:25
 *  Author: Nicolas
 */ 
//#include <avr/io.h>
#include "display.h"
#include <string.h>
#include "stdlib.h"

void turnOffAllSeg(){
	PORTB = 0 ;
}

/**
    The sendNumberToDigit() function set the value in the display[] shared variable
	to display on the 7 segments  
*/	
void sendNumberToDigit(long value, bool removezero){
	unsigned char temp[4];
	unsigned char i = 0;
	if(removezero){
		temp[3] =  value % 10; //units
		value /=10;
		temp[2] = value%10; // decades
		value /=10;
		temp[1] = value%10; //hundreds
		value /=10;
		temp[0] =  value%10; // Thousands
		
		while((temp[i]==0) & (i<3)){ // remove 0 before the number
			temp[i]= BLANK_IDX;
			i++;
		}
	}else{
		temp[3] =  value % 10; //units
		value /=10;
		temp[2] = value%10; // decades
		value /=10;
		temp[1] = value%10;//hundreds
		value /=10;
		temp[0] =  value%10;// Thousands
	}
	i=0;
	while((i<4)){
		display[i]=temp[i];
		i++;
	}
	
}


void blinkDisplay(int speed,unsigned char displayType){ // adjust speed blinking in ms
	//int u;
	if(displayType == dispNoChange){
		unsigned char temp[4];
		unsigned char i =0;
		while((i<4)){
			temp[i] = display[i];
			i++;
		}
		
		displayNothing();
		delay_ms(speed);
		i=0;
		while((i<4)){
			display[i] = temp[i]; // put back the value displayed
			i++;
		}
		delay_ms(speed);
	}else{
		writeToDisplay(dispNothing);
		delay_ms(speed);
		writeToDisplay(displayType); // display stuff -->displayType
		delay_ms(speed);
	}
}

void writeToDisplay(int displayType){
	switch (displayType){
		case dispNothing: displayNothing();
		break;
		case dispAlarmTime: displayAlarm();
		break;
		case dispTime: displayTime();
		break;
		case dispTemperature: displayTemperature();
		break;
		default:;
	}
}

void displayMenu(unsigned char choice){
	
	switch (choice){
		case SETHOUR: displayText("CL-t");
		break;
		case SETALARMTIME: displayText("AL-t");
		break;
		case ALARMENABLE: displayText("Al-E");
		break;
		case SNOOZE: displayText("Al-S");
		break;
		case SONG : displayText("Al-B");
		break;
		case BRIGHTNESS: displayText("D-BR");
		break;
		case SLEEPDISPLAY: displayText("D-Sl");
		break;
		
		case DONE: displayText("DONE");
		break;
		default:displayText("");
	}
}

void doublePoint(bool state){ // enable or disable the double point
	if(!state)
	sbi(PORTD,PIND1);
	else
	cbi(PORTD,PIND1);
}

void alarmLed(bool state){ // enable or disable the indicator led for alarm
	if(state)
	sbi(PORTD,PIND4);
	else
	cbi(PORTD,PIND4);
}


// Displays the string on the display, as best as possible.
// Only alphanumeric characters plus '-' '_' and ' ' are supported
//source: https://github.com/DeanIsMe/SevSeg/blob/master/SevSeg.cpp
void displayText(char text[]){
	unsigned char strIdx = 0; // Current position within str[]
	doublePoint(off);
	
	for (char digitNum = 0; digitNum < 4; digitNum++) {
		char ch = text[strIdx];
		if (ch == '\0'){
			display[strIdx] = BLANK_IDX;
			break; // NULL string terminator
		}else if (ch >= '0' && ch <= '9') { // Numerical
			display[strIdx] = ch - '0';
		}
		else if (ch >= 'A' && ch <= 'Z') {
			display[strIdx] = ch - 'A'+10;
		}
		else if (ch >= 'a' && ch <= 'z') {
			display[strIdx] = ch - 'a'+10;
		}
		else if (ch == ' ') {
			display[strIdx] = BLANK_IDX;
		}
		else if(ch == '_'){
			display[strIdx] = 39;
		}else {
			// Every unknown character is shown as a dash
			display[strIdx] = 37;
		}

		strIdx++;
	}
	
	
}

void displayNothing(){
	doublePoint(off);
	display[0] = BLANK_IDX; // turn off display
	display[1] = BLANK_IDX; // turn off display
	display[2] = BLANK_IDX; // turn off display
	display[3] = BLANK_IDX; // turn off display
	
}
// void displaySeconds(){
// 	doublePoint(on); // turn on the double point for clock display
// 	
// 	sendNumberToDigit(timeSecondActual,false);
// }
void displayTime(){
	doublePoint(on); // turn on the double point for clock display
	if(timeSecondActual >=86399) // check if it's midnight and set time to 0
	timeSecondActual = 0;
	sendNumberToDigit(computeTime(timeSecondActual),false);
}
void displayAlarm(){
	doublePoint(on); // turn on the double point for clock display
	if(timeSecondAlarm >=86399) // check if it's midnight and set time to 0
		timeSecondAlarm = 0;
	sendNumberToDigit(computeTime(timeSecondAlarm),false);
}

void displayTemperature(){
	doublePoint(off); // turn off the double point for clock display
	if(temperature<0){
		sendNumberToDigit(abs(temperature*100),true); // shift value of 2 digit to display "C"
		unsigned char i= 0;
		while((i<4)){ // display the negative temperature
			if(display[i]==BLANK_IDX)
				i++;
			else{
				display[i-1]=DASH;
				i=5;
				break;
			}
		}
	}else{
		sendNumberToDigit(temperature*100,true); // shift value of 2 digit to display "C"
	}
	display[2] = DEGREE; // display "  " for degrees Celsius
	display[3] = CELSIUS; // display " C " for degrees Celsius
		
}

int computeTime(unsigned long timeseconds){
	unsigned long timeOn4digits = timeseconds;
	unsigned long hours = 0, minutes = 0;
	//unsigned long seconds = 0;
	
	hours = floor(timeseconds /3600);	// Extrait le nombre d'heures garde la partie entire de la division
	timeseconds -= hours*3600;			// Soustrait les heures
	minutes = floor(timeseconds / 60);  // Extrait le nombre de minutes garde la partie entire de la division
	
	timeOn4digits = (hours*100) + minutes;// Assemble le chiffre pour l'affichage heure minute
	return timeOn4digits;
}

// display a sentence @speed in ms

void displaySentence(char text[],int speed){
	char aff[4];
	int size = strlen(text);
	
	for(int i=0;i <=size-4;i++){
		aff[0] = text[i];
		aff[1] = text[i+1];
		aff[2] = text[i+2];
		aff[3] = text[i+3];
		displayText(aff);
		if(i==0)
			delay_ms(500);
		delay_ms(speed);
	}
}

void displaySelectedSong(){
	switch(alarmSong){
		case 1: displayText(textAlarm1);
		break;
		case 2: displayText(textAlarm2);
		break;
		case 3: displayText(textAlarm3);
		break;
		case 4: displayText(textAlarm4);
		break;
	}
}