/*
 * waker.c
 *
 * Created: 05.03.2018 09:17:45
 *  Author: Nicolas
 */ 

#include "alarm.h"
#include "songs/bip.h"
#include "songs/sympony5.h"
#include "songs/starwars.h"
#include "songs/bellaciao.h"
#include "songs/tetris.h"
#include "songs/gonnafly.h"
#include "songs/godfather.h"
#include "songs/pianoscore.h"
#include "songs/feliznavidad.h"
#include "songs/rasputin.h"
#include "songs/letempsestbon.h"
#include "songs/hesapirate.h"
#include "songs/walkyrie.h"
#include "songs/valais.h"
#include "songs/NCIS.h"

void alarmRoutine(bool realAlarm){ // alarm routine
	if(realAlarm){
		displaySentence(MESSAGE_WAKEUP,200);
		displayTime();
	}
	switch(alarmSong){
		case 1: alarmRun(notes_Bip,beats_Bip,length_Bip,realAlarm);
		break;
		case 2: alarmRun(notes_starwars,beats_starwars,length_starwars,realAlarm);
		break;
		case 3: alarmRun(notes_valais,beats_valais,length_valais,realAlarm);
		break;
		case 4: alarmRun(notes_tetris,beats_tetris,length_tetris,realAlarm);
		break;
	}

	cbi(TIMSK,OCIE1A);	//disable timer 1 interrupt compare A
	sbi(PORTD,PIND0); // set output to one to switch off speaker (MOSFET P)
	
}

void alarmRun(const unsigned int notes[],const unsigned int beats[],const unsigned char length,bool realAlarm){
	unsigned char i = 0;
	bool done = false;
	alarmRunning = true;
	while(!done){
		for (i = 0; i < length; i++) {
			adjustLuminosity(true);
			if(notes[i] == X0){ // if a pause is played
				cbi(TIMSK,OCIE1A);	//disable timer 1 interrupt compare A
				sbi(PORTD,PIND0); // set output to one to switch off speaker
				delay_ms(beats[i]);
			}else
				playTone(notes[i],beats[i],realAlarm);
			if(realAlarm){ // check if it is a real alarm or a request from setup menu
				if(checkHumanIsAlive()){
					done = true;
					break;
				}
			}else{
				if(buttonMiddlePushed() | buttonRightPushed() | buttonLeftPushed()){
					done = true;
					break;
				}
			}
		}
	}
	alarmRunning = false;	
}


void playTone(int tone, int duration, bool realAlarm) {
	for (int i = 0; i < duration ; i += tone * 2) {
		OCR1AH = tone >>8;;
		OCR1AL = tone & 0x00FF;
		TCNT1H = 0;
		TCNT1L = 0;
		sbi(TIMSK,OCIE1A);	//enable timer 1 interrupt compare A
		if(realAlarm) // check if it is a real alarm or a request from setup menu
			blinkDisplay(duration/2,dispTime);
		else
			blinkDisplay(duration/2,dispNoChange);
		//delay_ms(duration);
		cbi(TIMSK,OCIE1A);	//disable timer 1 interrupt compare A
		delay_ms(10);
	
	}
}

bool checkHumanIsAlive(){
	unsigned long timeSecondAtSnooze;
	bool alarmSnooze = false;
	bool stop = false;
	unsigned char t = 0;
	alarmLed(on);
	
	if(buttonMiddlePushed() | buttonRightPushed() | buttonLeftPushed()){ // snooze if one of the 3 buttons is pushed
		alarmSnooze = true;
		timeSecondAtSnooze = timeSecondActual ;
		//displaySentence("sleep a bit",150);
		while(alarmSnooze){
			if(buttonMiddlePushed() & buttonRightPushed() & buttonLeftPushed()){ // if 3 buttons are pushed turn off alarm
				stop = true;
				alarmSnooze = false; // go back to alarm and turn it off
				displaySentence(MESSAGE_GOODAY,200);
			}
			adjustLuminosity(true);
			alarmLed(off);
			_delay_ms(250);
			alarmLed(on);
			_delay_ms(250);
			
			if(timeSecondActual >=86399){ // check if it's midnight and set time to 0
				timeSecondActual = 0;
				timeSecondAtSnooze = 0;
			}
			if(t<20){
				t++;
				doublePoint(on); // turn on the double point for clock display
				sendNumberToDigit(computeTime(timeSecondActual),false);
			}else{
				doublePoint(off); // turn off the double point for clock display
				displaySentence(MESSAGE_TURNOFF,150);
				t=0;
			}
			if(((timeSecondActual-timeSecondAtSnooze) > (snoozeMinutes*60)) & !stop){ // check if snooze time reach
				alarmSnooze = false; // go back to alarm
				displaySentence(MESSAGE_REPEAT,200);
			}
		}
	}
	return stop;
}


