function slabTE(n1,n2,n3,wavel)
%
% modes of a slab waveguide
%
global n12 n22 n32 kd2;

%n1=1.8;
%n2=1.5;
%n3=1.5;
d=1;
%wavel=1.0;

k=2*pi/wavel;
k2=k*k;
kd=k*d;
kd2=kd*kd;
n12=n1*n1;
n22=n2*n2;
n32=n3*n3;
n12k2=n12*k2;
n22k2=n22*k2;
n32k2=n32*k2;

kapamx=sqrt(n12-n22)*k;
del=kapamx/300;
x=0:del:kapamx;
y1=tan(x);
y2=slabfTE(x);
h=plot(x,y1);
set(h,'linewidth',2,'color',[1 0 0]);
hold on;
h=plot(x,y2);
set(h,'linewidth',2,'color',[0 0 1]);
axis([0 kapamx -20. 20.]);
hold off;

[nroots,roots]=bissecTE(0,kapamx*d-eps,del,eps);

figure;
hold on;
xx=-3:.05:2;
[dum,nxx]=size(xx);
for iroot=1:nroots
    kapa=roots(iroot)/d;
    kapa2=kapa*kapa;
    beta2=n12k2-kapa2;
    beta=sqrt(beta2);
    gama=sqrt(n12k2-n22k2-kapa2);
    delta=sqrt(n12k2-n32k2-kapa2);
    nmode=iroot-1
    neff=beta/k
    a=1;
    b=-delta*a/kapa;
    fact=(a*cos(kapa*d)-b*sin(kapa*d));
    for i=1:nxx
        if (xx(i)>0)
            yy(i)=a*exp(-delta*xx(i));
        elseif (xx(i)<-d)
            yy(i)=fact*exp(gama*(xx(i)+d));
        else
            yy(i)=a*cos(kapa*xx(i))+b*sin(kapa*xx(i));
        end
    end
    h=plot(xx,yy);
    set(h,'linewidth',2,'color',[0 0 1]);
    ampmx(iroot)=max(yy);
    ampmn(iroot)=min(yy);
end
yyy(1)=max(ampmx);
yyy(2)=min(ampmn);
xxx(1)=-d;
xxx(2)=-d;
h=plot(xxx,yyy);
set(h,'linewidth',2,'color',[0 0 0]);
xxx(1)=0;
xxx(2)=0;
h=plot(xxx,yyy);
set(h,'linewidth',2,'color',[0 0 0]);
hold off;
