clear
clf

%% Generate the system
P = tf(21.5297, [1.0000    2.6667   71.1173   69.4506         0])

step(P)

%%

Td = 0.01;
K = 1 + Td*tf([1 0],1);

rlocus(K*P)
grid on

%%

clf
rlocus(K*P, logspace(-3,log10(100),1000))
axis([-1.5 1 -10 10])
grid on

%%

clf
step(feedback(2.7*K*P,1),feedback(6*K*P,1),feedback(9.5*K*P,1))
grid on
