"""Driver script for solving the 1D Maxwell equations using a monotone scheme"""

import numpy as np
import matplotlib.pyplot as plt
from MaxwellMonotone import *
from MaxwellIC import CavityExact


# Set problem parameters
L = 2.0
CFL = 0.9
FinalTime = np.pi/2
N = 1024
h = L/N

epl = 1.0
mul = 1.0
epr = 2.25
mur = 1.0

# Define domain and initial conditions
x = np.linspace(-1.0,1.0,N+1)
EM,ep,mu = CavityExact(x,epl,epr,mul,mur,0.0)


# Solve Problem
EM = MaxwellM1D(x,EM,ep,mu,h,CFL,FinalTime)

# Plot
plt.plot(x,EM[0,:])
plt.title("Solution E at time {}".format(FinalTime))
plt.show()