"""
This file contains the specific functions to solve the linear wave equation
in 1D using a monotone scheme.
"""

import numpy as np
from Linwave import *
from helpers import extend

###################################################################################
def LinwaveMrhs1D(x, u, h, k, maxvel):

    """Purpose: Evaluate right hand side for Linwave equation using monotone method"""
    N = len(x)

    # Periodic boundary conditions
    xe, ue = extend(x, u, 1, "P", 0, "P", 0)

    # Compute rhs - Change numerical flux here
    du = - (LinwaveLF(ue[1:N+1], ue[2:N+2], maxvel) - \
            LinwaveLF(ue[:N], ue[1:N+1], maxvel))/h
    return du

def LinwaveM1D(x, u, h, CFL, FinalTime):
    """Purpose: Integrate 1D Linwave equation until FinalTime using a monotone scheme.
    """   
    t = 0.0
    timestep = 0

    # Set the timestep
    maxvel = 1.0
    k = CFL*h/maxvel

    while t < FinalTime:
        k = min(FinalTime-t, k)
        # Update solution
        u += k*LinwaveMrhs1D(x,u,h,k,maxvel)
        t +=k
        timestep += 1
        
    return u
