"""Driver script for solving the 1D linear wave equation using a flux-limit scheme"""

import numpy as np
import matplotlib.pyplot as plt
from LinwaveFluxLimit import *
from WaveIC import *

# Set problem parameters
L = 2.0
CFL = 0.9
FinalTime = 4.0
N = 512
h = L/N

# Define domain and initial conditions
x = np.linspace(-1.0, 1.0, N+1)
u = wavetest(x,0.5,-0.7,0.005,10,np.log(2.0)/(36*0.005**2))
# u = (np.sign(x+0.5) - np.sign(x-0.5) )/2.0 

#Time integration
u = LinwaveFL1D(x,u,h,CFL,FinalTime)

# Plot
plt.plot(x,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()