"""Driver script for solving the 1D linear wave equations using an DG scheme"""

import numpy as np
import matplotlib.pyplot as plt
from LinwaveDG import *
from Legendre import LegendreGL
from WaveIC import wavetest

# Order of the method (m), number of elements (N)
m = 1
N = 128

# Set problem parameters
xmin = -1.0
xmax = 1.0
CFL = 0.2
FinalTime = 4.0

# Generate mesh
VX = xmin + (xmax-xmin)/N*np.arange(N+1)
r,w = LegendreGL(m)
x = np.outer( np.ones(m+1), VX[:N] ) + 0.5*np.outer(r+1.0, VX[1:N+1] - VX[:N] )
h = (xmax-xmin)/N

# Define initial conditions
uh = wavetest(np.reshape(x,((m+1)*(N))),0.5,-0.7,0.005,10,np.log(2.0)/(36*0.005**2))
u = np.reshape(uh,(m+1,N))

# Solve Problem
u = LinwaveDG1D(x,u,h,m,N,CFL,FinalTime)


# Plot
plt.plot(x[0,:],u[0,:])
plt.title("Solution u at time {}".format(FinalTime))
plt.show()

