import numpy as np
from scipy.optimize import fsolve

def Chebeps(p):
	"""Purpose: Compute shift of Chebychev based approximation to absolut value
				to ensure stability"""

	xs = fsolve( lambda x: Chebtaup(x,p)-1.0,0.0)
	Ceps = np.abs(xs) - np.abs(Chebtau2p(xs,p))
	return Ceps

def Chebtaup(x,p):
	"""Purpose: Evaluate derivative of abs approximation to find shift"""

	taup = 0.0
	for k in range(p):
		taup += 4.0/np.pi*(-1.0)**(k+2)/(2*(k+1)-1)/(2*(k+1)+1)*\
					2*(k+1)*np.sin(2*(k+1)*np.arccos(x))/np.sqrt(1.0-x**2)

	return taup

def Chebtau2p(x,p):
	"""Purpose: Evaluate Chebyshev abs approximation
		Note: x can be a matrix"""

	tau2p = 2.0/np.pi+ 0.0*x
	for k in range(p):
		tau2p += 4.0/np.pi*(-1.0)**(k+2)/(2*(k+1)-1)/(2*(k+1)+1)*\
					np.cos(2.0*(k+1)*np.arccos(x))

	return tau2p

