"""Driver script for solving the 1D Burgers equation using a Fourier spectral
	collocation method."""

import numpy as np
import matplotlib.pyplot as plt
from BurgersSpec import *

# Set problem parameters
xmin = 0.0
xmax = 1.0
L = xmax-xmin
CFL = 1.0
FinalTime = 0.3
N = 256
h = L/N

# Define domain and initial conditions
x = xmin + L/(2*N+1)*np.arange(2*N+1)
u = np.sin(2*np.pi*x) 

# Solve problem
u = BurgersSpec1D(x,u,N,L,CFL,FinalTime)

# Plot
plt.plot(x,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()