"""Driver script for solving the 1D Burgers equation using a flux-limit scheme"""

import numpy as np
import matplotlib.pyplot as plt
from BurgersFluxLimit import *

# Set problem parameters
Lx = 1.0
Ly = 1.0
Nx = 128
Ny = 128
hx = Lx/Nx
hy = Ly/Ny
CFL = 0.9
FinalTime = 0.1

# Define domain and initial conditions
xv = np.linspace(0.0, Lx, Nx+1)
yv = np.linspace(0.0, Ly, Ny+1)

x,y = np.meshgrid(xv,yv)

u = np.sin(4*np.pi*(x+y/2.0)) 

# Solve problem
u = BurgersFL2D(x,y,u,hx,hy,CFL,FinalTime)

# Plot
plt.contour(x,y,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()