"""Driver script for solving the 1D Burgers equations using an ENO scheme"""

import numpy as np
import matplotlib.pyplot as plt
from BurgersEno import *
from Legendre import *

#Order of the method
m = 2

#Setting up parameters
L = 1.0
CFL = 0.9
FinalTime = 0.2
N = 128
h = L/N

x = np.linspace(0.0, L, N+1)
fic = lambda x,t: np.sin(2*np.pi*x) #periodic BC needed
#fic = lambda x,t: (1-np.sign(x-0.2-3*t))/2.0+1.0 # Constant BC needed

# Compute cell averages using Legendre Gauss rule of order NGQ
u = np.zeros(N+1)
NGQ = 10
xGQ,wGQ = LegendreGQ(NGQ)

for i in range(NGQ+1):
	u = u + wGQ[i]*fic(x+xGQ[i]*h/2,0)
u = u/2.0

# Solve Problem
u = BurgersENO1D(x,u,h,m,CFL,FinalTime)

# Plot
plt.plot(x,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()