%% matrix multiplication =====================================================
clc
A = randn(100,100);
B = randn(100,100);
% using built-in function
tic
C = A*B;
toc
% is more efficient than
tic
C = zeros(100,100);
for i = 1:100
    for j = 1:100
        for k = 1:100
            C(i,j) = C(i,j) + A(i,k) * B(k,j);
        end
    end
end
toc

%% multiplying each column of a matrix by a different scalar ====================
clc
A = randn(100,100);
x = randn(100,1);
% using matrix product 
tic
B = A*diag(x);
toc
% is more efficient than
tic
B = zeros(100,100);
for i = 1:100
    B(:,i) = A(:,i)*x(i);
end
toc

%% unary function applied to a vector =================================
clc
x = randn(100,1);
% using vectorized function
tic
y = sin(x);
toc
% is more efficient than
tic
y = zeros(100,1);
for i = 1:100
    y(i) = sin(x(i));
end
toc

%% computing aggregate statistics ============================================
clc
x = randn(100,1);
% using vectorized functions
tic
n = length(x);
mu = sum(x)/n;
sigma = sqrt(sum((x-mu).^2)/(n-1));
toc
% is more efficient than
tic
n = length(x);
mu = 0;
sigma = 0;
for i = 1:n
    mu = mu + x(i);
end
mu = mu/n;
for i = 1:n
    sigma = sigma + (x(i)-mu)^2;
end
sigma = sqrt(sigma/(n-1));
toc

%% compute cumulative product with a condition ==========================
clc
n = 10;
x = rand(1, n);

% Naive approach (using a loop)
y_naive = ones(1, n);

tic
for i = 2:n
    if x(i) > 0.5
        y_naive(i) = y_naive(i-1) * x(i);
    else
        y_naive(i) = y_naive(i-1);
    end
end
toc

% Vectorized approach
tic
mask = x > 0.5;
y_vectorized = cumprod([1, x(mask)]);
y_vectorized = y_vectorized(cumsum(mask) + 1);
toc