%% multiplying two matricies element by element does not need broadcasting ==============================
A = randn(100, 100);
B = randn(100, 100);
res = A.*B

%% multiplying each column of a matrix by a different scalar does ====================
clc
A = randn(100, 100);
x = randn(100, 1);

t = tic;
res = A.*x;
toc(t)

t = tic;
res = A*diag(x);
toc(t)

%% creating matrix of every sums of every pair ===============================================================
clc
A = randn(100,1);
B = randn(1,100);
% using built-in function
t = tic;
C = A+B;
toc(t)
% is more efficient than
t = tic;
C = zeros(100,100);
for i = 1:100
    for j = 1:100
        C(i,j) = A(i)+B(j);
    end
end
toc(t)

%% Normalizing each column of a matrix ======================
clc
A = randn(100,100);
% smart way
tic
B = A ./ sum(A,1);
toc
% naive way
tic
B = zeros(size(A));
for i = 1:size(A,2)
    B(:, i) = A(:, i) / sum(A(:, i));
end
toc

%% applying a function to a grid =============================
clc
[X, Y] = meshgrid(linspace(-5, 5, 100), linspace(-5, 5, 200));
f = @(x, y) sin(sqrt(x.^2 + y.^2)) ./ sqrt(x.^2 + y.^2);
% Broadcasting approach
tic
Z_broadcast = f(X, Y);
toc
% Naive approach (using loops)
Z_naive = zeros(size(X));

tic
for i = 1:size(X, 1)
    for j = 1:size(X, 2)
        Z_naive(i,j) = f(X(i,j), Y(i,j));
    end
end
toc

