
///////////////////////////////////////////////////////////////////////////
// EPFL Financial Econometrics PhD course
///////////////////////////////////////////////////////////////////////////
// Attempting to replicate and extend Kashyap-Rajan-Stein 2002
///////////////////////////////////////////////////////////////////////////


cd /Users/fuster/Downloads/PS1_data

global samp = 1 // 1 or 2 -- sample 1 is 1992-1996; sample 2 is 1997-2013

///////////////////////////////////////////////////////////////////////////
// Preliminary: download CPI (to turn assets into 'real assets' below)
///////////////////////////////////////////////////////////////////////////

import fred CPIAUCNS, clear // could also do "freduse CPIAUCNS" but for some reason the freduse command no longer works for me. 
g dateq = qofd(daten)
format dateq %tq

collapse (last) CPIAUCNS , by(dateq) 
//use the last value in a quarter -- not completely clear which one should take (but unlikely to matter much)

save infl.dta, replace 

///////////////////////////////////////////////////////////////////////////
// Main data -- cleaning & collapsing to BHC level
///////////////////////////////////////////////////////////////////////////
use callreports_1976_2021wc.dta, clear

replace dateq = qofd(dateq)
format dateq %tq

// Not completely clear which entities to retain
tab chartertype

gen isbank = chartertype == 200 |  inrange(chartertype ,300,340)

*gen isbank = chartertype == 200 // with this alternative, get too few BHCs below, relative to what is in the paper

keep if isbank == 1 

replace bhcid = 9000000 + cert if bhcid==0 // construct artificial bhcid for those that don't have one

// Aggregate by BHC - quarter
collapse isbank (sum) fedfundsrepoasset securities cash assets transdep demanddep timedeple100k savdep deposits loans ciloans persloans reloans commitments, by(bhcid dateq) fast

merge m:1 dateq using infl.dta, keep(1 3)

gen assets_real = assets/CPI * 100

tabstat assets_real, by(dateq) stat(mean p50 N)


////////////

if $samp == 1{
	keep if dateq >= q(1992q1) & dateq<=q(1996q4)
}
if $samp == 2{
keep if dateq >= q(1997q1) & dateq<=q(2013q4)
}
/* NOTE: loans only reported until 2010q4 -- see data dictionary. When sum missing values, get 0... */

egen nrobs = count(assets), by(bhcid) // Number of observations by BHC in a sample period

tab nrobs 
drop if nrobs < 8 // Use same restriction (also for 1997-2013 period)

///////////////////////////
// Time averaged version:
///////////////////////////

preserve 

collapse fedfundsrepoasset securities cash assets assets_real transdep demanddep timedeple100k savdep deposits loans ciloans persloans reloans commitments, by(bhcid)

	gen secrat = (fedfundsrepoasset +  securities) / assets

	gen liqrat = (fedfundsrepoasset +  securities + cash) / assets

	gen deprat = transdep / deposits
	
	gen coredeprat = (transdep + savdep + timedeple100k) / deposits 

	gen comrat = commitments/ (commitments + loans)


	egen rank =  rank(assets_real) , field

	gen group = 1 if rank<=100
	replace group = 2 if inrange(rank,101,600)
	replace group = 3 if group == .

	tabstat assets_real, by(group) stat(min max N)

	tabstat liqrat secrat  deprat comrat, by(group) stat(p25 p50 p75 N) format(%9.3f)
	
	eststo clear
	eststo: estpost tabstat liqrat secrat  deprat comrat, stat(p25 p50 p75 N)   by(group) c(s)
	esttab _all using TableII_samp$samp.rtf, replace rtf cells("p25(fmt(%9.3f)) p50(fmt(%9.3f)) p75(fmt(%9.3f)) count(fmt(%9.0fc))") wide noobs nonumber 

	// generate additional controls 
	gen ln_assets_real = ln(assets_real)

	foreach x in ciloans persloans reloans {
		 gen `x'_rat = `x'/loans 
	}

	eststo clear
	foreach y in liqrat secrat comrat {
		
		eststo: reg `y' deprat , rob
		qui sum `y' if e(sample)
		local sy = r(sd)
		qui sum deprat if e(sample)
		local sx = r(sd)
		local expwr = _b[deprat]*`sx'/`sy'
		local expwr=string(`expwr', "%9.3g")
		estadd local expwr = `expwr'
		estadd local group 		"All"
		estadd local controls   "N"
		
		eststo: reg `y' deprat ln_assets_real ciloans_rat persloans_rat reloans_rat, rob
		qui sum `y' if e(sample)
		local sy = r(sd)
		qui sum deprat if e(sample)
		local sx = r(sd)
		local expwr = _b[deprat]*`sx'/`sy'
		local expwr=string(`expwr', "%9.3g")
		estadd local expwr = `expwr'
		estadd local group 		"All"
		estadd local controls   "Y"

		forval i = 1/3 {
			eststo: reg `y' deprat if group==`i', rob
			qui sum `y' if e(sample)
			local sy = r(sd)
			qui sum deprat if e(sample)
			local sx = r(sd)
			local expwr = _b[deprat]*`sx'/`sy'
			local expwr=string(`expwr', "%9.3g")

			estadd local expwr = `expwr'
			estadd local group 		"`i'"
			estadd local controls   "N"
			
			eststo: reg `y' deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==`i', rob
			qui sum `y' if e(sample)
			local sy = r(sd)
			qui sum deprat if e(sample)
			local sx = r(sd)
			local expwr = _b[deprat]*`sx'/`sy'
			local expwr=string(`expwr', "%9.3g")
			estadd local expwr = `expwr'
			estadd local group 		"`i'"
			estadd local controls   "Y"

		}
		
	}
	
	esttab * using Tables_III_IV_samp$samp.csv, ///
	csv replace t compress starl(* .1 ** 0.05 *** 0.01) keep(deprat )   ///
	stat(expwr group controls N r2 , fmt(2 0 0 0 3) labels("Explanatory Power" "Group" "Controls?" "Obs." "R2"))  ///
	coeflabel(deprat "DEPRAT") nonotes 	
	
	foreach y in liqrat secrat comrat {
		binsreg `y' deprat ln_assets_real ciloans_rat persloans_rat reloans_rat , name(br_`y', replace) ci(3,3) //  dots(0,0)   cb(3,3) 
		scatter `y' deprat  , name(scat_`y', replace)  

	}
	/*
	binsreg liqrat deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==1, nbins(10) dots(0,0)   cb(3,3) 
    binsreg liqrat deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==2, nbins(10) dots(0,0)   cb(3,3) 
    binsreg liqrat deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==3, nbins(50) dots(0,0)   cb(3,3) 
	
	binsreg comrat deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==1, nbins(10) dots(0,0)   cb(3,3) 
    binsreg comrat deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==2, nbins(10) dots(0,0)   cb(3,3) 
    binsreg comrat deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if group==3, nbins(50) dots(0,0)   cb(3,3) 
	*/
	
	
restore 


/////////////////////////////////////////////////////////////////////////////
// Quarterly version (no time averaging; try different combinations of FE):
/////////////////////////////////////////////////////////////////////////////


gen secrat = (fedfundsrepoasset +  securities) / assets

gen liqrat = (fedfundsrepoasset +  securities + cash) / assets

gen deprat = transdep / deposits

gen comrat = commitments/ (commitments + loans)

gen ln_assets_real = ln(assets_real)

foreach x in ciloans persloans reloans {
	 gen `x'_rat = `x'/loans 
}

preserve // need to establish the ranking of assets -- do so based on averages 
	collapse assets_real, by(bhcid)
	egen rank =  rank(assets_real) , field
	keep bhcid rank 
	tempfile rank
	save `rank', replace
restore

merge m:1 bhcid using `rank', gen(rankmerge)
	
gen largebanks = rank<=600

tabstat assets_real, by(largebanks) stat(min max N)

eststo clear
forval z = 0/1 {
	
foreach y in liqrat secrat comrat {
	
	// No FE
	eststo: reghdfe `y' deprat if largebanks== `z' , noabsorb vce(clu bhcid)
	estadd local quarterFE 	"N"
	estadd local bhcFE   "N"
	estadd local controls   "N"
	estadd local large = `z'

	eststo: reghdfe `y' deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if largebanks== `z', noabsorb vce(clu bhcid)
	estadd local quarterFE 	"N"
	estadd local bhcFE   "N"
	estadd local controls   "Y"
	estadd local large = `z'
	
	// with quarter FE only
	eststo: reghdfe `y' deprat if largebanks== `z', absorb(dateq) vce(clu bhcid)
	estadd local quarterFE 	"Y"
	estadd local bhcFE   "N"
	estadd local controls   "N"
	estadd local large = `z'
	
	eststo: reghdfe `y' deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if largebanks== `z', absorb(dateq) vce(clu bhcid)
	estadd local quarterFE 	"Y"
	estadd local bhcFE   "N"
	estadd local controls   "Y"
	estadd local large = `z'
	
	// with quarter FE and bank FE
	eststo: reghdfe `y' deprat if largebanks== `z', absorb(dateq bhcid) vce(clu bhcid)
	estadd local quarterFE 	"Y"
	estadd local bhcFE   "Y"
	estadd local controls   "N"
	estadd local large = `z'
	
	eststo: reghdfe `y' deprat ln_assets_real ciloans_rat persloans_rat reloans_rat if largebanks== `z', absorb(dateq bhcid) vce(clu bhcid)
	estadd local quarterFE 	"Y"
	estadd local bhcFE   "Y"
	estadd local controls   "Y"
	estadd local large = `z'	
	}
}
	

esttab * using Tables_III_IV_quarterly_samp$samp.csv, ///
csv replace t compress starl(* .1 ** 0.05 *** 0.01) keep(deprat )   ///
stat(quarterFE bhcFE controls large N r2 , fmt(2 0 0 0 0 3) labels("Quarter FE?" "Bank FE?" "Controls?" "Sample = top 600?" "Obs." "R2"))  ///
coeflabel(deprat "DEPRAT") nonotes 	


// illustrating how much variation is absorbed by fixed effects
eststo: reghdfe comrat deprat if largebanks== 0, absorb(dateq bhcid) vce(clu bhcid)

sumhdfe comrat deprat if largebanks== 0, absorb(dateq bhcid) vce(clu bhcid)

reghdfe deprat if largebanks== 0 & comrat <., absorb(dateq) res(res_qFE)
hist res_qFE 

reghdfe deprat if largebanks== 0 & comrat <., absorb(dateq bhcid ) res(res_qFE_bFE)
hist res_qFE_bFE  

tabstat deprat  res_qFE res_qFE_bFE if largebanks== 0 & comrat <., stat(mean sd min p5 p50 p95 max)  format(%9.3f)

// to see an example of a bank that has a large residual after FEs are added:
// line deprat  dateq if bhcid == 1242759, sort





