% -------------------------------------------------------------------------
% Course: Hydrology for Engineers
% Assignment 1
% Part 1: Process rainfall data from MeteoSwiss
% -------------------------------------------------------------------------

clear variables %clear the workspace variables
close all %close alla figures
clc %clear the command window

% -------------------------------------------------------------------------
% # 0-1: Data import and cleaning
% useful functions: readtable, isnan, year, month
% -------------------------------------------------------------------------

% import data into table T
T = readtable('data.txt',...
    'HeaderLines', 2,...
    'Format','%s%s%f',... %the format is: text string, text string and float number
    'TreatAsEmpty','-'); %this is how empty data is reported (see metadata line 21)

% Create a vector h containing the hourly precipitation and a vector t
% containing the timestamp
h = T.rre150h0;    %rre150h0 is a MeteoSwiss code 
t = datetime(T.time,'InputFormat','yyyyMMddHH'); %convert to datetime (can take several seconds)
m = month(t); %gives a value in 1-12 to indicate the month of each date
y = year(t); %gives the year of each date

% fix empty values (which appear as NaN values in the Matlab)
emptyValues = isnan(h); %logical test to tell whether a value is missing or not
h(emptyValues) = 0; %give zero to those values
fprintf('%i empty values\n', sum(emptyValues)); %display how many missing values there are


% -------------------------------------------------------------------------
% # 2: Plot with annual rainfall over the years
% -------------------------------------------------------------------------

% ...
% ...
% ...





















% -------------------------------------------------------------------------
% # 6: save the output
% useful functions: save
% -------------------------------------------------------------------------
% when you are confident about your results, save the variables AnnualMax
% and D by uncommenting the following line: 
% save('assignment1_output_part1.mat','D','AnnualMax');

