# -*- coding: utf-8 -*-
"""
Created on 20 Sep 2024

@author: eso

*** Propagation de variance - fonction auxiliaire ***

fonctions définies pour scanner laser 
"""

import numpy as np
import math

def xyz(obs):
	rho = obs[0]
	the = obs[1]
	alf = obs[2]

	# Attention! Beaucoup de langages de programmation - dont Python -
	# exigent que l'argument d'une fonction trigonométrique soit exprimé en
	# radians.

	# Pour convertir les angles, Python reconnait "np.deg2rad",
	# mais cela pourrait changer selon la version.
	# Si jamais, "*pi/200" fonctionnera encore longtemps.

	fct1 = rho * (math.cos(math.pi*the/200.0)) * (math.cos(math.pi*alf/200.0))   
	fct2 = rho * (math.sin(math.pi*the/200.0)) * (math.cos(math.pi*alf/200.0))    
	fct3 = rho * (math.sin(math.pi*alf/200.0))

	fct = [fct1, fct2, fct3]

	return fct