# -*- coding: utf-8 -*-
"""
auteur: ESO / 25.09.24

A partir d'une d'un vecteur d'écarts-types et d'une matrice de corrélation, 
former une matrice de covariance.
"""

import numpy as np

def cormat2covmat(sigma, Rll):
    
    n = np.size(sigma)       # nombre d'éléments
    Kll = np.zeros((n,n))    # Réserver un espace contigu en mémoire.
    
    for i in range(n):
        Kll[i,i] = sigma[i]*sigma[i]
        for j in range(i):   # triangle inférieur de la matrice
            Kll[i,j] = Rll[i,j]*sigma[i]*sigma[j]
            Kll[j,i] = Kll[i,j]
    
    return Kll
