# -*- coding: utf-8 -*-
"""
Created on 20 Sep 2024

@author: eso

*** Propagation de variance - fonction auxiliaire ***

fonction de base définie pour la determination de hauter (z)
a partir de distance (rho) et l'angle d'élévation (alpha)
"""

import numpy as np
import math

def fz(obs):
	rho = obs[0]
	alf = obs[1]

	# Attention! Beaucoup de langages de programmation - dont Python -
	# exigent que l'argument d'une fonction trigonométrique soit exprimé en
	# radians.

	# Pour convertir les angles, Python reconnait "np.deg2rad",
	# mais cela pourrait changer selon la version.
	# Si jamais, "*pi/200" fonctionnera encore longtemps.

	fct3 = rho * (math.sin(math.pi*alf/200.0))

	fct = [fct3]

	return fct