%% Optimal Control Course EE 715 at EPFL
% Problem Set #5 Exercise 3
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017
%% initialize
clear all;
close all;
clc;
set(groot, 'defaultAxesTickLabelInterpreter','latex');
set(groot, 'defaultLegendInterpreter','latex');
linewidth   =   1.5;
%%
[PAR,CON,~,SCx,SCu] = parameters; 
nx      =   3;
nu      =   2;
dt      =   1E-3; % sampling period
% MPC time
Nmpc    =   50;
Tmpc    =   Nmpc*dt;
tmpc    =   0:dt:Tmpc;
% Number of integrations per shooting interval
Nint    =   3;
% simulation time
t0      =   0; %start time
tf      =   0.12; %end time of simulation
tsim    =   0:dt:tf;
ksim    =   length(tsim);
% initial condition
x0      =   [1.5E3; 1.2E3; 70.0]; % initial condition
% weights
Q       =   1e3*diag([1,1,1]);
R       =   1e3*diag([1,1]);
% constraints
umin    =   [CON.u1(1); CON.u2(1)];
umax    =   [CON.u1(2); CON.u2(2)];
xmin    =   [CON.cA(1); CON.cB(1); CON.T(1)];
xmax    =   [CON.cA(2); CON.cB(2); CON.T(2)];
%% solve steady state optimization problem
import casadi.*
X       =   optivar(nx,1);
U       =   optivar(nu,1);
J       =   -X(2)*U(1);
g       =   {CSTR_ode(0,X,U) == 0};
g       =   [g, {SCu.*umin <= U <= SCu.*umax}];
g       =   [g, {SCx.*xmin <= X <= SCx.*xmax}];
SSsol   =   optisolve(J,g);
xSS     =   optival(X);
uSS     =   optival(U);
% scaled results:
% xSS     =   [2.1747; 1.1051; 1.2850];
% uSS     =   [3.5000; 1.4270];
%% Economic MPC
% ##############################################
% build OCP
import casadi.*
U       =   optivar(nu,Nmpc);
X       =   optivar(nx+1,Nmpc+1);
X0      =   optipar(nx+1,1,'x0');
g       =   [];
J       =   0;
Jpenal  =   0;
for i=1:Nmpc
    % add integrated dynamics as constraint
    xx  = X(:,i);
    for j = 1:Nint
        xx      =   rk4(@(t,x,u)CSTR_ode_eco(t,x,u,uSS),dt/Nint,tmpc(i),xx,U(:,i));
    end
    % gap closing constraint
    g       =   [g, {X(:,i+1) == xx}];
    % constraints
    g       =   [g, {SCu.*umin <= U(:   ,i  ) <= SCu.*umax}];
    g       =   [g, {SCx.*xmin <= X(1:nx,i+1) <= SCx.*xmax}];
    % penalization of change in u
    Jpenal  = Jpenal + 1e-2*(U(:,i)-U(:,i-1))'*(U(:,i)-U(:,i-1));
end
% cost function
J   =   X(nx+1,end) + Jpenal;
% initial condition constraint
g   =   [g, {X(:,1) == X0}];
% terminal constraint
% g   =   [g, {X(1:3,end) == xSS}];
% g   =   [g, {U(:,end) == uSS}];

% set initial condition
X0.setValue([SCx.*x0; 0]);
% initial guess
X.setInit(repmat([xSS; 0],1,Nmpc+1))
U.setInit(repmat(uSS,1,Nmpc));
% solve ocp
opts.ipopt.tol = 1e-9;


soleco  =   optisolve(J,g,opts);
Usol    =   optival(U);
Xsol    =   optival(X);
Lsol    =   Xsol(end,:);
Xsol    =   Xsol(1:nx,:);
plotresults(tmpc,Xsol,Usol,xSS,uSS,[12,13])
%%
% ##############################################
% MPC iterations
[xeco,ueco] = MPCloop(U,X,X0,soleco,@CSTR_ode_eco,dt,tf,[xSS; 0],uSS,[SCx.*x0; 0]);
Leco    =   xeco(end,:);
xeco    =   xeco(1:nx,:);
plotresults(tsim,xeco,ueco,xSS,uSS,[14,15]);

%% cost comparison
Jopt    = xeco(2,1:end-1)*ueco(1,:)';





