%% Optimal Control Course EE 715 at EPFL
% Problem Set #5 
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017

function [x,u] = MPCloop(U,X,Xinit,opti,ODE,dt,tf,xguess,uguess,x0Num)
% inputs:
%   X0      optipar for initial condition for each OCP
%   U       optivar for MPC inputs
%   sol     parameterized solver for OCP
%   x0      numerical value of initial condition
    t           =   0:dt:tf;
    N           =   length(t)-1;
    nx          =   length(x0Num);
    [nu,Nmpc]   =   size(U);
    x           =   zeros(nx,N+1);
    u           =   zeros(nu,N);
    x(:,1)      =   x0Num;
    Xsol        =   repmat(xguess,1,Nmpc+1);
    Usol        =   repmat(uguess,1,Nmpc);
    
    X1init = Xinit(1);
    X2init = Xinit(2);
    X3init = Xinit(3);
    
    for k = 1:N
        % set current state
        opti.set_value(X1init, x(1,k));
        opti.set_value(X2init, x(2,k));
        opti.set_value(X3init, x(3,k));
      
        % initialize OCP
        opti.set_initial(U, Usol);
        opti.set_initial(X, Xsol);
        
        % resolve OCP
        sol  = opti.solve();
        Usol = sol.value(U);
        Xsol = sol.value(X);
        
        % get first element
        u(:,k)   =   Usol(:,1);
        
        % apply to system using rk4
        x(:,k+1) =   rk4(@(t,x,u)ODE(t,x,u),dt,t(k),x(:,k),u(:,k));
        % apply to system using Matlab's ODE solvers
 %       [~,xt]     =   ode45(@(t,x,u)ODE(t,x,u),[t(k), t(k)+dt],x(:,k),[],u(:,k));
 %       [~,xt]     =   ode15s(@(t,x,u)ODE(t,x,u),[t(k), t(k)+dt],x(:,k),[],u(:,k));
 %       x(:,k+1) =   xt(end,:)';
    end
end