%% Optimal Control Course EE 715 at EPFL
% Problem Set #3 Exercise 1 b
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017
%
%% ODE right-hand side
function dx = CSTR_ode_mod(t,x,u)
        % extract parameters
        p       = parameters;
        cAf     = p.cAf;
        q       = p.q;
        V       = p.V;
        k0      = p.k0;
        ER      = p.ER;
        Tf      = p.Tf;
        dH      = p.dH;
        rho     = p.rho;
        Cp      = p.Cp;
        UA      = p.UA;
        % extract state
        cA  =   x(1);
        T   =   x(2);
        tf  = u(2);
        % ode
        dc = q/V*(cAf - cA) - k0*exp(-ER/T)*cA;                     
        dT = q/V*(Tf -  T ) - dH/(rho*Cp)*k0*exp(-ER/T)*cA ...
                            + (UA)/(V*rho*Cp)*(u(1)-T); 
        dx = tf*[dc; dT];      
end