function P2EX3b
%
% Optimal Control Course EE 715 at EPFL
% Problem Set #2 Exercise 3 b
%
% This exercise is based on a previous version by Benoit
% Chachuat.  
%
% Autor:    timm.faulwasser@epfl.ch 
% Date:     23-01-14
% Status:   final

close all

%% definition of variables

t0 = 0;
t1 = 1;
N = 20; %# number of stages
tspan = [0:(t1-t0)/N:t1];
x0 = 1
x1 = 0
z0 = 0

tau = [0:0.25:0.75]; % collocation points on each stage
n_co = length(tau); %order of the collocation method +1

u = zeros(1,N); sdpvar(1,N);

xi  = sdpvar(1, n_co*(N)); % state variable x
zi  = sdpvar(1, n_co*(N)); % augmented state for Mayer term

%% collocation constraints
dyn_eq_x = [];
dyn_eq_z = [];
for i = 1:N   
    for q = 2:n_co
        %index = (i-1)*n_co+q
        index_span = IndexSpan(i, n_co); %[(i-1)*n_co+1:1:i*n_co]   
    
        h      = tspan(i+1)-tspan(i);        
        phi_x     = lagrange([xi(1,index_span)], tau, tau(q));
        dphi_x    = dlagrange([xi(1,index_span)], tau, tau(q)); 
        dyn_eq_x  = dyn_eq_x + [1/h*dphi_x + phi_x - u(i) == 0];  
            
        phi_z     = lagrange([zi(1,index_span)], tau, tau(q));
        dphi_z    = dlagrange([zi(1,index_span)], tau, tau(q)); 
        dyn_eq_z  = dyn_eq_z + [1/h*dphi_z - 0.5*u(i)^2 == 0]; 
    end    
      
   if i == 1 % initial condition
        phi_x     = lagrange(xi(index_span), tau, 0);
        dyn_eq_x  = dyn_eq_x + [phi_x - x0 ==0]; 
        
        phi_z     = lagrange(zi(index_span), tau, 0);
        dyn_eq_z  = dyn_eq_z + [phi_z - z0 ==0]         
    else
    % continuity between stages
        phi_x_left  = lagrange([xi(1,IndexSpan(i-1, n_co))], tau, 1.);
        phi_x_right = lagrange([xi(1,IndexSpan(i, n_co))], tau, 0.);
        dyn_eq_x    = dyn_eq_x + [phi_x_left == phi_x_right];      
        
        phi_z_left  = lagrange([zi(1,IndexSpan(i-1, n_co))], tau, 1.);
        phi_z_right = lagrange([zi(1,IndexSpan(i, n_co))], tau, 0.);
        dyn_eq_z    = dyn_eq_z +  [phi_z_left == phi_z_right];   
   end          
end

yalmip_options = sdpsettings('showprogress',1, 'verbose',0, 'solver', 'fmincon');%, 'TolX', 1E-7, 'TolFun', 1E-7);  
yalmip_options.quadprog.TolX = 1E-14;
yalmip_options.quadprog.TolFun = 1E-14;

constraints = dyn_eq_x + dyn_eq_z;
objective = 1; 

%% integrate via solving the collocation constraints
result = solvesdp(constraints, objective,yalmip_options)


%% plot solution
u = double(u);
xi = double(xi);
zi = double(zi);

xplot = [];
tplot = [];
Nplot = 10;

for i = 1:N
    dt = [tspan(i):(tspan(i+1)-tspan(i))/Nplot:tspan(i+1)]';
    index_span = IndexSpan(i, n_co);    
    tplot = [tplot; dt];
    xplot = [xplot; lagrange([xi(1,index_span)], tau, (dt - tspan(i))/(tspan(i+1)-tspan(i)))];    
end

figure
title('State')
plot(tplot, xplot, 'Linewidth', 2)
xlabel('t')
ylabel('x')
grid on

end

function span = IndexSpan(i, n_co)
    span = [(i-1)*n_co+1:1:i*n_co]; 
end