function P2EX1
%% Optimal Control (EE-715)
% Course at EPFL
% Problem Set #2 Exercise 2
%
% This exercise is based on an example from Teo, Goh, Wong, p. 146
%
% Autor:    timm.faulwasser@kit.edu
% Date:     20-07-16
% Status:   final


%clc
%close all

t0 = 0;
tf = 1;
h  = 0.02;
c  = 3;
x0 = [0; -1];
N = (tf - t0)/h +1;

x = sdpvar(2, N+1);
u = sdpvar(1, N+1);
t = sdpvar(1, N+1);
g = sdpvar(1, N+1);
F = sdpvar(1, N+1);

t(1)    = t0;
x(:,1)  = x0;
F(1)    = 0;

%% express discretized dynamics as equality constraints
for i=1:N
    x_temp   =  x(:, i) + h*([0, 1; 0, c]*x(:,i) + [0; 1]*u(i));
    x(:,i+1) =  x(:, i) + h/2*([0, 1; 0, c]*x(:,i) + [0; 1]*u(i) + [0, 1; 0, c]*x_temp + [0; 1]*u(i+1));  
    
%    x(:,i+1) =  x(:, i) + h*([0, 1; 0, c]*x(:,i) + [0; 1]*u(i));      
    t(i+1)   = t(i) + h;       
    g(i)     = 8*(t(i)-0.5)^2 -0.5 - x(2,i); 
    F(i+1)   = F(i) + h*(x(1,i)^2 + x(2,i)^2 + 5E-3*u(i)^2);
end
g(N+1) =  8*(t(N+1)-0.5)^2 -0.5 - x(2, N+1);


%% add contraints 
input_constraint = [];
state_constraint = [];

%input
for i  =  1:N
    input_constraint = input_constraint + [-20<= u <= 20];
    state_constraint = state_constraint + [0<= g];
    
end
input_constraint = input_constraint +  [u(N) == u(N+1)];

%% express objective
objective =  sum(F(i+1));

% solve QP via Yalmip

yalmip_options = sdpsettings('showprogress',1, 'solver', 'quadprog', 'debug', 1)%, 'TolX', 1E-7, 'TolFun', 1E-7);  
%yalmip_options.quadprog.TolX = 1E-7;
%yalmip_options.quadprog.TolFun = 1E-7;

constraints = input_constraint + state_constraint;

solvesdp(constraints, objective,yalmip_options)
%keyboard
%% plot solutions
    
x = double(x);
u = double(u);
g = double(g);
double(objective)
t_plot = [t0:1e-4:tf];
g_plot = 8.*(t_plot-0.5).^2 -0.5;

figure
subplot(3,1,1)
plot(t, x(1,:),'Linewidth', 2)
xlabel('t')
ylabel('x_1')
%axis([0, 1, -0.5, 0]);
grid on

subplot(3,1,2)
plot(t, x(2,:), 'b', 'Linewidth', 2)
hold on
plot(t_plot, g_plot, 'r', 'Linewidth', 2)
xlabel('t')
ylabel('x_2, g')
%axis([0, 1, -1, 0.6]);
grid on
legend('x_2', 'g(t,x_2)+x_2', 'Location','Southeast')

subplot(3,1,3)
stairs(t, u(:),'Linewidth', 2)
xlabel('t')
ylabel('u')
axis([0, 1.4, -20, 20]);
grid on


%% verify solution via accurate integration
options = [];%odeset('RelTol', 1E-12, 'AbsTol', 1E-12);
t_ode = [];
z_ode = [];

z0i = [x0; 0];
for i = 1:N
    t_span = [(i-1)*h, i*h]+t0;
   % [t_i, z_i] = ode45(@dynamics, t_span, z0i, options, u(i), c);
   [t_i, z_i] = ode113(@dynamics, t_span, z0i, options, (u(i)+u(i+1))/2, c);
    t_ode = [t_ode; t_i];
    z_ode = [z_ode; z_i];
    z0i   = z_ode(end, :);
end



z_ode(end, 3)
figure(gcf)
subplot(3,1,1)
hold on
plot(t_ode, z_ode(:,1), 'g', 'Linewidth', 2)
legend('x_1', 'x_1 from ode45', 'Location','Southeast')

subplot(3,1,2)
hold on
plot(t_ode, z_ode(:,2), 'g', 'Linewidth', 2)
legend('x_2', 'g(t,x_2)+x_2', 'x_2 from ode45', 'Location','Southeast')

keyboard
end

function dx = dynamics(t,x,u,c)
dx(1,1) =   x(2);
dx(2,1) = c*x(2) + u;
dx(3,1) =   x(1)^2 + x(2)^2 + 0.005*u^2;
end




