function hn = PQMF32_prototype;

% hn = PQMF32_prototype returns in hn the impulse response of the prototype
% low-pass symmetric filter of length 512 for building a 32-channel PQMF
% filter bank. This filter is used in the MPEG-1 Layer-1 coder. Its
% normalized bandpass is 1/64 Hz and satisfies the PR condition.   

% Second half of the filter
temp = [ 0.202407  0.202283  0.201916  0.201307 ...
         0.200452  0.199359  0.198029  0.196465 ... 
         0.194668  0.192648  0.190409  0.187952 ... 
         0.185290  0.182422  0.179361  0.176113 ... 
         0.172685  0.169084  0.165321  0.161407 ... 
         0.157347  0.153153  0.148837  0.144402 ... 
         0.139868  0.135239  0.130527  0.125745 ... 
         0.120900  0.116004  0.111068  0.106105 ... 
         0.101123  0.096135  0.091148  0.086174 ... 
         0.081224  0.076307  0.071432  0.066610 ... 
         0.061849  0.057155  0.052540  0.048011 ... 
         0.043576  0.039242  0.035012  0.030899 ... 
         0.026907  0.023036  0.019297  0.015693 ... 
         0.012227  0.008901  0.005724  0.002692 ... 
        -0.000189 -0.002919 -0.005495 -0.007917 ... 
        -0.010185 -0.012303 -0.014264 -0.016074 ... 
        -0.017733 -0.019243 -0.020608 -0.021827 ... 
        -0.022906 -0.023845 -0.024652 -0.025326 ... 
        -0.025873 -0.026300 -0.026604 -0.026799 ... 
        -0.026882 -0.026863 -0.026747 -0.026537 ... 
        -0.026238 -0.025855 -0.025399 -0.024867 ... 
        -0.024271 -0.023616 -0.022904 -0.022143 ... 
        -0.021336 -0.020492 -0.019613 -0.018706 ... 
        -0.017773 -0.016824 -0.015858 -0.014882 ... 
        -0.013900 -0.012915 -0.011936 -0.010960 ... 
        -0.009994 -0.009039 -0.008103 -0.007183 ... 
        -0.006285 -0.005411 -0.004564 -0.003744 ... 
        -0.002954 -0.002196 -0.001470 -0.000777 ... 
        -0.000121  0.000499  0.001084  0.001632 ... 
         0.002142  0.002616  0.003051  0.003453 ... 
         0.003814  0.004141  0.004435  0.004691 ... 
         0.004915  0.005106  0.005265  0.005395 ... 
         0.005495  0.005565  0.005611  0.005629 ... 
         0.005624  0.005597  0.005549  0.005481 ... 
         0.005397  0.005292  0.005176  0.005044 ... 
         0.004901  0.004745  0.004580  0.004408 ... 
         0.004227  0.004041  0.003852  0.003658 ... 
         0.003461  0.003264  0.003067  0.002870 ... 
         0.002673  0.002479  0.002287  0.002101 ... 
         0.001918  0.001740  0.001567  0.001400 ... 
         0.001238  0.001082  0.000936  0.000793 ... 
         0.000658  0.000531  0.000413  0.000299 ... 
         0.000194  0.000097  0.000005 -0.000078 ... 
        -0.000154 -0.000224 -0.000286 -0.000343 ... 
        -0.000394 -0.000440 -0.000477 -0.000510 ... 
        -0.000539 -0.000561 -0.000580 -0.000596 ... 
        -0.000604 -0.000612 -0.000615 -0.000615 ... 
        -0.000612 -0.000607 -0.000599 -0.000588 ... 
        -0.000575 -0.000561 -0.000545 -0.000529 ... 
        -0.000513 -0.000494 -0.000475 -0.000456 ... 
        -0.000434 -0.000415 -0.000397 -0.000375 ... 
        -0.000356 -0.000337 -0.000316 -0.000299 ... 
        -0.000281 -0.000262 -0.000245 -0.000229 ... 
        -0.000213 -0.000197 -0.000183 -0.000170 ... 
        -0.000156 -0.000143 -0.000132 -0.000121 ... 
        -0.000111 -0.000103 -0.000094 -0.000084 ... 
        -0.000078 -0.000070 -0.000065 -0.000057 ... 
        -0.000051 -0.000046 -0.000043 -0.000038 ... 
        -0.000035 -0.000030 -0.000027 -0.000024 ... 
        -0.000022 -0.000019 -0.000019 -0.000016 ... 
        -0.000013 -0.000013 -0.000011 -0.000011 ... 
        -0.000008 -0.000008 -0.000005 -0.000005 ... 
        -0.000005 -0.000005 -0.000003 -0.000003 ... 
        -0.000003 -0.000003 -0.000003 -0.000003];

% Full symmetric filter response
hn = [0 fliplr(temp(2:256)) temp];