def read_lines(file_path):
    with open(file_path, "r") as input_file:
        lines = list(map(lambda line: line.strip(), input_file.readlines()))
    return lines

def load_dataset():
    reviews = read_lines("data/reviews.txt")
    labels = read_lines("data/labels.txt")
    return reviews, labels

def retrieve_exception_stop_words():
    return [
    'again',
    'against',
    'ain',
    'almost',
    'among',
    'amongst',
    'amount',
    'anyhow',
    'anyway',
    'aren',
    "aren't",
    'below',
    'bottom',
    'but',
    'cannot',
    'couldn',
    "couldn't",
    'didn',
    "didn't",
    'doesn',
    "doesn't",
    'don',
    "don't",
    'done',
    'down',
    'except',
    'few',
    'hadn',
    "hadn't",
    'hasn',
    "hasn't",
    'haven',
    "haven't",
    'however',
    'isn',
    "isn't",
    'least',
    'mightn',
    "mightn't",
    'move',
    'much',
    'must',
    'mustn',
    "mustn't",
    'needn',
    "needn't",
    'neither',
    'never',
    'nevertheless',
    'no',
    'nobody',
    'none',
    'noone',
    'nor',
    'not',
    'nothing',
    'should',
    "should've",
    'shouldn',
    "shouldn't",
    'too',
    'top',
    'up',
    'very'
    'wasn',
    "wasn't",
    'well',
    'weren',
    "weren't",
    'won',
    "won't",
    'wouldn',
    "wouldn't",
    ]

def retrieve_pipelined_reviews():
    import pickle
    with open("data/pipelined_reviews.pkl", "rb") as input_file:
        pipelined_reviews = pickle.load(input_file)
    return pipelined_reviews