pkg load signal;
echo on; clc;

%%% Speech Signal Observation %%%
fdata = speech_signal_observation("f_s1_t1_a", 1, "Utterance /a/ of female speaker 1");

pause; % Press a key...
close(1);

%%% Observation of Short-Time Speech Signal %%%
fstdata = select_speech(fdata, 15001, 15480, 2, "30 msec speech signal of utterance /a/ spoken by female speaker 1");

pause; % Press a key...
close(2);

%%% Autocorrelation Analysis %%%
fcorrdata = autocorrelation(fstdata, 256, 3, "Autocorrelation of order 256 of the 30 msec speech signal of utterance /a/ of female speaker 1");

pause; % Press a key...
close(3);

%%% Fourier Spectrum %%%
fourierSpectrum(fstdata, 512, 4, "Fourier spectrum of 30 msec speech signal of utterance /a/ of female speaker 1");

pause; % Press a key...
close(4);

%%% Spectrogram %%%
plotSpectrogram(fdata, 256, hamming(256), 16000, 6, "Wide-band spectrogram of the utterance /a/ of female speaker 1");

pause; % Press a key...
close(6);

plotSpectrogram(fdata, 1024, hamming(1024), 16000, 7, "Narrow-band spectrogram of the utterance /a/ of female speaker 1");

pause; % Press a key...
close(7);

%%% LP Spectrum %%%
lpSpectrum(fstdata, 14, 1, 512, 16000, 8, "LP spectrum of the short-time signal fstdata");

pause; % Press a key...
close(8);

%%% LP residual %%%
residual = lpResidual(fstdata, 480, 10, 9, "LP residual signal");

pause; % Press a key...
close(9);

autocorrelation(residual, 256, 10, "Autocorrelation of LP residual signal");

pause; % Press a key...
close(10);

%%% LP Spectrum of Different Speech Sounds %%%
lpSpectrum_Sounds(1)

pause; % Press a key...
close([1,2,3,4,5]);

%%% Intra- and Inter-Speaker Variability %%%
speakerVariation("f_s2_t1_a", "f_s2_t2_a", "f_s2_t3_a", 14001, 14480, 10001, 10480, 12481, 12960, 1);

pause; % Press a key...
close(1);

speakerVariation("f_s1_t1_a", "m_s2_t1_a", "c_s1_t1_a", 15001, 15480, 9001, 9480, 12481, 12960, 1);

pause; % Press a key...
close(1);

%%% SIFT Algorithm and Pitch Contour %%%

sift("m_s1_i_sen1", 480, 160, 10, 16000, 1, "Pitch contour of interrogative sentence spoken by male speaker 1");

pause; % Press a key...
close([1, 2]);

sift("m_s1_d_sen1", 480, 160, 10, 16000, 3, "Pitch contour of declarative sentence spoken by male speaker 1");

pause; % Press a key...
close([3, 4]);

sift("m_s2_i_sen1", 480, 160, 10, 16000, 5, "Pitch contour of interrogative sentence spoken by male speaker 2");

pause; % Press a key...
close([5, 6]);

sift("m_s2_d_sen1", 480, 160, 10, 16000, 7, "Pitch contour of declarative sentence spoken by male speaker 2");

pause; % Press a key...
close([7, 8]);
