// File: GameViewModel.kt
package com.epfl.esl.android_midterm_2024

import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Canvas
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.graphics.Color
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel

class GameViewModel : ViewModel() {

    //* TODO: Checkpoint 3
    // Make retriesLeft a LiveData variable observed as a state from the GameScreen. Then, implement
    // the functions resetRetries() and decrementRetries() according to their descriptions. *//



    // Initialize the number of retries left to 3
    fun resetRetries() {

    }

    // Decrement the number of retries left by 1.
    // The number of retries left should never be negative.
    fun decrementRetries() {

    }

    // END TODO 3

    var missingPieceIndex = mutableStateOf(0)
        private set

    var options = mutableStateOf<List<Bitmap>>(emptyList())
        private set

    var imageBlocks: List<Bitmap> = emptyList()
        private set

    var originalImage: Bitmap? = null

    var displayedImage = mutableStateOf<Bitmap?>(null)
        private set


    fun pickBackgroundColor(retriesLeft : Int) : Color {
        return when {
            retriesLeft == 0 -> Color(0xFFFC867E)
            retriesLeft == 1 -> Color(0xFFFCC056)
            retriesLeft == 2 -> Color(0xFFFAEF8E)
            else -> Color(0xFFB7FFBA)
        }
    }

    fun initializeGame(context: Context) {
        resetRetries()
        // Load and split the image
        originalImage = BitmapFactory.decodeResource(context.resources, R.drawable.elephant)
        originalImage?.let {
            imageBlocks = splitImage(it)
            generateNewPuzzle(context)
        }
    }

    fun generateNewPuzzle(context: Context) {
        if (imageBlocks.isNotEmpty()) {
            missingPieceIndex.value = (0 until 9).random()
            options.value = getOptions(imageBlocks, missingPieceIndex.value)
            displayedImage.value = createImageWithMissingPiece(
                imageBlocks,
                missingPieceIndex.value,
                context
            )
        }
    }

    fun splitImage(image: Bitmap): List<Bitmap> {
        val rows = 3
        val cols = 3
        val blockWidth = image.width / cols
        val blockHeight = image.height / rows
        val imageBlocks = mutableListOf<Bitmap>()

        for (row in 0 until rows) {
            for (col in 0 until cols) {
                val block = Bitmap.createBitmap(
                    image,
                    col * blockWidth,
                    row * blockHeight,
                    blockWidth,
                    blockHeight
                )
                imageBlocks.add(block)
            }
        }
        return imageBlocks
    }

    fun createImageWithMissingPiece(
        imageBlocks: List<Bitmap>,
        missingIndex: Int,
        context: Context
    ): Bitmap {
        val rows = 3
        val cols = 3
        val blockWidth = imageBlocks[0].width
        val blockHeight = imageBlocks[0].height
        val combinedImage = Bitmap.createBitmap(
            blockWidth * cols,
            blockHeight * rows,
            Bitmap.Config.ARGB_8888
        )
        val canvas = Canvas(combinedImage)
        var index = 0
        for (row in 0 until rows) {
            for (col in 0 until cols) {
                if (index == missingIndex) {
                    // Draw a question mark or placeholder
                    val questionMark = BitmapFactory.decodeResource(
                        context.resources,
                        R.drawable.question_mark
                    )
                    val resizedQuestionMark = Bitmap.createScaledBitmap(
                        questionMark,
                        blockWidth,
                        blockHeight,
                        true
                    )
                    canvas.drawBitmap(
                        resizedQuestionMark,
                        (col * blockWidth).toFloat(),
                        (row * blockHeight).toFloat(),
                        null
                    )
                } else {
                    canvas.drawBitmap(
                        imageBlocks[index],
                        (col * blockWidth).toFloat(),
                        (row * blockHeight).toFloat(),
                        null
                    )
                }
                index++
            }
        }
        return combinedImage
    }

    private fun getOptions(imageBlocks: List<Bitmap>, missingIndex: Int): List<Bitmap> {
        val options = mutableListOf<Bitmap>()
        options.add(imageBlocks[missingIndex]) // Correct piece

        // Get indices of other pieces excluding the missing one
        val otherIndices = (0 until imageBlocks.size).filter { it != missingIndex }.shuffled()

        // Add two other random pieces
        options.add(imageBlocks[otherIndices[0]])
        options.add(imageBlocks[otherIndices[1]])

        // Shuffle the options
        return options.shuffled()
    }
}
