package ch.epfl.esl.connect2wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.support.wearable.activity.WearableActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import java.util.List;

public class MainActivity extends WearableActivity {
    private static final String TAG = "MainActivity";
    private WifiManager mWifiManager;
    private Button btn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mWifiManager = (WifiManager) getApplicationContext().getSystemService(Context.WIFI_SERVICE);

        btn = findViewById(R.id.connect);

        // Enables Always-on
        setAmbientEnabled();
    }

    @Override
    protected void onResume() {
        super.onResume();

        // Add broadcast receiver to track WifiManager status changes
        //IntentFilter mWifiIntentFilter = new IntentFilter();
        //mWifiIntentFilter.addAction(WifiManager.SUPPLICANT_STATE_CHANGED_ACTION);
        //mWifiIntentFilter.addAction(WifiManager.SUPPLICANT_CONNECTION_CHANGE_ACTION);
        //registerReceiver(mBroadcastReceiver, mWifiIntentFilter);
    }

    @Override
    protected void onPause() {
        super.onPause();

        // Clear broadcast receiver
        //unregisterReceiver(mBroadcastReceiver);
    }

//    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {
//        @Override
//        public void onReceive(Context context, Intent intent) {
//            final String action = intent.getAction();
//            final String BRTAG = "MainActivity Receiver";
//
//            assert action != null;
//            switch (action) {
//                case WifiManager.SUPPLICANT_STATE_CHANGED_ACTION:
//                    Log.d(BRTAG, "SUPPLICANT_STATE_CHANGED_ACTION: " + mWifiManager.getConnectionInfo().toString());
//                    btn.setText(mWifiManager.getConnectionInfo().getSupplicantState().toString());
//                    if(mWifiManager.getConnectionInfo().getSupplicantState().equals(SupplicantState.DISCONNECTED)) btn.setEnabled(true);
//                    if (intent.hasExtra(WifiManager.EXTRA_SUPPLICANT_ERROR)) {
//                        Log.d(BRTAG, " → EXTRA_SUPPLICANT_ERROR: " + intent.getIntExtra(WifiManager.EXTRA_SUPPLICANT_ERROR, Integer.MIN_VALUE));
//                    } else {
//                        Log.d(BRTAG, " → NO EXTRA_SUPPLICANT_ERROR");
//                    }
//                    break;
//                case WifiManager.SUPPLICANT_CONNECTION_CHANGE_ACTION:
//                    Log.d(BRTAG, "SUPPLICANT CONNEXION CHANGE: " + mWifiManager.getConnectionInfo().toString());
//                    break;
//                default:
//                    Log.w(BRTAG, "Unknown action: " + action);
//                    break;
//            }
//        }
//    };

    public void onButtonConnectClicked(View view) {
        btn.setEnabled(false);

        String username = ((EditText) findViewById(R.id.username)).getText().toString();
        String password = ((EditText) findViewById(R.id.password)).getText().toString();

        List<WifiConfiguration> configuredNetworks = mWifiManager.getConfiguredNetworks();
        for (WifiConfiguration wifiConfiguration : configuredNetworks) {
            switch (wifiConfiguration.SSID) {
                case "\"eduroam\"":
                case "\"epfl\"":
                    mWifiManager.removeNetwork(wifiConfiguration.networkId);
                    Log.w(TAG, "Removing existing configuration:\n" + wifiConfiguration.SSID + "(" + wifiConfiguration.networkId + ")");
            }
        }

        setupAndConnect2Wifi("\"epfl\"", username, password);
        setupAndConnect2Wifi("\"eduroam\"", username + "@epfl.ch", password);
        getConnexionInfo();
        btn.setText(R.string.configuration_done);
    }

    void setupAndConnect2Wifi(String wifiname, String username, String password) {
        WifiConfiguration EPFLwifiConfig = new WifiConfiguration();
        EPFLwifiConfig.SSID = wifiname;
        EPFLwifiConfig.BSSID = "any";
        EPFLwifiConfig.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.WPA_EAP);
        EPFLwifiConfig.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.IEEE8021X);

        WifiEnterpriseConfig enterpriseConfig = new WifiEnterpriseConfig();
        enterpriseConfig.setIdentity(username);
        enterpriseConfig.setPassword(password);
        enterpriseConfig.setPhase2Method(0);
        enterpriseConfig.setEapMethod(WifiEnterpriseConfig.Eap.PEAP);
        enterpriseConfig.setAnonymousIdentity("anonymous@epfl.ch");

        EPFLwifiConfig.enterpriseConfig = enterpriseConfig;

        int networkID = mWifiManager.addNetwork(EPFLwifiConfig);
        mWifiManager.saveConfiguration();

        if (mWifiManager.enableNetwork(networkID, true)) {
            Log.i(TAG, "enableNetwork succeeded");
        } else {
            Log.e(TAG, "enableNetwork failed");
        }
    }

    public void getConnexionInfo() {
        Log.i(TAG, "WIFI ENABLED: " + mWifiManager.isWifiEnabled());
        Log.i(TAG, "WIFI STATE: " + mWifiManager.getWifiState());
        Log.i(TAG, "CONFIGURED NETWORKS: " + mWifiManager.getConfiguredNetworks());
        Log.i(TAG, "CONNEXION STATUS: " + mWifiManager.getConnectionInfo());
    }
}
