package com.epfl.esl.sportstracker

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import co.yml.charts.common.model.Point
import com.google.android.gms.wearable.DataClient
import com.google.android.gms.wearable.DataEvent
import com.google.android.gms.wearable.DataEventBuffer
import com.google.android.gms.wearable.DataMapItem

class ExerciseLiveViewModel : ViewModel(), DataClient.OnDataChangedListener {
    private val _heartRate = MutableLiveData<Int>(0)
    private val _heartRateList = ArrayList<Point>()
    private val _heartRateListLiveData = MutableLiveData<List<Point>>()
    val heartRate: LiveData<Int>
        get() = _heartRate
    val heartRateList: LiveData<List<Point>>
        get() = _heartRateListLiveData

    override fun onDataChanged(dataEvents: DataEventBuffer) {
        dataEvents
            .filter { it.type == DataEvent.TYPE_CHANGED && it.dataItem.uri.path == "/heart_rate" }
            .forEach { event ->
                val newValue = DataMapItem.fromDataItem(event.dataItem).dataMap.getInt("HEART_RATE")

                _heartRate.value = newValue

                val x = _heartRateList.size
                _heartRateList.add(Point(x.toFloat(), newValue.toFloat()))

                _heartRateListLiveData.value = _heartRateList
            }
    }
}