package com.epfl.esl.sportstracker

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query


@Dao
interface HRDao {

    @Insert
    suspend fun insert(HREntityLine: HREntity)

    @Query("DELETE FROM heart_rate_values_table")
    suspend fun clear()

    @Query("SELECT * FROM heart_rate_values_table ORDER BY time_stamps")
    suspend fun getAllHRValues(): List<HREntity>

    @Query("SELECT COUNT(*) FROM heart_rate_values_table")
    suspend fun size(): Int

}




