package com.epfl.esl.sportstracker

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

@Composable
fun SessionItemRow(sessionItem: SessionItem, modifier: Modifier = Modifier) {
    Card(
        colors = CardDefaults.cardColors(containerColor = MaterialTheme.colorScheme.surfaceVariant),
        modifier = modifier.fillMaxWidth(),
    ) {
        Column(modifier.padding(8.dp)) {
            Text(
                text = sessionItem.activity ?: "",
                style = TextStyle(fontSize = 20.sp, color = Color.Black)
            )
            Text(text = sessionItem.registrationTime ?: "")
            Text(text = sessionItem.device ?: "")
        }
    }
}

@Preview
@Composable
fun SessionItemRowPreview() {
    MaterialTheme {
        val sessionItem = SessionItem("Running", "registration time", "Smartwatch or Belt")
        SessionItemRow(sessionItem = sessionItem, Modifier.padding(8.dp))
    }
}