package com.epfl.esl.sportstracker

import android.bluetooth.BluetoothAdapter
import androidx.annotation.DrawableRes
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.FirebaseDatabase
import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Locale
import java.util.Random

class NewRecordingViewModel : ViewModel() {
    val bluetoothAdapter: BluetoothAdapter? = BluetoothAdapter.getDefaultAdapter()

    private val database: FirebaseDatabase = FirebaseDatabase.getInstance()
    private val profileRef: DatabaseReference = database.getReference("Profiles")

    private var _selectedSport = MutableLiveData<SPORT>(SPORT.NO_SPORT)
    val selectedSport: LiveData<SPORT>
        get() = _selectedSport

    fun updateSelectedSport(sport: SPORT, userKey: String, device: DEVICE) {
        _selectedSport.postValue(sport)

        val activityKey: String = Random().nextInt().toString()
        val rightNow = Calendar.getInstance()
        val df = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.UK)
        val formattedDate: String = df.format(rightNow.time)

        profileRef.child(userKey).child("Activities").child(activityKey)
            .child("activity").setValue(sport.activity)
        profileRef.child(userKey).child("Activities").child(activityKey)
            .child("registrationTime").setValue(formattedDate)
        profileRef.child(userKey).child("Activities").child(activityKey)
            .child("device").setValue(device.value)
    }
}

enum class SPORT(val activity: String, @DrawableRes val imageResource: Int) {
    RUNNING("Running", R.drawable.running),
    CYCLING("Cycling", R.drawable.cycling),
    SKIING("Skiing", R.drawable.skiing),
    CLIMBING("Climbing", R.drawable.climbing),
    NO_SPORT("Select activity", R.drawable.no_activity)
}