def interpret(env: Map[Identifier, Boolean]): Boolean = this match {
  case Var(id) => env(id)
  case BooleanLiteral(b) => b
  case Equal(e1, e2) => e1.interpret(env) == e2.interpret(env)
  case Implies(e1, e2) => !e1.interpret(env) || e2.interpret(env)
  case $\lstred{And}$(e1, e2) => e1.interpret(env) && e2.interpret(env)
  case Or(e1, e2) => e1.interpret(env) || e2.interpret(env)
  case Xor(e1, e2) => e1.interpret(env) ^ e2.interpret(env)
  case Not(e) => !e.interpret(env)
}