/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ptolemy.gui.PanelDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.Message;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class PlotFrame
extends Frame {
    public PlotBox plot;
    protected MenuBar _menubar = new MenuBar();
    protected Menu _editMenu = new Menu("Edit");
    protected Menu _fileMenu = new Menu("File");
    protected Menu _specialMenu = new Menu("Special");
    protected String _directory = null;
    protected String _filename = null;

    public PlotFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotFrame(String string) {
        this(string, (PlotBox)null);
    }

    public PlotFrame(String string, PlotBox plotBox) {
        super(string);
        this.plot = plotBox == null ? new Plot() : plotBox;
        MenuItem[] menuItemArray = new MenuItem[]{new MenuItem("Open", new MenuShortcut(79)), new MenuItem("Save", new MenuShortcut(83)), new MenuItem("SaveAs", new MenuShortcut(65)), new MenuItem("Export", new MenuShortcut(69)), new MenuItem("Print", new MenuShortcut(80)), new MenuItem("Close", new MenuShortcut(87))};
        FileMenuListener fileMenuListener = new FileMenuListener();
        int n = 0;
        while (n < menuItemArray.length) {
            menuItemArray[n].setActionCommand(menuItemArray[n].getLabel());
            menuItemArray[n].addActionListener(fileMenuListener);
            this._fileMenu.add(menuItemArray[n]);
            ++n;
        }
        this._menubar.add(this._fileMenu);
        MenuItem menuItem = new MenuItem("Format");
        FormatListener formatListener = new FormatListener();
        menuItem.addActionListener(formatListener);
        this._editMenu.add(menuItem);
        this._menubar.add(this._editMenu);
        MenuItem[] menuItemArray2 = new MenuItem[]{new MenuItem("About", null), new MenuItem("Help", new MenuShortcut(72)), new MenuItem("Clear", new MenuShortcut(82)), new MenuItem("Fill", new MenuShortcut(70)), new MenuItem("Sample plot", null)};
        SpecialMenuListener specialMenuListener = new SpecialMenuListener();
        int n2 = 0;
        while (n2 < menuItemArray2.length) {
            menuItemArray2[n2].setActionCommand(menuItemArray2[n2].getLabel());
            menuItemArray2[n2].addActionListener(specialMenuListener);
            this._specialMenu.add(menuItemArray2[n2]);
            ++n2;
        }
        this._menubar.add(this._specialMenu);
        this.setMenuBar(this._menubar);
        this.add("Center", this.plot);
        ((Component)this).setSize(500, 300);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotFrame class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 3.1, Build: $Id: PlotFrame.java,v 1.34 1999/08/19 15:32:27 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-1999, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _close() {
        this.dispose();
    }

    protected void _editFormat() {
        int n;
        Object object;
        Serializable serializable;
        Object object2;
        Vector[] vectorArray;
        JPanel jPanel = new JPanel(new BorderLayout());
        final Query query = new Query();
        jPanel.add((Component)query, "West");
        final Query query2 = new Query();
        jPanel.add((Component)query2, "East");
        query.setTextWidth(20);
        String string = this.plot.getTitle();
        query.addLine("title", "Title", string);
        String string2 = this.plot.getXLabel();
        query.addLine("xlabel", "X Label", string2);
        String string3 = this.plot.getYLabel();
        query.addLine("ylabel", "Y Label", string3);
        double[] dArray = this.plot.getXRange();
        query.addLine("xrange", "X Range", dArray[0] + ", " + dArray[1]);
        double[] dArray2 = this.plot.getYRange();
        query.addLine("yrange", "Y Range", dArray2[0] + ", " + dArray2[1]);
        String[] stringArray = new String[]{"none", "points", "dots", "various"};
        String string4 = "none";
        if (this.plot instanceof Plot) {
            string4 = ((Plot)this.plot).getMarksStyle();
            query.addRadioButtons("marks", "Marks", stringArray, string4);
        }
        Vector[] vectorArray2 = this.plot.getXTicks();
        String string5 = "";
        if (vectorArray2 != null) {
            vectorArray = new StringBuffer();
            object2 = vectorArray2[0];
            serializable = vectorArray2[1];
            int n2 = 0;
            while (n2 < ((Vector)serializable).size()) {
                if (vectorArray.length() > 0) {
                    vectorArray.append(", ");
                }
                vectorArray.append(((Vector)serializable).elementAt(n2).toString());
                vectorArray.append(" ");
                vectorArray.append(((Vector)object2).elementAt(n2).toString());
                ++n2;
            }
            string5 = vectorArray.toString();
        }
        query.addLine("xticks", "X Ticks", string5);
        vectorArray = this.plot.getYTicks();
        object2 = "";
        if (vectorArray != null) {
            serializable = new StringBuffer();
            Vector vector = vectorArray[0];
            object = vectorArray[1];
            n = 0;
            while (n < ((Vector)object).size()) {
                if (((StringBuffer)serializable).length() > 0) {
                    ((StringBuffer)serializable).append(", ");
                }
                ((StringBuffer)serializable).append(((Vector)object).elementAt(n).toString());
                ((StringBuffer)serializable).append(" ");
                ((StringBuffer)serializable).append(vector.elementAt(n).toString());
                n += 1;
            }
            object2 = ((StringBuffer)serializable).toString();
        }
        query.addLine("yticks", "Y Ticks", (String)object2);
        boolean bl = this.plot.getGrid();
        query2.addCheckBox("grid", "Grid", bl);
        boolean bl2 = false;
        object = null;
        if (this.plot instanceof Plot) {
            bl2 = ((Plot)this.plot).getImpulses();
            query2.addCheckBox("stems", "Stems", bl2);
            object = this._getConnected();
            query2.addCheckBox("connected", "Connect", ((Plot)this.plot).getConnected());
        }
        n = this.plot.getColor() ? 1 : 0;
        query2.addCheckBox("color", "Use Color", n != 0);
        query.addQueryListener(new QueryListener(){

            public void changed(String string) {
                if (string.equals("title")) {
                    PlotFrame.this.plot.setTitle(query.stringValue("title"));
                } else if (string.equals("xlabel")) {
                    PlotFrame.this.plot.setXLabel(query.stringValue("xlabel"));
                } else if (string.equals("ylabel")) {
                    PlotFrame.this.plot.setYLabel(query.stringValue("ylabel"));
                } else if (string.equals("xrange")) {
                    PlotFrame.this.plot.read("XRange: " + query.stringValue("xrange"));
                } else if (string.equals("xticks")) {
                    String string2 = query.stringValue("xticks").trim();
                    PlotFrame.this.plot.read("XTicks: " + string2);
                } else if (string.equals("yticks")) {
                    String string3 = query.stringValue("yticks").trim();
                    PlotFrame.this.plot.read("YTicks: " + string3);
                } else if (string.equals("yrange")) {
                    PlotFrame.this.plot.read("YRange: " + query.stringValue("yrange"));
                } else if (string.equals("marks")) {
                    ((Plot)PlotFrame.this.plot).setMarksStyle(query.stringValue("marks"));
                }
                PlotFrame.this.plot.repaint();
            }
        });
        query2.addQueryListener(new QueryListener(){

            public void changed(String string) {
                if (string.equals("grid")) {
                    plot.setGrid(query2.booleanValue("grid"));
                } else if (string.equals("stems")) {
                    ((Plot)plot).setImpulses(query2.booleanValue("stems"));
                    plot.repaint();
                } else if (string.equals("color")) {
                    plot.setColor(query2.booleanValue("color"));
                } else if (string.equals("connected")) {
                    this._setConnected(query2.booleanValue("connected"));
                }
                plot.repaint();
            }
        });
        String[] stringArray2 = new String[]{"Apply", "Cancel"};
        PanelDialog panelDialog = new PanelDialog((Frame)this, "Set plot format", jPanel, stringArray2);
        if (panelDialog.buttonPressed().equals("Apply")) {
            this.plot.setTitle(query.stringValue("title"));
            this.plot.setXLabel(query.stringValue("xlabel"));
            this.plot.setYLabel(query.stringValue("ylabel"));
            this.plot.read("XRange: " + query.stringValue("xrange"));
            this.plot.read("YRange: " + query.stringValue("yrange"));
            this.plot.setGrid(query2.booleanValue("grid"));
            this.plot.setColor(query2.booleanValue("color"));
            if (this.plot instanceof Plot) {
                Plot plot = (Plot)this.plot;
                plot.setMarksStyle(query.stringValue("marks"));
                plot.setImpulses(query2.booleanValue("stems"));
                this._setConnected(query2.booleanValue("connected"));
            }
        } else {
            this.plot.setTitle(string);
            this.plot.setXLabel(string2);
            this.plot.setYLabel(string3);
            this.plot.setXRange(dArray[0], dArray[1]);
            this.plot.setYRange(dArray2[0], dArray2[1]);
            this.plot.setGrid(bl);
            this.plot.setColor(n != 0);
            if (this.plot instanceof Plot) {
                Plot plot = (Plot)this.plot;
                plot.setMarksStyle(string4);
                plot.setImpulses(bl2);
                this._restoreConnected((boolean[][])object);
            }
        }
        this.plot.repaint();
    }

    protected void _export() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Export EPS to...");
        if (this._directory != null) {
            fileDialog.setDirectory(this._directory);
        }
        fileDialog.setFile("plot.eps");
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        String string2 = fileDialog.getDirectory();
        File file = new File(string2, string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.plot.export(fileOutputStream);
        }
        catch (IOException iOException) {
            Message message = new Message("Error exporting plot: " + iOException);
        }
    }

    private boolean[][] _getConnected() {
        Vector vector = ((Plot)this.plot)._points;
        boolean[][] blArray = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArray[n] = new boolean[vector2.size()];
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                blArray[n][n2] = plotPoint.connected;
                ++n2;
            }
            ++n;
        }
        return blArray;
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotFrame is a plot in a top-level window.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.", "About Ptolemy Plot", 1);
    }

    protected void _open() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select a plot file");
        if (this._directory != null) {
            fileDialog.setDirectory(this._directory);
        }
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        this._directory = fileDialog.getDirectory();
        File file = new File(this._directory, string);
        String string2 = file.getParent();
        if (string2 != null) {
            this._directory = String.valueOf(string2) + File.separator;
        }
        this._filename = null;
        try {
            this.plot.clear(true);
            this._read(new URL("file", null, this._directory), new FileInputStream(file));
            this.plot.repaint();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "File not found:\n" + fileNotFoundException.toString(), "Ptolemy Plot Error", 2);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error reading input:\n" + iOException.toString(), "Ptolemy Plot Error", 2);
        }
        this._filename = string;
    }

    protected void _print() {
        PrintJob printJob = this.getToolkit().getPrintJob(this, this.getTitle(), null);
        if (printJob != null) {
            try {
                Graphics graphics = printJob.getGraphics();
                if (graphics != null) {
                    try {
                        this.plot.printAll(graphics);
                    }
                    finally {
                        Object var6_3 = null;
                        graphics.dispose();
                    }
                }
                Object var3_6 = null;
                printJob.end();
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                printJob.end();
                throw throwable;
            }
        }
    }

    protected void _read(URL uRL, InputStream inputStream) throws IOException {
        this.plot.read(inputStream);
    }

    private void _restoreConnected(boolean[][] blArray) {
        Vector vector = ((Plot)this.plot)._points;
        boolean[][] blArray2 = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArray2[n] = new boolean[vector2.size()];
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                plotPoint.connected = blArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    protected void _save() {
        if (this._filename != null) {
            File file = new File(this._directory, this._filename);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.plot.write(fileOutputStream);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error writing file:\n" + iOException.toString(), "Ptolemy Plot Error", 2);
            }
        } else {
            this._saveAs();
        }
    }

    protected void _saveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save plot as...");
        if (this._directory != null) {
            fileDialog.setDirectory(this._directory);
        }
        fileDialog.setFile("plot.xml");
        ((Component)fileDialog).setVisible(true);
        this._filename = fileDialog.getFile();
        if (this._filename == null) {
            return;
        }
        this._directory = fileDialog.getDirectory();
        this._save();
    }

    private void _setConnected(boolean bl) {
        Vector vector = ((Plot)this.plot)._points;
        ((Plot)this.plot).setConnected(bl);
        boolean[][] blArray = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArray[n] = new boolean[vector2.size()];
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                plotPoint.connected = bl && !bl2;
                bl2 = false;
                ++n2;
            }
            ++n;
        }
    }

    public void samplePlot() {
        this._filename = null;
        this._directory = null;
        this.plot.samplePlot();
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getActionCommand();
            if (string.equals("Open")) {
                PlotFrame.this._open();
            } else if (string.equals("Save")) {
                PlotFrame.this._save();
            } else if (string.equals("SaveAs")) {
                PlotFrame.this._saveAs();
            } else if (string.equals("Export")) {
                PlotFrame.this._export();
            } else if (string.equals("Print")) {
                PlotFrame.this._print();
            } else if (string.equals("Close")) {
                PlotFrame.this._close();
            }
        }
    }

    class FormatListener
    implements ActionListener {
        FormatListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotFrame.this._editFormat();
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        SpecialMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getActionCommand();
            if (string.equals("About")) {
                PlotFrame.this._about();
            } else if (string.equals("Help")) {
                PlotFrame.this._help();
            } else if (string.equals("Fill")) {
                PlotFrame.this.plot.fillPlot();
            } else if (string.equals("Clear")) {
                PlotFrame.this.plot.clear(false);
                PlotFrame.this.plot.repaint();
            } else if (string.equals("Sample plot")) {
                PlotFrame.this.plot.clear(true);
                PlotFrame.this.samplePlot();
            }
        }
    }
}

