/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.games;

import uchicago.src.sim.games.GameChoice;

public class PayoffMatrix {
    private float[] matrix;
    private int cols;

    public PayoffMatrix(int n, int n2) {
        this(n, n2, 0);
    }

    public PayoffMatrix(int n, int n2, int n3) {
        this.matrix = new float[n * n2 * 2];
        this.cols = n2;
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = 0.0f;
        }
    }

    public float getRowPayoff(int n, int n2) {
        return this.matrix[n * 2 * this.cols + n2 * 2];
    }

    public float getColPayoff(int n, int n2) {
        return this.matrix[n * 2 * this.cols + n2 * 2 + 1];
    }

    public float getRowPayoff(GameChoice gameChoice, GameChoice gameChoice2) {
        return this.getRowPayoff(gameChoice.val, gameChoice2.val);
    }

    public float getColPayoff(GameChoice gameChoice, GameChoice gameChoice2) {
        return this.getColPayoff(gameChoice.val, gameChoice2.val);
    }

    public void setPayoff(int n, int n2, float f, float f2) {
        this.matrix[n * 2 * this.cols + n2 * 2] = f;
        this.matrix[n * 2 * this.cols + n2 * 2 + 1] = f2;
    }
}

