/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui.components;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import uchicago.src.sim.engine.gui.components.EnhancedTableModel;

public class EnhancedJTable
extends JTable {
    public static final String revision = "$Revision: 1.3 $";
    EnhancedTableModel anEnhancedTableModel;

    public EnhancedJTable(final EnhancedTableModel enhancedTableModel, int n) {
        super(enhancedTableModel);
        this.anEnhancedTableModel = enhancedTableModel;
        this.anEnhancedTableModel.setEnhancedJTable(this);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    int[] nArray = EnhancedJTable.this.getSelectedRows();
                    if (nArray.length >= 1) {
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            enhancedTableModel.removeRow(i);
                        }
                    } else if (nArray.length == 1) {
                        enhancedTableModel.setValueAt(null, nArray[0], EnhancedJTable.this.getSelectedColumn());
                    }
                    enhancedTableModel.fireTableDataChanged();
                } else if (keyEvent.getKeyCode() == 10) {
                    TableCellEditor tableCellEditor = EnhancedJTable.this.getCellEditor();
                    if (EnhancedJTable.this.isEditing() && tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                        enhancedTableModel.fireTableDataChanged();
                    }
                } else {
                    super.keyPressed(keyEvent);
                }
            }
        });
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.fixColumnSizing(this, n);
    }

    protected void fixColumnSizing(int n, int n2) {
        TableColumn tableColumn = null;
        tableColumn = this.getColumnModel().getColumn(n);
        if (tableColumn.getPreferredWidth() < n2 + 10) {
            tableColumn.setPreferredWidth(n2 + 10);
        }
    }

    private void fixColumnSizing(JTable jTable, int n) {
        jTable.setAutoResizeMode(0);
        TableColumn tableColumn = null;
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(n);
        }
    }
}

